/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.ActiveDirectoryFault;
import com.vmware.vim25.AuthMinimumAdminPermission;
import com.vmware.vim25.FileNotFound;
import com.vmware.vim25.HostConfigFault;
import com.vmware.vim25.InvalidLogin;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.TaskInProgress;
import com.vmware.vim25.mo.HostDirectoryStore;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.Task;
import java.rmi.RemoteException;

public class HostActiveDirectoryAuthentication
extends HostDirectoryStore {
    public HostActiveDirectoryAuthentication(ServerConnection sc, ManagedObjectReference mor) {
        super(sc, mor);
    }

    public Task importCertificateForCAM_Task(String certPath, String camServer) throws FileNotFound, ActiveDirectoryFault, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().importCertificateForCAM_Task(this.getMOR(), certPath, camServer);
        return new Task(this.getServerConnection(), mor);
    }

    public Task joinDomain_Task(String domainName, String userName, String password) throws InvalidState, HostConfigFault, InvalidLogin, ActiveDirectoryFault, TaskInProgress, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().joinDomain_Task(this.getMOR(), domainName, userName, password);
        return new Task(this.getServerConnection(), mor);
    }

    public Task joinDomainWithCAM_Task(String domainName, String camServer) throws InvalidState, HostConfigFault, ActiveDirectoryFault, TaskInProgress, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().joinDomainWithCAM_Task(this.getMOR(), domainName, camServer);
        return new Task(this.getServerConnection(), mor);
    }

    public Task leaveCurrentDomain_Task(boolean force) throws InvalidState, AuthMinimumAdminPermission, ActiveDirectoryFault, TaskInProgress, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().leaveCurrentDomain_Task(this.getMOR(), force);
        return new Task(this.getServerConnection(), mor);
    }

    public void disableSmartCardAuthentication() throws ActiveDirectoryFault, HostConfigFault, RuntimeFault, RemoteException {
        this.getVimService().disableSmartCardAuthentication(this.getMOR());
    }

    public void enableSmartCardAuthentication() throws ActiveDirectoryFault, HostConfigFault, RuntimeFault, RemoteException {
        this.getVimService().disableSmartCardAuthentication(this.getMOR());
    }

    public void installSmartCardTrustAnchor(String cert) throws HostConfigFault, RuntimeFault, RemoteException {
        this.getVimService().installSmartCardTrustAnchor(this.getMOR(), cert);
    }

    public String[] listSmartCardTrustAnchors() throws HostConfigFault, RuntimeFault, RemoteException {
        return this.getVimService().listSmartCardTrustAnchors(this.getMOR());
    }

    public void removeSmartCardTrustAnchor(String issuer, String serial) throws HostConfigFault, RuntimeFault, RemoteException {
        this.getVimService().removeSmartCardTrustAnchor(this.getMOR(), issuer, serial);
    }

    public void removeSmartCardTrustAnchorByFingerprint(String fingerprint, String digest) throws HostConfigFault, RuntimeFault, RemoteException {
        this.getVimService().removeSmartCardTrustAnchorByFingerprint(this.getMOR(), fingerprint, digest);
    }

    public void replaceSmartCardTrustAnchors(String[] certs) throws RuntimeFault, RemoteException {
        this.getVimService().replaceSmartCardTrustAnchors(this.getMOR(), certs);
    }

    public void replaceSmartCardTrustAnchors() throws RuntimeFault, RemoteException {
        this.replaceSmartCardTrustAnchors(null);
    }
}

