/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.cf;

import com.vmware.vim.cf.DeepCopier;
import com.vmware.vim.cf.ManagedObjectCache;
import com.vmware.vim.cf.ManagedObjectWatcher;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ServiceInstance;
import java.util.Map;

public class CacheInstance {
    ServiceInstance si;
    ManagedObjectWatcher mom;
    ManagedObjectCache cache;
    Thread mThread = null;

    public CacheInstance(ServiceInstance si) {
        this.si = si;
        this.mom = new ManagedObjectWatcher(si.getPropertyCollector());
        this.cache = new ManagedObjectCache(si);
        this.mom.addObserver(this.cache);
    }

    public void watch(ManagedObject[] mos, String[] props) {
        this.mom.watch(mos, props);
    }

    public void watch(PropertyFilterSpec pfs) {
        this.mom.watch(pfs);
    }

    public Object getCopy(ManagedObject mo, String propName) {
        Object obj = this.get(mo.getMOR(), propName);
        try {
            obj = DeepCopier.deepCopy(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return obj;
    }

    public Object getCopy(ManagedObjectReference mor, String propName) {
        return this.getCopy(mor, propName);
    }

    public Object get(ManagedObject mo, String propName) {
        return this.get(mo.getMOR(), propName);
    }

    public Object get(ManagedObjectReference mor, String propName) {
        Map<ManagedObjectReference, Map<String, Object>> items = this.cache.getCachedItems();
        Map<String, Object> moMap = items.get(mor);
        if (moMap != null) {
            return moMap.get(propName);
        }
        return null;
    }

    public void start() {
        this.mThread = new Thread(this.mom);
        this.mThread.setName("MonitorThead for " + this.si.getServerConnection().getUrl());
        this.mThread.start();
    }

    public void destroy() {
        this.mom.cleanUp();
        this.mThread.stop();
        this.si = null;
        this.mom = null;
        this.cache = null;
        this.mThread = null;
    }

    public ServiceInstance getServiceInstance() {
        return this.si;
    }

    public boolean isReady() {
        return this.cache.isReady();
    }
}

