/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.adapters;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jdom.JDOMException;
import org.jdom.adapters.AbstractDOMAdapter;
import org.jdom.input.BuilderErrorHandler;
import org.w3c.dom.Document;

public class JAXPDOMAdapter
extends AbstractDOMAdapter {
    @Override
    public Document getDocument(InputStream in, boolean validate) throws JDOMException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validate);
            factory.setNamespaceAware(true);
            DocumentBuilder jaxpParser = factory.newDocumentBuilder();
            jaxpParser.setErrorHandler(new BuilderErrorHandler());
            return jaxpParser.parse(in);
        }
        catch (Exception e) {
            throw new JDOMException("Reflection failed while parsing a document with JAXP", e);
        }
    }

    @Override
    public Document createDocument() throws JDOMException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder newDocBuilder = factory.newDocumentBuilder();
            return newDocBuilder.newDocument();
        }
        catch (Exception e) {
            throw new JDOMException("Reflection failed while creating new JAXP document", e);
        }
    }
}

