/*
 * Decompiled with CFR 0.152.
 */
package com.app.hubert.guide.model;

import android.graphics.RectF;
import android.support.annotation.ColorInt;
import android.support.annotation.LayoutRes;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.animation.Animation;
import com.app.hubert.guide.listener.OnLayoutInflatedListener;
import com.app.hubert.guide.model.HighLight;
import com.app.hubert.guide.model.HighlightRectF;
import com.app.hubert.guide.model.HighlightView;
import com.app.hubert.guide.model.RelativeGuide;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GuidePage {
    private List<HighLight> highLights = new ArrayList<HighLight>();
    private List<RelativeGuide> relativeGuides = new ArrayList<RelativeGuide>();
    private boolean everywhereCancelable = true;
    private int backgroundColor;
    private int layoutResId;
    private int[] clickToDismissIds;
    private OnLayoutInflatedListener onLayoutInflatedListener;
    private Animation enterAnimation;
    private Animation exitAnimation;

    public static GuidePage newInstance() {
        return new GuidePage();
    }

    public GuidePage addHighLight(View view) {
        return this.addHighLight(view, HighLight.Shape.RECTANGLE, 0, 0, null);
    }

    public GuidePage addHighLight(View view, RelativeGuide relativeGuide) {
        return this.addHighLight(view, HighLight.Shape.RECTANGLE, 0, 0, relativeGuide);
    }

    public GuidePage addHighLight(View view, HighLight.Shape shape) {
        return this.addHighLight(view, shape, 0, 0, null);
    }

    public GuidePage addHighLight(View view, HighLight.Shape shape, RelativeGuide relativeGuide) {
        return this.addHighLight(view, shape, 0, 0, relativeGuide);
    }

    public GuidePage addHighLight(View view, HighLight.Shape shape, int padding) {
        return this.addHighLight(view, shape, 0, padding, null);
    }

    public GuidePage addHighLight(View view, HighLight.Shape shape, int padding, RelativeGuide relativeGuide) {
        return this.addHighLight(view, shape, 0, padding, relativeGuide);
    }

    public GuidePage addHighLight(View view, HighLight.Shape shape, int round, int padding, @Nullable RelativeGuide relativeGuide) {
        HighlightView highlight = HighlightView.newInstance(view).setShape(shape).setRound(round).setPadding(padding);
        this.highLights.add(highlight);
        if (relativeGuide != null) {
            relativeGuide.highLight = highlight;
            this.relativeGuides.add(relativeGuide);
        }
        return this;
    }

    public GuidePage addHighLight(RectF rectF) {
        return this.addHighLight(rectF, HighLight.Shape.RECTANGLE, 0, null);
    }

    public GuidePage addHighLight(RectF rectF, RelativeGuide relativeGuide) {
        return this.addHighLight(rectF, HighLight.Shape.RECTANGLE, 0, relativeGuide);
    }

    public GuidePage addHighLight(RectF rectF, HighLight.Shape shape) {
        return this.addHighLight(rectF, shape, 0, null);
    }

    public GuidePage addHighLight(RectF rectF, HighLight.Shape shape, RelativeGuide relativeGuide) {
        return this.addHighLight(rectF, shape, 0, relativeGuide);
    }

    public GuidePage addHighLight(RectF rectF, HighLight.Shape shape, int round) {
        return this.addHighLight(rectF, shape, round, null);
    }

    public GuidePage addHighLight(RectF rectF, HighLight.Shape shape, int round, @Nullable RelativeGuide relativeGuide) {
        HighlightRectF highlight = new HighlightRectF(rectF, shape, round);
        this.highLights.add(highlight);
        if (relativeGuide != null) {
            relativeGuide.highLight = highlight;
            this.relativeGuides.add(relativeGuide);
        }
        return this;
    }

    @Deprecated
    public GuidePage addHighLight(HighLight ... highLights) {
        this.highLights.addAll(Arrays.asList(highLights));
        return this;
    }

    @Deprecated
    public GuidePage addHighLight(List<HighLight> list) {
        this.highLights.addAll(list);
        return this;
    }

    public GuidePage setLayoutRes(@LayoutRes int resId, int ... id2) {
        this.layoutResId = resId;
        this.clickToDismissIds = id2;
        return this;
    }

    public GuidePage setEverywhereCancelable(boolean everywhereCancelable) {
        this.everywhereCancelable = everywhereCancelable;
        return this;
    }

    public GuidePage setBackgroundColor(@ColorInt int backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public GuidePage setOnLayoutInflatedListener(OnLayoutInflatedListener onLayoutInflatedListener) {
        this.onLayoutInflatedListener = onLayoutInflatedListener;
        return this;
    }

    public GuidePage setEnterAnimation(Animation enterAnimation) {
        this.enterAnimation = enterAnimation;
        return this;
    }

    public GuidePage setExitAnimation(Animation exitAnimation) {
        this.exitAnimation = exitAnimation;
        return this;
    }

    public boolean isEverywhereCancelable() {
        return this.everywhereCancelable;
    }

    public boolean isEmpty() {
        return this.layoutResId == 0 && this.highLights.size() == 0 && this.relativeGuides.size() == 0;
    }

    public List<HighLight> getHighLights() {
        return this.highLights;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getLayoutResId() {
        return this.layoutResId;
    }

    public int[] getClickToDismissIds() {
        return this.clickToDismissIds;
    }

    public OnLayoutInflatedListener getOnLayoutInflatedListener() {
        return this.onLayoutInflatedListener;
    }

    public Animation getEnterAnimation() {
        return this.enterAnimation;
    }

    public Animation getExitAnimation() {
        return this.exitAnimation;
    }

    public List<RelativeGuide> getRelativeGuides() {
        return this.relativeGuides;
    }
}

