/*
 * Decompiled with CFR 0.152.
 */
package com.app.hubert.guide.model;

import android.support.annotation.ColorInt;
import android.support.annotation.LayoutRes;
import android.view.View;
import android.view.animation.Animation;
import com.app.hubert.guide.listener.OnLayoutInflatedListener;
import com.app.hubert.guide.model.HighLight;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GuidePage {
    private List<HighLight> highLights = new ArrayList<HighLight>();
    private boolean everywhereCancelable = true;
    private int backgroundColor;
    private int layoutResId;
    private int[] clickToDismissIds;
    private OnLayoutInflatedListener onLayoutInflatedListener;
    private Animation enterAnimation;
    private Animation exitAnimation;

    public static GuidePage newInstance() {
        return new GuidePage();
    }

    public GuidePage addHighLight(View view) {
        return this.addHighLight(view, HighLight.Shape.RECTANGLE, 0, 0);
    }

    public GuidePage addHighLight(View view, HighLight.Shape shape) {
        return this.addHighLight(view, shape, 0, 0);
    }

    public GuidePage addHighLight(View view, HighLight.Shape shape, int padding) {
        return this.addHighLight(view, shape, 0, padding);
    }

    public GuidePage addHighLight(View view, HighLight.Shape shape, int round, int padding) {
        this.highLights.add(HighLight.newInstance(view).setShape(shape).setRound(round).setPadding(padding));
        return this;
    }

    public GuidePage addHighLight(HighLight ... highLights) {
        this.highLights.addAll(Arrays.asList(highLights));
        return this;
    }

    public GuidePage addHighLight(List<HighLight> list) {
        this.highLights.addAll(list);
        return this;
    }

    public GuidePage setLayoutRes(@LayoutRes int resId, int ... id2) {
        this.layoutResId = resId;
        this.clickToDismissIds = id2;
        return this;
    }

    public GuidePage setEverywhereCancelable(boolean everywhereCancelable) {
        this.everywhereCancelable = everywhereCancelable;
        return this;
    }

    public GuidePage setBackgroundColor(@ColorInt int backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public GuidePage setOnLayoutInflatedListener(OnLayoutInflatedListener onLayoutInflatedListener) {
        this.onLayoutInflatedListener = onLayoutInflatedListener;
        return this;
    }

    public GuidePage setEnterAnimation(Animation enterAnimation) {
        this.enterAnimation = enterAnimation;
        return this;
    }

    public GuidePage setExitAnimation(Animation exitAnimation) {
        this.exitAnimation = exitAnimation;
        return this;
    }

    public boolean isEverywhereCancelable() {
        return this.everywhereCancelable;
    }

    public boolean isEmpty() {
        return this.layoutResId == 0 && this.highLights.size() == 0;
    }

    public List<HighLight> getHighLights() {
        return this.highLights;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getLayoutResId() {
        return this.layoutResId;
    }

    public int[] getClickToDismissIds() {
        return this.clickToDismissIds;
    }

    public OnLayoutInflatedListener getOnLayoutInflatedListener() {
        return this.onLayoutInflatedListener;
    }

    public Animation getEnterAnimation() {
        return this.enterAnimation;
    }

    public Animation getExitAnimation() {
        return this.exitAnimation;
    }
}

