/*
 * Decompiled with CFR 0.152.
 */
package com.app.hubert.guide.model;

import android.graphics.RectF;
import android.view.View;
import com.app.hubert.guide.util.LogUtil;

public class HighLight {
    private View mHole;
    private Shape shape = Shape.RECTANGLE;
    private int round;
    private int padding;

    public static HighLight newInstance(View view) {
        return new HighLight(view);
    }

    private HighLight(View hole) {
        this.mHole = hole;
    }

    public HighLight setShape(Shape shape) {
        this.shape = shape;
        return this;
    }

    public HighLight setRound(int round) {
        this.round = round;
        return this;
    }

    public HighLight setPadding(int padding) {
        this.padding = padding;
        return this;
    }

    public int getPadding() {
        return this.padding;
    }

    public Shape getShape() {
        return this.shape;
    }

    public int getRound() {
        return this.round;
    }

    public int getRadius() {
        return this.mHole != null ? Math.max(this.mHole.getWidth() / 2, this.mHole.getHeight() / 2) : 0;
    }

    public RectF getRectF() {
        RectF rectF = new RectF();
        int[] location = new int[2];
        this.mHole.getLocationOnScreen(location);
        rectF.left = location[0] - this.padding;
        rectF.top = location[1] - this.padding;
        rectF.right = location[0] + this.mHole.getWidth() + this.padding * 2;
        rectF.bottom = location[1] + this.mHole.getHeight() + this.padding * 2;
        LogUtil.i(this.mHole.getClass().getSimpleName() + "'s location:" + rectF);
        return rectF;
    }

    public static enum Shape {
        CIRCLE,
        RECTANGLE,
        OVAL,
        ROUND_RECTANGLE;

    }
}

