/*
 * Decompiled with CFR 0.152.
 */
package com.app.hubert.guide.core;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.v4.app.FragmentManager;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.app.hubert.guide.core.Builder;
import com.app.hubert.guide.core.GuideLayout;
import com.app.hubert.guide.lifecycle.FragmentLifecycleAdapter;
import com.app.hubert.guide.lifecycle.ListenerFragment;
import com.app.hubert.guide.lifecycle.V4ListenerFragment;
import com.app.hubert.guide.listener.OnGuideChangedListener;
import com.app.hubert.guide.listener.OnLayoutInflatedListener;
import com.app.hubert.guide.listener.OnPageChangedListener;
import com.app.hubert.guide.model.GuidePage;
import com.app.hubert.guide.util.LogUtil;
import com.app.hubert.guide.util.ScreenUtils;
import java.lang.reflect.Field;
import java.util.List;

public class Controller {
    private static final String LISTENER_FRAGMENT = "listener_fragment";
    private Fragment fragment;
    private android.support.v4.app.Fragment v4Fragment;
    private Activity activity;
    private OnGuideChangedListener onGuideChangedListener;
    private OnPageChangedListener onPageChangedListener;
    private String label;
    private boolean alwaysShow;
    private List<GuidePage> guidePages;
    private int current;
    private GuideLayout currentLayout;
    private FrameLayout mParentView;
    private SharedPreferences sp;
    private int topMargin;

    public Controller(Builder builder) {
        this.activity = builder.activity;
        this.fragment = builder.fragment;
        this.v4Fragment = builder.v4Fragment;
        this.onGuideChangedListener = builder.onGuideChangedListener;
        this.onPageChangedListener = builder.onPageChangedListener;
        this.label = builder.label;
        this.alwaysShow = builder.alwaysShow;
        this.guidePages = builder.guidePages;
        this.mParentView = (FrameLayout)this.activity.getWindow().getDecorView();
        this.sp = this.activity.getSharedPreferences("NewbieGuide", 0);
    }

    public void show() {
        boolean showed;
        if (!this.alwaysShow && (showed = this.sp.getBoolean(this.label, false))) {
            return;
        }
        this.activity.getWindow().setFlags(0x1000000, 0x1000000);
        this.mParentView.post(new Runnable(){

            @Override
            public void run() {
                Controller.this.getTopMargin();
                if (Controller.this.guidePages == null || Controller.this.guidePages.size() == 0) {
                    throw new IllegalStateException("there is no guide to show!! Please add alast one Page.");
                }
                Controller.this.current = 0;
                Controller.this.showGuidePage();
                if (Controller.this.onGuideChangedListener != null) {
                    Controller.this.onGuideChangedListener.onShowed(Controller.this);
                }
                Controller.this.addListenerFragment();
                Controller.this.sp.edit().putBoolean(Controller.this.label, true).apply();
            }
        });
    }

    private void showGuidePage() {
        GuidePage page = this.guidePages.get(this.current);
        GuideLayout guideLayout = new GuideLayout((Context)this.activity);
        guideLayout.setGuidePage(page);
        this.addCustomToLayout(guideLayout, page);
        guideLayout.setOnGuideLayoutDismissListener(new GuideLayout.OnGuideLayoutDismissListener(){

            @Override
            public void onGuideLayoutDismiss(GuideLayout guideLayout) {
                if (Controller.this.current < Controller.this.guidePages.size() - 1) {
                    Controller.this.current++;
                    Controller.this.showGuidePage();
                    if (Controller.this.onPageChangedListener != null) {
                        Controller.this.onPageChangedListener.onPageChanged(Controller.this.current);
                    }
                } else {
                    if (Controller.this.onGuideChangedListener != null) {
                        Controller.this.onGuideChangedListener.onRemoved(Controller.this);
                    }
                    Controller.this.removeListenerFragment();
                }
            }
        });
        this.mParentView.addView((View)guideLayout, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.currentLayout = guideLayout;
    }

    private void addCustomToLayout(final GuideLayout guideLayout, GuidePage guidePage) {
        guideLayout.removeAllViews();
        int layoutResId = guidePage.getLayoutResId();
        if (layoutResId != 0) {
            OnLayoutInflatedListener inflatedListener;
            View view = LayoutInflater.from((Context)this.activity).inflate(layoutResId, (ViewGroup)guideLayout, false);
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
            params.topMargin = this.topMargin;
            params.bottomMargin = ScreenUtils.getNavigationBarHeight(this.activity);
            int[] viewIds = guidePage.getClickToDismissIds();
            if (viewIds != null && viewIds.length > 0) {
                for (int viewId : viewIds) {
                    View click = view.findViewById(viewId);
                    if (click != null) {
                        click.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                guideLayout.remove();
                            }
                        });
                        continue;
                    }
                    Log.w((String)"NewbieGuide", (String)("can't find the view by id : " + viewId + " which used to remove guide page"));
                }
            }
            if ((inflatedListener = guidePage.getOnLayoutInflatedListener()) != null) {
                inflatedListener.onLayoutInflated(view);
            }
            guideLayout.addView(view, (ViewGroup.LayoutParams)params);
        }
    }

    private void getTopMargin() {
        View contentView = this.activity.findViewById(0x1020002);
        int[] location = new int[2];
        contentView.getLocationOnScreen(location);
        this.topMargin = location[1];
        LogUtil.i("contentView top:" + this.topMargin);
    }

    public void resetLabel() {
        this.resetLabel(this.label);
    }

    public void resetLabel(String label) {
        this.sp.edit().putBoolean(label, false).apply();
    }

    public void remove() {
        if (this.currentLayout != null && this.currentLayout.getParent() != null) {
            ((ViewGroup)this.currentLayout.getParent()).removeView((View)this.currentLayout);
            if (this.onGuideChangedListener != null) {
                this.onGuideChangedListener.onRemoved(this);
            }
        }
    }

    private void addListenerFragment() {
        if (this.fragment != null && Build.VERSION.SDK_INT > 16) {
            this.compatibleFragment(this.fragment);
            android.app.FragmentManager fm = this.fragment.getChildFragmentManager();
            ListenerFragment listenerFragment = (ListenerFragment)fm.findFragmentByTag(LISTENER_FRAGMENT);
            if (listenerFragment == null) {
                listenerFragment = new ListenerFragment();
                fm.beginTransaction().add((Fragment)listenerFragment, LISTENER_FRAGMENT).commitAllowingStateLoss();
            }
            listenerFragment.setFragmentLifecycle(new FragmentLifecycleAdapter(){

                @Override
                public void onDestroyView() {
                    LogUtil.i("ListenerFragment.onDestroyView");
                    Controller.this.remove();
                }
            });
        }
        if (this.v4Fragment != null) {
            FragmentManager v4Fm = this.v4Fragment.getChildFragmentManager();
            V4ListenerFragment v4ListenerFragment = (V4ListenerFragment)v4Fm.findFragmentByTag(LISTENER_FRAGMENT);
            if (v4ListenerFragment == null) {
                v4ListenerFragment = new V4ListenerFragment();
                v4Fm.beginTransaction().add((android.support.v4.app.Fragment)v4ListenerFragment, LISTENER_FRAGMENT).commitAllowingStateLoss();
            }
            v4ListenerFragment.setFragmentLifecycle(new FragmentLifecycleAdapter(){

                @Override
                public void onDestroyView() {
                    LogUtil.i("v4ListenerFragment.onDestroyView");
                    Controller.this.remove();
                }
            });
        }
    }

    private void removeListenerFragment() {
        FragmentManager v4Fm;
        V4ListenerFragment v4ListenerFragment;
        android.app.FragmentManager fm;
        ListenerFragment listenerFragment;
        if (this.fragment != null && Build.VERSION.SDK_INT > 16 && (listenerFragment = (ListenerFragment)(fm = this.fragment.getChildFragmentManager()).findFragmentByTag(LISTENER_FRAGMENT)) != null) {
            fm.beginTransaction().remove((Fragment)listenerFragment).commitAllowingStateLoss();
        }
        if (this.v4Fragment != null && (v4ListenerFragment = (V4ListenerFragment)(v4Fm = this.v4Fragment.getChildFragmentManager()).findFragmentByTag(LISTENER_FRAGMENT)) != null) {
            v4Fm.beginTransaction().remove((android.support.v4.app.Fragment)v4ListenerFragment).commitAllowingStateLoss();
        }
    }

    private void compatibleFragment(Fragment fragment) {
        try {
            Field childFragmentManager = Fragment.class.getDeclaredField("mChildFragmentManager");
            childFragmentManager.setAccessible(true);
            childFragmentManager.set(fragment, null);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

