/*
 * Decompiled with CFR 0.152.
 */
package com.app.hubert.library;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.v4.app.FragmentManager;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.app.hubert.library.Builder;
import com.app.hubert.library.FragmentLifecycleAdapter;
import com.app.hubert.library.GuideLayout;
import com.app.hubert.library.GuidePage;
import com.app.hubert.library.ListenerFragment;
import com.app.hubert.library.OnGuideChangedListener;
import com.app.hubert.library.OnPageChangedListener;
import com.app.hubert.library.ScreenUtils;
import com.app.hubert.library.V4ListenerFragment;
import java.lang.reflect.Field;
import java.util.List;

public class Controller {
    public static final String TAG = "listener_fragment";
    private Fragment fragment;
    private android.support.v4.app.Fragment v4Fragment;
    private Activity activity;
    private OnGuideChangedListener onGuideChangedListener;
    private OnPageChangedListener onPageChangedListener;
    private String label;
    private boolean alwaysShow;
    private List<GuidePage> guidePages;
    private int current;
    private FrameLayout mParentView;
    private GuideLayout guideLayout;
    private SharedPreferences sp;

    public Controller(Builder builder) {
        this.activity = builder.getActivity();
        this.fragment = builder.getFragment();
        this.v4Fragment = builder.getV4Fragment();
        this.onGuideChangedListener = builder.getOnGuideChangedListener();
        this.onPageChangedListener = builder.getOnPageChangedListener();
        this.label = builder.getLabel();
        this.alwaysShow = builder.isAlwaysShow();
        this.guidePages = builder.getGuidePages();
        this.mParentView = (FrameLayout)this.activity.getWindow().getDecorView();
        this.guideLayout = new GuideLayout((Context)this.activity);
        this.sp = this.activity.getSharedPreferences("NewbieGuide", 0);
    }

    public int show() {
        boolean showed;
        if (!this.alwaysShow && (showed = this.sp.getBoolean(this.label, false))) {
            return -1;
        }
        this.activity.getWindow().setFlags(0x1000000, 0x1000000);
        if (this.guidePages != null && this.guidePages.size() > 0) {
            this.current = 0;
            GuidePage page = this.guidePages.get(0);
            this.updatePage(page);
            this.mParentView.addView((View)this.guideLayout, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            if (this.onGuideChangedListener != null) {
                this.onGuideChangedListener.onShowed(this);
            }
            if (this.onPageChangedListener != null) {
                this.onPageChangedListener.onPageChanged(this.current);
            }
        } else {
            throw new IllegalStateException();
        }
        this.sp.edit().putBoolean(this.label, true).apply();
        this.guideLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (((GuidePage)Controller.this.guidePages.get(Controller.this.current)).isEveryWhereCancelable()) {
                    Controller.this.nextOrRemove();
                }
            }
        });
        this.addListenerFragment();
        return 1;
    }

    private void nextOrRemove() {
        if (this.current < this.guidePages.size() - 1) {
            this.updatePage(this.guidePages.get(++this.current));
            if (this.onPageChangedListener != null) {
                this.onPageChangedListener.onPageChanged(this.current);
            }
        } else {
            this.remove();
        }
    }

    private void addListenerFragment() {
        if (this.fragment != null && Build.VERSION.SDK_INT > 16) {
            this.compatibleFragment(this.fragment);
            android.app.FragmentManager fm = this.fragment.getChildFragmentManager();
            ListenerFragment listenerFragment = (ListenerFragment)fm.findFragmentByTag(TAG);
            if (listenerFragment == null) {
                listenerFragment = new ListenerFragment();
                fm.beginTransaction().add((Fragment)listenerFragment, TAG).commitAllowingStateLoss();
            }
            listenerFragment.setFragmentLifecycle(new FragmentLifecycleAdapter(){

                @Override
                public void onDestroyView() {
                    Log.i((String)"NewbieGuide", (String)"ListenerFragment.onDestroyView");
                    Controller.this.remove();
                }
            });
        }
        if (this.v4Fragment != null && Build.VERSION.SDK_INT > 16) {
            FragmentManager v4Fm = this.v4Fragment.getChildFragmentManager();
            V4ListenerFragment v4ListenerFragment = (V4ListenerFragment)v4Fm.findFragmentByTag(TAG);
            if (v4ListenerFragment == null) {
                v4ListenerFragment = new V4ListenerFragment();
                v4Fm.beginTransaction().add((android.support.v4.app.Fragment)v4ListenerFragment, TAG).commitAllowingStateLoss();
            }
            v4ListenerFragment.setFragmentLifecycle(new FragmentLifecycleAdapter(){

                @Override
                public void onDestroyView() {
                    Log.i((String)"NewbieGuide", (String)"v4ListenerFragment.onDestroyView");
                    Controller.this.remove();
                }
            });
        }
    }

    private void updatePage(GuidePage page) {
        this.guideLayout.setHighLights(page.getHighLights());
        this.guideLayout.setBackgroundColor(page.getBackgroundColor());
        this.guideLayout.removeAllViews();
        if (page.getLayoutResId() != 0) {
            View view = LayoutInflater.from((Context)this.activity).inflate(page.getLayoutResId(), (ViewGroup)this.guideLayout, false);
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
            if (!page.isFullScreen()) {
                params.topMargin = ScreenUtils.getStatusBarHeight((Context)this.activity);
            }
            params.bottomMargin = ScreenUtils.getNavigationBarHeight(this.activity);
            int[] viewIds = page.getViewIds();
            if (viewIds != null) {
                for (int viewId : viewIds) {
                    View click = view.findViewById(viewId);
                    if (click != null) {
                        click.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                Controller.this.nextOrRemove();
                            }
                        });
                        continue;
                    }
                    Log.e((String)"NewbieGuide", (String)("can't find the view by id : " + viewId + " which used to remove guide layout"));
                }
            }
            this.guideLayout.addView(view, (ViewGroup.LayoutParams)params);
        }
        this.guideLayout.invalidate();
    }

    public void resetLabel() {
        this.resetLabel(this.label);
    }

    public void resetLabel(String label) {
        this.sp.edit().putBoolean(label, false).apply();
    }

    public void remove() {
        if (this.guideLayout != null && this.guideLayout.getParent() != null) {
            ((ViewGroup)this.guideLayout.getParent()).removeView((View)this.guideLayout);
            if (this.onGuideChangedListener != null) {
                this.onGuideChangedListener.onRemoved(this);
            }
        }
        this.removeListenerFragment();
    }

    private void removeListenerFragment() {
        FragmentManager v4Fm;
        V4ListenerFragment v4ListenerFragment;
        android.app.FragmentManager fm;
        ListenerFragment listenerFragment;
        if (this.fragment != null && Build.VERSION.SDK_INT > 16 && (listenerFragment = (ListenerFragment)(fm = this.fragment.getChildFragmentManager()).findFragmentByTag(TAG)) != null) {
            fm.beginTransaction().remove((Fragment)listenerFragment).commitAllowingStateLoss();
        }
        if (this.v4Fragment != null && Build.VERSION.SDK_INT > 16 && (v4ListenerFragment = (V4ListenerFragment)(v4Fm = this.v4Fragment.getChildFragmentManager()).findFragmentByTag(TAG)) != null) {
            v4Fm.beginTransaction().remove((android.support.v4.app.Fragment)v4ListenerFragment).commitAllowingStateLoss();
        }
    }

    private void compatibleFragment(Fragment fragment) {
        try {
            Field childFragmentManager = Fragment.class.getDeclaredField("mChildFragmentManager");
            childFragmentManager.setAccessible(true);
            childFragmentManager.set(fragment, null);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

