/*
 * Decompiled with CFR 0.152.
 */
package com.app.hubert.library;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.app.hubert.library.Builder;
import com.app.hubert.library.GuideLayout;
import com.app.hubert.library.HighLight;
import com.app.hubert.library.OnGuideChangedListener;
import com.app.hubert.library.ScreenUtils;
import java.util.ArrayList;
import java.util.List;

public class Controller {
    private Activity activity;
    private List<HighLight> list = new ArrayList<HighLight>();
    private OnGuideChangedListener onGuideChangedListener;
    private boolean everyWhereCancelable = true;
    private int backgroundColor;
    private String label;
    private boolean alwaysShow;
    private int layoutResId;
    private int[] viewIds;
    private FrameLayout mParentView;
    private GuideLayout guideLayout;
    private SharedPreferences sp;

    public Controller(Builder builder) {
        this.activity = builder.getActivity();
        this.list = builder.getList();
        this.backgroundColor = builder.getBackgroundColor();
        this.onGuideChangedListener = builder.getOnGuideChangedListener();
        this.everyWhereCancelable = builder.isEveryWhereCancelable();
        this.label = builder.getLabel();
        this.alwaysShow = builder.isAlwaysShow();
        this.layoutResId = builder.getLayoutResId();
        this.viewIds = builder.getViewIds();
        this.mParentView = (FrameLayout)this.activity.getWindow().getDecorView();
        this.sp = this.activity.getSharedPreferences("NewbieGuide", 0);
    }

    public int show() {
        boolean showed;
        if (!this.alwaysShow && (showed = this.sp.getBoolean(this.label, false))) {
            return -1;
        }
        this.guideLayout = new GuideLayout((Context)this.activity);
        this.guideLayout.setHighLights(this.list);
        if (this.backgroundColor != 0) {
            this.guideLayout.setBackgroundColor(this.backgroundColor);
        }
        if (this.layoutResId > 0) {
            View view = LayoutInflater.from((Context)this.activity).inflate(this.layoutResId, (ViewGroup)this.guideLayout, false);
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
            params.topMargin = ScreenUtils.getStatusBarHeight((Context)this.activity);
            params.bottomMargin = ScreenUtils.getNavigationBarHeight(this.activity);
            if (this.viewIds != null) {
                for (int viewId : this.viewIds) {
                    view.findViewById(viewId).setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            Controller.this.remove();
                        }
                    });
                }
            }
            this.guideLayout.addView(view, (ViewGroup.LayoutParams)params);
        }
        this.mParentView.addView((View)this.guideLayout, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        if (this.onGuideChangedListener != null) {
            this.onGuideChangedListener.onShowed(this);
        }
        this.sp.edit().putBoolean(this.label, true).apply();
        if (this.everyWhereCancelable) {
            this.guideLayout.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    Controller.this.remove();
                    return false;
                }
            });
        }
        return 1;
    }

    public void resetLabel(String label) {
        this.sp.edit().putBoolean(label, false).apply();
    }

    public void remove() {
        if (this.guideLayout != null && this.guideLayout.getParent() != null) {
            ((ViewGroup)this.guideLayout.getParent()).removeView((View)this.guideLayout);
            if (this.onGuideChangedListener != null) {
                this.onGuideChangedListener.onRemoved(this);
            }
        }
    }
}

