/*
 * Decompiled with CFR 0.152.
 */
package com.app.hubert.library;

import android.app.Activity;
import android.app.Fragment;
import android.text.TextUtils;
import android.view.View;
import com.app.hubert.library.Controller;
import com.app.hubert.library.GuidePage;
import com.app.hubert.library.HighLight;
import com.app.hubert.library.OnGuideChangedListener;
import com.app.hubert.library.OnPageChangedListener;
import java.util.ArrayList;
import java.util.List;

public class Builder {
    private Activity activity;
    private Fragment fragment;
    private android.support.v4.app.Fragment v4Fragment;
    private String label;
    private boolean alwaysShow;
    private OnGuideChangedListener onGuideChangedListener;
    private OnPageChangedListener onPageChangedListener;
    private List<GuidePage> guidePages = new ArrayList<GuidePage>();
    private GuidePage currentPage = new GuidePage();

    public Builder(Activity activity) {
        this.activity = activity;
    }

    public Builder(Fragment fragment) {
        this.fragment = fragment;
        this.activity = fragment.getActivity();
    }

    public Builder(android.support.v4.app.Fragment v4Fragment) {
        this.v4Fragment = v4Fragment;
        this.activity = v4Fragment.getActivity();
    }

    public Builder addHighLight(View view) {
        return this.addHighLight(view, HighLight.Type.RECTANGLE, 0);
    }

    public Builder addHighLight(View view, HighLight.Type type) {
        return this.addHighLight(view, type, 0);
    }

    public Builder addHighLight(View view, HighLight.Type type, int round) {
        this.currentPage.addHighLight(view, type, round);
        return this;
    }

    public Builder addHighLights(List<HighLight> list) {
        this.currentPage.addHighLights(list);
        return this;
    }

    public Builder setBackgroundColor(int color) {
        this.currentPage.setBackgroundColor(color);
        return this;
    }

    public Builder setEveryWhereCancelable(boolean cancelable) {
        this.currentPage.setEveryWhereCancelable(cancelable);
        return this;
    }

    public Builder alwaysShow(boolean b) {
        this.alwaysShow = b;
        return this;
    }

    public Builder setLayoutRes(int resId, int ... id) {
        this.currentPage.setLayoutRes(resId, id);
        return this;
    }

    public Builder fullScreen(boolean isFullScreen) {
        this.currentPage.setFullScreen(isFullScreen);
        return this;
    }

    public Builder asPage() {
        this.guidePages.add(this.currentPage);
        this.currentPage = new GuidePage();
        return this;
    }

    public Builder setOnGuideChangedListener(OnGuideChangedListener listener) {
        this.onGuideChangedListener = listener;
        return this;
    }

    public Builder setOnPageChangedListener(OnPageChangedListener onPageChangedListener) {
        this.onPageChangedListener = onPageChangedListener;
        return this;
    }

    public Builder setLabel(String label) {
        this.label = label;
        return this;
    }

    public Controller build() {
        if (TextUtils.isEmpty((CharSequence)this.label)) {
            throw new IllegalArgumentException("\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570\uff1alabel,\u901a\u8fc7setLabel()\u65b9\u6cd5\u8bbe\u7f6e");
        }
        if (!this.guidePages.contains(this.currentPage) && !this.currentPage.isEmpty()) {
            this.guidePages.add(this.currentPage);
        }
        return new Controller(this);
    }

    public Controller show() {
        if (TextUtils.isEmpty((CharSequence)this.label)) {
            throw new IllegalArgumentException("\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570\uff1alabel,\u901a\u8fc7setLabel()\u65b9\u6cd5\u8bbe\u7f6e");
        }
        if (!this.guidePages.contains(this.currentPage) && !this.currentPage.isEmpty()) {
            this.guidePages.add(this.currentPage);
        }
        Controller controller = new Controller(this);
        controller.show();
        return controller;
    }

    boolean isAlwaysShow() {
        return this.alwaysShow;
    }

    String getLabel() {
        return this.label;
    }

    Activity getActivity() {
        return this.activity;
    }

    OnGuideChangedListener getOnGuideChangedListener() {
        return this.onGuideChangedListener;
    }

    OnPageChangedListener getOnPageChangedListener() {
        return this.onPageChangedListener;
    }

    Fragment getFragment() {
        return this.fragment;
    }

    android.support.v4.app.Fragment getV4Fragment() {
        return this.v4Fragment;
    }

    public List<GuidePage> getGuidePages() {
        return this.guidePages;
    }
}

