/*
 * Decompiled with CFR 0.152.
 */
package com.app.hubert.library;

import android.app.Activity;
import android.text.TextUtils;
import android.view.View;
import com.app.hubert.library.Controller;
import com.app.hubert.library.HighLight;
import com.app.hubert.library.OnGuideChangedListener;
import java.util.ArrayList;
import java.util.List;

public class Builder {
    private Activity activity;
    private List<HighLight> list = new ArrayList<HighLight>();
    private OnGuideChangedListener onGuideChangedListener;
    private boolean everyWhereCancelable = true;
    private int backgroundColor;
    private String label;
    private boolean alwaysShow;
    private int layoutResId;
    private int[] viewIds;

    public Builder(Activity activity) {
        this.activity = activity;
    }

    public Builder addHighLight(View view) {
        return this.addHighLight(view, HighLight.Type.RECTANGLE, 0);
    }

    public Builder addHighLight(View view, HighLight.Type type) {
        return this.addHighLight(view, type, 0);
    }

    public Builder addHighLight(View view, HighLight.Type type, int round) {
        HighLight highLight = new HighLight(view, type);
        if (round > 0) {
            highLight.setRound(round);
        }
        this.list.add(highLight);
        return this;
    }

    public Builder addHighLight(List<HighLight> list) {
        this.list.addAll(list);
        return this;
    }

    public Builder setBackgroundColor(int color) {
        this.backgroundColor = color;
        return this;
    }

    public Builder setEveryWhereCancelable(boolean cancelable) {
        this.everyWhereCancelable = cancelable;
        return this;
    }

    public Builder setOnGuideChangedListener(OnGuideChangedListener listener) {
        this.onGuideChangedListener = listener;
        return this;
    }

    public Builder setLabel(String label) {
        this.label = label;
        return this;
    }

    public Builder alwaysShow(boolean b) {
        this.alwaysShow = b;
        return this;
    }

    public Builder setLayoutRes(int resId, int ... id) {
        this.layoutResId = resId;
        this.viewIds = id;
        return this;
    }

    public Controller build() {
        if (TextUtils.isEmpty((CharSequence)this.label)) {
            throw new IllegalArgumentException("\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570\uff1alabel,\u901a\u8fc7setLabel()\u65b9\u6cd5\u8bbe\u7f6e");
        }
        return new Controller(this);
    }

    public Controller show() {
        if (TextUtils.isEmpty((CharSequence)this.label)) {
            throw new IllegalArgumentException("\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570\uff1alabel,\u901a\u8fc7setLabel()\u65b9\u6cd5\u8bbe\u7f6e");
        }
        Controller controller = new Controller(this);
        controller.show();
        return controller;
    }

    int getLayoutResId() {
        return this.layoutResId;
    }

    int[] getViewIds() {
        return this.viewIds;
    }

    boolean isAlwaysShow() {
        return this.alwaysShow;
    }

    String getLabel() {
        return this.label;
    }

    Activity getActivity() {
        return this.activity;
    }

    List<HighLight> getList() {
        return this.list;
    }

    OnGuideChangedListener getOnGuideChangedListener() {
        return this.onGuideChangedListener;
    }

    boolean isEveryWhereCancelable() {
        return this.everyWhereCancelable;
    }

    int getBackgroundColor() {
        return this.backgroundColor;
    }
}

