/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.data.table;

import android.graphics.Paint;
import com.bin.david.form.core.SmartTable;
import com.bin.david.form.core.TableConfig;
import com.bin.david.form.data.CellInfo;
import com.bin.david.form.data.CellRange;
import com.bin.david.form.data.column.Column;
import com.bin.david.form.data.form.IForm;
import com.bin.david.form.data.format.draw.IDrawFormat;
import com.bin.david.form.data.format.draw.TextDrawFormat;
import com.bin.david.form.data.table.ArrayTableData;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FormTableData<T extends IForm>
extends ArrayTableData<T> {
    public static <T extends IForm> FormTableData<T> create(SmartTable table, String tableName, int spanSize, T[][] data) {
        IForm[][] newArray = (IForm[][])Array.newInstance(data.getClass().getComponentType(), data.length);
        int[][] exitArray = new int[data.length][spanSize];
        ArrayList<CellRange> cellRanges = new ArrayList<CellRange>();
        for (int i = 0; i < data.length; ++i) {
            T[] rowData = data[i];
            int spanWidthSize = 0;
            for (int j = 0; j < rowData.length; ++j) {
                T t = rowData[j];
                FormTableData.createArrayRow((int)spanSize, (IForm[][])newArray, (int)i, rowData);
                while (exitArray[i][spanWidthSize] == 1) {
                    ++spanWidthSize;
                }
                newArray[i][spanWidthSize] = t;
                if (t.getSpanHeightSize() > 1) {
                    for (int row = i; row < i + t.getSpanHeightSize(); ++row) {
                        for (int col = spanWidthSize; col < spanWidthSize + t.getSpanWidthSize(); ++col) {
                            exitArray[row][col] = 1;
                        }
                    }
                }
                if (t.getSpanWidthSize() > 1 || t.getSpanHeightSize() > 1) {
                    cellRanges.add(new CellRange(i, i + t.getSpanHeightSize() - 1, spanWidthSize, spanWidthSize + t.getSpanWidthSize() - 1));
                }
                spanWidthSize += t.getSpanWidthSize();
            }
        }
        newArray = ArrayTableData.transformColumnArray(newArray);
        FormTableData tableData = FormTableData.createTableData((SmartTable)table, (String)tableName, (IForm[][])newArray, (IDrawFormat)new TextDrawFormat<T>(){

            @Override
            public void setTextPaint(TableConfig config, CellInfo<T> cellInfo, Paint paint) {
                super.setTextPaint(config, cellInfo, paint);
                paint.setTextAlign(cellInfo.data == null ? Paint.Align.CENTER : ((IForm)cellInfo.data).getAlign());
            }
        });
        tableData.setUserCellRange(cellRanges);
        return tableData;
    }

    private static <T extends IForm> void createArrayRow(int spanSize, T[][] newArray, int i, T[] rowData) {
        if (newArray[i] == null) {
            newArray[i] = (IForm[])Array.newInstance(rowData.getClass().getComponentType(), spanSize);
        }
    }

    private static <T extends IForm> FormTableData<T> createTableData(SmartTable table, String tableName, T[][] data, IDrawFormat<T> drawFormat) {
        table.getConfig().setShowColumnTitle(false);
        ArrayList<Column<T>> columns = new ArrayList<Column<T>>();
        for (T[] dataArray : data) {
            Column<T> column = new Column<T>("", null, drawFormat);
            column.setDatas(Arrays.asList(dataArray));
            columns.add(column);
        }
        ArrayList<T> arrayList = new ArrayList<T>(Arrays.asList(data[0]));
        FormTableData<T> tableData = new FormTableData<T>(tableName, arrayList, columns);
        tableData.setData(data);
        return tableData;
    }

    private FormTableData(String tableName, List<T> t, List<Column<T>> columns) {
        super(tableName, t, columns);
    }
}

