/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.data.format.grid;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import com.bin.david.form.data.CellInfo;
import com.bin.david.form.data.column.Column;
import com.bin.david.form.data.format.grid.IGridFormat;

public abstract class BaseAbstractGridFormat
implements IGridFormat {
    private Path path = new Path();

    protected abstract boolean isShowVerticalLine(int var1, int var2, CellInfo var3);

    protected abstract boolean isShowHorizontalLine(int var1, int var2, CellInfo var3);

    protected boolean isShowCountVerticalLine(int col, Column column) {
        return true;
    }

    protected boolean isShowCountHorizontalLine(int col, Column column) {
        return true;
    }

    protected boolean isShowColumnTitleVerticalLine(int col, Column column) {
        return true;
    }

    protected boolean isShowColumnTitleHorizontalLine(int col, Column column) {
        return true;
    }

    protected boolean isShowXSequenceVerticalLine(int col) {
        return true;
    }

    protected boolean isShowXSequenceHorizontalLine(int col) {
        return true;
    }

    protected boolean isShowYSequenceVerticalLine(int row) {
        return true;
    }

    protected boolean isShowYSequenceHorizontalLine(int row) {
        return true;
    }

    @Override
    public void drawContentGrid(Canvas canvas, int col, int row, Rect rect, CellInfo cellInfo, Paint paint) {
        this.drawGridPath(canvas, rect, paint, this.isShowHorizontalLine(col, row, cellInfo), this.isShowVerticalLine(col, row, cellInfo));
    }

    @Override
    public void drawXSequenceGrid(Canvas canvas, int col, Rect rect, Paint paint) {
        this.drawGridPath(canvas, rect, paint, this.isShowXSequenceHorizontalLine(col), this.isShowXSequenceVerticalLine(col));
    }

    @Override
    public void drawYSequenceGrid(Canvas canvas, int row, Rect rect, Paint paint) {
        this.drawGridPath(canvas, rect, paint, this.isShowYSequenceHorizontalLine(row), this.isShowYSequenceVerticalLine(row));
    }

    @Override
    public void drawCountGrid(Canvas canvas, int col, Rect rect, Column column, Paint paint) {
        this.drawGridPath(canvas, rect, paint, this.isShowCountHorizontalLine(col, column), this.isShowCountVerticalLine(col, column));
    }

    @Override
    public void drawColumnTitleGrid(Canvas canvas, Rect rect, Column column, int col, Paint paint) {
        this.drawGridPath(canvas, rect, paint, this.isShowColumnTitleHorizontalLine(col, column), this.isShowColumnTitleVerticalLine(col, column));
    }

    @Override
    public void drawTableBorderGrid(Canvas canvas, int left, int top, int right, int bottom, Paint paint) {
        canvas.drawRect((float)left, (float)top, (float)right, (float)bottom, paint);
    }

    @Override
    public void drawLeftAndTopGrid(Canvas canvas, Rect rect, Paint paint) {
        canvas.drawRect(rect, paint);
    }

    protected void drawGridPath(Canvas canvas, Rect rect, Paint paint, boolean isShowHorizontal, boolean isShowVertical) {
        this.path.rewind();
        if (isShowHorizontal) {
            this.path.moveTo((float)rect.left, (float)rect.top);
            this.path.lineTo((float)rect.right, (float)rect.top);
        }
        if (isShowVertical) {
            if (!isShowHorizontal) {
                this.path.moveTo((float)rect.right, (float)rect.top);
            }
            this.path.lineTo((float)rect.right, (float)rect.bottom);
        }
        if (isShowHorizontal || isShowVertical) {
            canvas.drawPath(this.path, paint);
        }
    }
}

