/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.data.column;

import com.bin.david.form.data.ArrayStructure;
import com.bin.david.form.data.TableInfo;
import com.bin.david.form.data.column.Column;
import com.bin.david.form.data.column.ColumnNode;
import com.bin.david.form.data.format.IFormat;
import com.bin.david.form.data.format.draw.IDrawFormat;
import java.lang.reflect.Field;
import java.util.List;

public class ArrayColumn<T>
extends Column<T> {
    public static final int ARRAY = 1;
    public static final int LIST = 2;
    private ColumnNode node;
    private ArrayStructure structure = new ArrayStructure();
    private int arrayType;
    private boolean isThoroughArray = false;

    public ArrayColumn(String columnName, String fieldName) {
        this(columnName, fieldName, true, null, null);
    }

    public ArrayColumn(String columnName, String fieldName, boolean isThoroughArray) {
        this(columnName, fieldName, isThoroughArray, null, null);
    }

    public ArrayColumn(String columnName, String fieldName, boolean isThoroughArray, IFormat<T> format) {
        this(columnName, fieldName, isThoroughArray, format, null);
    }

    public ArrayColumn(String columnName, String fieldName, boolean isThoroughArray, IDrawFormat<T> drawFormat) {
        this(columnName, fieldName, isThoroughArray, null, drawFormat);
    }

    public ArrayColumn(String columnName, String fieldName, boolean isThoroughArray, IFormat<T> format, IDrawFormat<T> drawFormat) {
        super(columnName, fieldName, format, drawFormat);
        this.isThoroughArray = isThoroughArray;
    }

    @Override
    public void fillData(List<Object> objects) throws NoSuchFieldException, IllegalAccessException {
        String[] fieldNames;
        this.structure.clear();
        this.structure.setMaxLevel(this.getLevel());
        if (this.getCountFormat() != null) {
            this.getCountFormat().clearCount();
        }
        if (objects.size() > 0 && (fieldNames = this.getFieldName().split("\\.")).length > 0) {
            int size = objects.size();
            for (int k = 0; k < size; ++k) {
                Object child = objects.get(k);
                this.getFieldData(fieldNames, 0, child, 0, true);
            }
        }
    }

    @Override
    public void addData(List<Object> objects, int startPosition, boolean isFoot) throws NoSuchFieldException, IllegalAccessException {
        String[] fieldNames;
        if (objects.size() > 0 && (fieldNames = this.getFieldName().split("\\.")).length > 0) {
            int size = objects.size();
            for (int k = 0; k < size; ++k) {
                Object child = objects.get(isFoot ? k : size - 1 - k);
                this.getFieldData(fieldNames, 0, child, 0, true);
            }
        }
    }

    protected void getFieldData(String[] fieldNames, int start, Object child, int level, boolean isFoot) throws NoSuchFieldException, IllegalAccessException {
        for (int i = start; i < fieldNames.length; ++i) {
            Object[] data;
            if (child == null) {
                this.addData(null, isFoot);
                this.countColumnValue(null);
                this.structure.putNull(level, isFoot);
                break;
            }
            Class<?> childClazz = child.getClass();
            Field childField = childClazz.getDeclaredField(fieldNames[i]);
            childField.setAccessible(true);
            child = childField.get(child);
            if (!ArrayColumn.isList(child)) {
                if (i != fieldNames.length - 1) continue;
                if (child == null) {
                    this.structure.putNull(level, isFoot);
                }
                Object t = child;
                this.addData(t, true);
                this.countColumnValue(t);
                continue;
            }
            ++level;
            if (child.getClass().isArray()) {
                data = (Object[])child;
                this.arrayType = 1;
                for (Object d : data) {
                    if (i == fieldNames.length - 1) {
                        this.addData(d, true);
                        continue;
                    }
                    this.getFieldData(fieldNames, i + 1, d, level, true);
                }
                this.structure.put(level - 1, data.length, isFoot);
                break;
            }
            data = (Object[])child;
            this.arrayType = 2;
            for (Object e : data) {
                if (i == fieldNames.length - 1) {
                    Object t = e;
                    this.addData(t, true);
                    continue;
                }
                this.getFieldData(fieldNames, i + 1, e, level, true);
            }
            this.structure.put(level - 1, data.size(), isFoot);
            break;
        }
    }

    public static boolean isList(Object o) {
        return o != null && (o instanceof List || o.getClass().isArray());
    }

    @Override
    public int getLevel() {
        return ColumnNode.getLevel(this.node, 0) - 1;
    }

    public ColumnNode getNode() {
        return this.node;
    }

    public void setNode(ColumnNode node) {
        this.node = node;
    }

    public int getArrayType() {
        return this.arrayType;
    }

    public void setArrayType(int arrayType) {
        this.arrayType = arrayType;
    }

    public ArrayStructure getStructure() {
        return this.structure;
    }

    public void setStructure(ArrayStructure structure) {
        this.structure = structure;
    }

    public boolean isThoroughArray() {
        return this.isThoroughArray;
    }

    public void setThoroughArray(boolean thoroughArray) {
        this.isThoroughArray = thoroughArray;
    }

    @Override
    public int getSeizeCellSize(TableInfo tableInfo, int position) {
        return this.structure.getCellSizes().get(position);
    }
}

