/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.component;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import com.bin.david.form.component.IComponent;
import com.bin.david.form.core.TableConfig;
import com.bin.david.form.data.CellInfo;
import com.bin.david.form.data.TableInfo;
import com.bin.david.form.data.format.bg.ICellBackgroundFormat;
import com.bin.david.form.data.format.draw.LeftTopDrawFormat;
import com.bin.david.form.data.format.sequence.ISequenceFormat;
import com.bin.david.form.data.table.TableData;
import com.bin.david.form.utils.DrawUtils;

public class YSequence<T>
implements IComponent<TableData<T>> {
    private Rect rect = new Rect();
    private int width;
    private int clipWidth;
    private Rect scaleRect;
    private ISequenceFormat format;
    private Rect tempRect = new Rect();

    @Override
    public void onMeasure(Rect scaleRect, Rect showRect, TableConfig config) {
        this.scaleRect = scaleRect;
        int scaleWidth = (int)((float)this.width * (config.getZoom() > 1.0f ? 1.0f : config.getZoom()));
        boolean fixed = config.isFixedYSequence();
        this.rect.top = scaleRect.top;
        this.rect.bottom = scaleRect.bottom;
        this.rect.left = fixed ? showRect.left : scaleRect.left;
        this.rect.right = this.rect.left + scaleWidth;
        if (fixed) {
            scaleRect.left += scaleWidth;
            showRect.left += scaleWidth;
            this.clipWidth = scaleWidth;
        } else {
            int disX = showRect.left - scaleRect.left;
            this.clipWidth = Math.max(0, scaleWidth - disX);
            showRect.left += this.clipWidth;
            scaleRect.left += scaleWidth;
        }
    }

    @Override
    public void onDraw(Canvas canvas, Rect showRect, TableData<T> tableData, TableConfig config) {
        this.format = tableData.getYSequenceFormat();
        float hZoom = config.getZoom() > 1.0f ? 1.0f : config.getZoom();
        int totalSize = tableData.getLineSize();
        TableInfo info = tableData.getTableInfo();
        int topHeight = info.getTopHeight(hZoom);
        float top = this.rect.top + topHeight;
        int showLeft = showRect.left - this.clipWidth;
        boolean isFixTop = config.isFixedXSequence();
        int showTop = isFixTop ? showRect.top + topHeight : showRect.top;
        int num = 0;
        float tempTop = top;
        boolean isFixedTitle = config.isFixedTitle();
        boolean isFixedCount = config.isFixedCountRow();
        if (isFixedTitle) {
            int clipHeight;
            if (isFixTop) {
                clipHeight = info.getTopHeight(hZoom);
            } else {
                int disY = showRect.top - this.scaleRect.top;
                clipHeight = Math.max(0, topHeight - disY);
            }
            tempTop = showRect.top + clipHeight;
        }
        this.tempRect.set(showLeft, (int)tempTop - topHeight, showRect.left, (int)tempTop);
        this.drawLeftAndTop(canvas, showRect, this.tempRect, config);
        canvas.save();
        canvas.clipRect(showLeft, showTop, showRect.left, showRect.bottom);
        this.drawBackground(canvas, showRect, config, showLeft, showTop);
        if (config.isShowColumnTitle()) {
            for (int i = 0; i < info.getMaxLevel(); ++i) {
                ++num;
                float bottom = tempTop + (float)info.getTitleHeight();
                if (DrawUtils.isVerticalMixRect(showRect, (int)top, (int)bottom)) {
                    this.tempRect.set(this.rect.left, (int)tempTop, this.rect.right, (int)bottom);
                    this.draw(canvas, this.tempRect, num, config);
                }
                tempTop = bottom;
                top += (float)info.getTitleHeight();
            }
        }
        int tempBottom = showRect.bottom;
        if (tableData.isShowCount() && isFixedCount) {
            int bottom = Math.min(showRect.bottom, this.scaleRect.bottom);
            tempBottom = bottom - info.getCountHeight();
            this.tempRect.set(this.rect.left, tempBottom, this.rect.right, bottom);
            this.draw(canvas, this.tempRect, num + totalSize + 1, config);
        }
        if (isFixedTitle || isFixedCount) {
            canvas.save();
            canvas.clipRect((float)showLeft, tempTop, (float)showRect.left, (float)tempBottom);
        }
        for (int i = 0; i < totalSize; ++i) {
            ++num;
            float bottom = top + (float)info.getLineHeightArray()[i] * config.getZoom();
            if (showRect.bottom < this.rect.top) break;
            if (DrawUtils.isVerticalMixRect(showRect, (int)top, (int)bottom)) {
                this.tempRect.set(this.rect.left, (int)top, this.rect.right, (int)bottom);
                this.draw(canvas, this.tempRect, num, config);
            }
            top = bottom;
        }
        if (tableData.isShowCount() && !isFixedCount) {
            ++num;
            float bottom = top + (float)info.getCountHeight();
            if (DrawUtils.isVerticalMixRect(showRect, (int)top, (int)bottom)) {
                this.tempRect.set(this.rect.left, (int)top, this.rect.right, (int)bottom);
                this.draw(canvas, this.rect, num, config);
            }
        }
        if (isFixedTitle || isFixedCount) {
            canvas.restore();
        }
        canvas.restore();
    }

    protected void drawBackground(Canvas canvas, Rect showRect, TableConfig config, int showLeft, int showTop) {
        if (config.getYSequenceBackground() != null) {
            this.tempRect.set(showLeft, Math.max(this.scaleRect.top, showTop), showRect.left, Math.min(this.scaleRect.bottom, showRect.bottom));
            config.getYSequenceBackground().drawBackground(canvas, this.tempRect, config.getPaint());
        }
    }

    private void drawLeftAndTop(Canvas canvas, Rect showRect, Rect rect, TableConfig config) {
        LeftTopDrawFormat format;
        canvas.save();
        canvas.clipRect(Math.max(this.rect.left, rect.left), showRect.top, showRect.left, rect.bottom);
        Paint paint = config.getPaint();
        if (config.getLeftAndTopBackgroundColor() != 0) {
            paint.setStyle(Paint.Style.FILL);
            paint.setColor(config.getLeftAndTopBackgroundColor());
            canvas.drawRect(rect, paint);
        }
        if (config.getTableGridFormat() != null) {
            config.getSequenceGridStyle().fillPaint(paint);
            config.getTableGridFormat().drawLeftAndTopGrid(canvas, rect, paint);
        }
        if ((format = config.getLeftTopDrawFormat()) != null) {
            format.setImageSize(rect.width(), rect.height());
            config.getLeftTopDrawFormat().draw(canvas, rect, (CellInfo<String>)null, config);
        }
        canvas.restore();
    }

    private void draw(Canvas canvas, Rect rect, int position, TableConfig config) {
        Paint paint = config.getPaint();
        ICellBackgroundFormat<Integer> backgroundFormat = config.getYSequenceCellBgFormat();
        int textColor = 0;
        if (backgroundFormat != null) {
            backgroundFormat.drawBackground(canvas, rect, position, config.getPaint());
            textColor = backgroundFormat.getTextColor(position);
        }
        if (config.getTableGridFormat() != null) {
            config.getSequenceGridStyle().fillPaint(paint);
            config.getTableGridFormat().drawYSequenceGrid(canvas, position, rect, paint);
        }
        config.getYSequenceStyle().fillPaint(paint);
        if (textColor != 0) {
            paint.setColor(textColor);
        }
        this.format.draw(canvas, position - 1, rect, config);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public Rect getRect() {
        return this.rect;
    }
}

