/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.component;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import com.bin.david.form.component.IComponent;
import com.bin.david.form.core.TableConfig;
import com.bin.david.form.data.column.Column;
import com.bin.david.form.data.column.ColumnInfo;
import com.bin.david.form.data.format.bg.ICellBackgroundFormat;
import com.bin.david.form.data.format.sequence.ISequenceFormat;
import com.bin.david.form.data.table.TableData;
import com.bin.david.form.utils.DrawUtils;
import java.util.List;

public class XSequence<T>
implements IComponent<TableData<T>> {
    private Rect rect = new Rect();
    private int height;
    private int clipHeight;
    private ISequenceFormat format;
    private Rect clipRect = new Rect();
    private Rect tempRect = new Rect();
    private Rect scaleRect;

    @Override
    public void onMeasure(Rect scaleRect, Rect showRect, TableConfig config) {
        boolean fixed = config.isFixedXSequence();
        int scaleHeight = (int)((config.getZoom() > 1.0f ? 1.0f : config.getZoom()) * (float)this.height);
        this.rect.top = fixed ? showRect.top : scaleRect.top;
        this.rect.bottom = this.rect.top + scaleHeight;
        this.rect.left = scaleRect.left;
        this.rect.right = scaleRect.right;
        if (fixed) {
            scaleRect.top += scaleHeight;
            showRect.top += scaleHeight;
            this.clipHeight = scaleHeight;
        } else {
            int dis = showRect.top - scaleRect.top;
            this.clipHeight = Math.max(0, scaleHeight - dis);
            showRect.top += this.clipHeight;
            scaleRect.top += scaleHeight;
        }
        this.scaleRect = scaleRect;
    }

    @Override
    public void onDraw(Canvas canvas, Rect showRect, TableData<T> tableData, TableConfig config) {
        int i;
        this.format = tableData.getXSequenceFormat();
        List<Column> columns = tableData.getChildColumns();
        int columnSize = columns.size();
        float left = this.rect.left;
        int showTop = showRect.top - this.clipHeight;
        canvas.save();
        canvas.clipRect(showRect.left, showTop, showRect.right, showRect.top);
        this.drawBackground(canvas, showRect, config, showTop);
        this.clipRect.set(showRect);
        boolean isPerColumnFixed = false;
        int clipCount = 0;
        List<ColumnInfo> childColumnInfos = tableData.getChildColumnInfos();
        for (i = 0; i < columnSize; ++i) {
            Column column = columns.get(i);
            float width = (float)column.getComputeWidth() * config.getZoom();
            float right = left + width;
            if (childColumnInfos.get((int)i).getTopParent().column.isFixed()) {
                if (left < (float)this.clipRect.left) {
                    isPerColumnFixed = true;
                    this.showTextNum(canvas, showRect, config, this.clipRect.left, i, (int)((float)this.clipRect.left + width));
                    this.clipRect.left = (int)((float)this.clipRect.left + width);
                    left += width;
                    continue;
                }
            } else if (isPerColumnFixed) {
                isPerColumnFixed = false;
                ++clipCount;
                canvas.save();
                canvas.clipRect(this.clipRect.left, this.rect.top, showRect.right, this.rect.bottom);
            }
            if (!((float)showRect.right >= left)) break;
            left = this.showTextNum(canvas, showRect, config, left, i, right);
        }
        for (i = 0; i < clipCount; ++i) {
            canvas.restore();
        }
        canvas.restore();
    }

    protected void drawBackground(Canvas canvas, Rect showRect, TableConfig config, int showTop) {
        if (config.getXSequenceBackground() != null) {
            this.tempRect.set(Math.max(this.scaleRect.left, showRect.left), showTop, Math.min(showRect.right, this.scaleRect.right), showRect.top);
            config.getXSequenceBackground().drawBackground(canvas, this.tempRect, config.getPaint());
        }
    }

    private float showTextNum(Canvas canvas, Rect showRect, TableConfig config, float left, int i, float right) {
        if (DrawUtils.isMixHorizontalRect(showRect, (int)left, (int)right)) {
            this.draw(canvas, (int)left, this.rect.top, (int)right, this.rect.bottom, i, config);
        }
        left = right;
        return left;
    }

    private void draw(Canvas canvas, int left, int top, int right, int bottom, int position, TableConfig config) {
        Paint paint = config.getPaint();
        this.tempRect.set(left, top, right, bottom);
        ICellBackgroundFormat<Integer> backgroundFormat = config.getXSequenceCellBgFormat();
        if (backgroundFormat != null) {
            backgroundFormat.drawBackground(canvas, this.tempRect, position, paint);
        }
        if (config.getTableGridFormat() != null) {
            config.getSequenceGridStyle().fillPaint(paint);
            config.getTableGridFormat().drawXSequenceGrid(canvas, position, this.tempRect, paint);
        }
        config.getXSequenceStyle().fillPaint(paint);
        if (backgroundFormat != null && backgroundFormat.getTextColor(position) != 0) {
            paint.setColor(backgroundFormat.getTextColor(position));
        }
        this.format.draw(canvas, position, this.tempRect, config);
    }

    public Rect getRect() {
        return this.rect;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }
}

