/*
 * Decompiled with CFR 0.152.
 */
package com.android.iplayer.manager;

import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.android.iplayer.R;
import com.android.iplayer.base.BasePlayer;
import com.android.iplayer.listener.OnWindowActionListener;
import com.android.iplayer.utils.ILogger;
import com.android.iplayer.utils.PlayerUtils;
import com.android.iplayer.widget.view.WindowPlayerFloatView;

public class IWindowManager {
    private static final String TAG = "IWindowManager";
    private static volatile IWindowManager mInstance;
    private static WindowManager mWindowManager;
    private WindowPlayerFloatView mPlayerContainer;
    private OnWindowActionListener mWindowActionListener;
    private WindowManager.LayoutParams mLayoutParams;
    private Object mCoustomParams;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized IWindowManager getInstance() {
        Class<IWindowManager> clazz = IWindowManager.class;
        synchronized (IWindowManager.class) {
            if (null == mInstance) {
                mInstance = new IWindowManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private WindowManager getWindowManager() {
        return this.getWindowManager(PlayerUtils.getInstance().getContext());
    }

    private WindowManager getWindowManager(Context context) {
        if (mWindowManager == null) {
            mWindowManager = (WindowManager)context.getApplicationContext().getSystemService("window");
        }
        return mWindowManager;
    }

    public boolean addGolbalWindow(Context context, BasePlayer basePlayer, int width, int height, float startX, float startY, float radius, int bgColor) {
        this.quitGlobaWindow();
        try {
            WindowManager windowManager = this.getWindowManager(context);
            this.mLayoutParams = new WindowManager.LayoutParams();
            this.mLayoutParams.type = Build.VERSION.SDK_INT >= 26 ? 2038 : (Build.VERSION.SDK_INT >= 19 ? 2003 : 2005);
            this.mLayoutParams.flags = 262184;
            this.mLayoutParams.format = 1;
            this.mLayoutParams.gravity = 51;
            this.mLayoutParams.width = width;
            this.mLayoutParams.height = height;
            this.mLayoutParams.x = (int)startX;
            this.mLayoutParams.y = (int)startY;
            this.mLayoutParams.windowAnimations = R.style.WindowAnimation;
            this.mPlayerContainer = new WindowPlayerFloatView(context);
            this.mPlayerContainer.setOnWindowActionListener(new OnWindowActionListener(){

                @Override
                public void onMovie(float x, float y) {
                    if (null != IWindowManager.this.mLayoutParams) {
                        ((IWindowManager)IWindowManager.this).mLayoutParams.x = (int)x;
                        ((IWindowManager)IWindowManager.this).mLayoutParams.y = (int)y;
                        IWindowManager.this.getWindowManager().updateViewLayout((View)IWindowManager.this.mPlayerContainer, (ViewGroup.LayoutParams)IWindowManager.this.mLayoutParams);
                    }
                }

                @Override
                public void onClick(BasePlayer basePlayer, Object coustomParams) {
                    ILogger.d(IWindowManager.TAG, "onClick-->coustomParams:" + coustomParams);
                    if (null != IWindowManager.this.mWindowActionListener) {
                        IWindowManager.this.mWindowActionListener.onClick(basePlayer, IWindowManager.this.mCoustomParams);
                    }
                }

                @Override
                public void onClose() {
                    if (null != IWindowManager.this.mWindowActionListener) {
                        IWindowManager.this.mWindowActionListener.onClose();
                    } else {
                        IWindowManager.this.quitGlobaWindow();
                    }
                }
            });
            this.mPlayerContainer.addPlayerView(basePlayer, width, height, radius, bgColor);
            windowManager.addView((View)this.mPlayerContainer, (ViewGroup.LayoutParams)this.mLayoutParams);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public void quitGlobaWindow() {
        if (null != this.mPlayerContainer) {
            this.getWindowManager(this.mPlayerContainer.getContext()).removeViewImmediate((View)this.mPlayerContainer);
            this.mPlayerContainer.onReset();
            this.mPlayerContainer = null;
        }
        this.mLayoutParams = null;
        mWindowManager = null;
        this.mCoustomParams = null;
    }

    public BasePlayer getBasePlayer() {
        if (null != this.mPlayerContainer) {
            return this.mPlayerContainer.getBasePlayer();
        }
        return null;
    }

    public Object getCoustomParams() {
        return this.mCoustomParams;
    }

    public IWindowManager setCoustomParams(Object coustomParams) {
        this.mCoustomParams = coustomParams;
        return mInstance;
    }

    public void setOnWindowActionListener(OnWindowActionListener listener) {
        this.mWindowActionListener = listener;
    }

    public OnWindowActionListener getWindowActionListener() {
        return this.mWindowActionListener;
    }

    public void onClickWindow() {
        BasePlayer basePlayer;
        if (null != this.mWindowActionListener && null != this.mPlayerContainer && null != (basePlayer = this.mPlayerContainer.getBasePlayer())) {
            this.mWindowActionListener.onClick(basePlayer, this.mCoustomParams);
        }
    }

    public void onResume() {
        if (null != this.mPlayerContainer) {
            this.mPlayerContainer.onResume();
        }
    }

    public void onPause() {
        if (null != this.mPlayerContainer) {
            this.mPlayerContainer.onPause();
        }
    }

    public void onClean() {
        BasePlayer basePlayer = this.getBasePlayer();
        PlayerUtils.getInstance().removeViewFromParent((View)basePlayer);
        if (null != basePlayer) {
            basePlayer.onRecover();
        }
        if (null != this.mPlayerContainer) {
            this.mPlayerContainer.removeAllViews();
            this.getWindowManager(this.mPlayerContainer.getContext()).removeViewImmediate((View)this.mPlayerContainer);
            this.mPlayerContainer = null;
        }
        this.mLayoutParams = null;
    }

    public void onReset() {
        this.quitGlobaWindow();
    }
}

