/*
 * Decompiled with CFR 0.152.
 */
package com.android.iplayer.controller;

import android.app.Activity;
import android.content.Context;
import android.media.AudioManager;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import com.android.iplayer.base.BaseController;
import com.android.iplayer.interfaces.IControllerView;
import com.android.iplayer.interfaces.IGestureControl;
import com.android.iplayer.utils.ILogger;
import com.android.iplayer.utils.PlayerUtils;

public abstract class GestureController
extends BaseController
implements View.OnTouchListener {
    private GestureDetector mGestureDetector;
    private AudioManager mAudioManager;
    private boolean mCanTouchPosition = true;
    private boolean mCanTouchInPortrait = true;
    private boolean mIsGestureEnabled = true;
    private boolean mIsDoubleTapTogglePlayEnabled;
    private boolean mChangePosition;
    private boolean mChangeBrightness;
    private boolean mChangeVolume;
    private int mStreamVolume;
    private float mBrightness;
    private int mSeekPosition = -1;
    private boolean mFirstTouch;
    private boolean mCanSlide = this.mCanTouchPosition;
    private boolean isLocker;

    public GestureController(Context context) {
        super(context);
    }

    @Override
    public int getLayoutId() {
        return 0;
    }

    @Override
    public void initViews() {
        this.mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
        this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new SimpleOnGesture());
        this.setOnTouchListener(this);
    }

    protected abstract void onSingleTap();

    protected abstract void onDoubleTap();

    public void setCanTouchPosition(boolean canTouchPosition) {
        this.mCanTouchPosition = canTouchPosition;
    }

    public void setCanTouchInPortrait(boolean canTouchInPortrait) {
        ILogger.d(TAG, "setCanTouchInPortrait-->canTouchInPortrait:" + canTouchInPortrait);
        this.mCanSlide = this.mCanTouchInPortrait = canTouchInPortrait;
    }

    public void setGestureEnabled(boolean gestureEnabled) {
        this.mIsGestureEnabled = gestureEnabled;
    }

    public void setDoubleTapTogglePlayEnabled(boolean enabled) {
        this.mIsDoubleTapTogglePlayEnabled = enabled;
    }

    @Override
    public void onScreenOrientation(int orientation) {
        super.onScreenOrientation(orientation);
        this.mCanSlide = 0 == orientation ? this.mCanTouchInPortrait : true;
    }

    public boolean onTouch(View view, MotionEvent event) {
        if (null != this.mGestureDetector) {
            return this.mGestureDetector.onTouchEvent(event);
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (null != this.mGestureDetector && !this.mGestureDetector.onTouchEvent(event)) {
            int action = event.getAction();
            switch (action) {
                case 1: {
                    this.stopSlide();
                    if (this.mSeekPosition <= -1) break;
                    if (null != this.mVideoPlayerControl) {
                        this.mVideoPlayerControl.seekTo(this.mSeekPosition);
                    }
                    this.mSeekPosition = -1;
                    break;
                }
                case 3: {
                    this.stopSlide();
                    this.mSeekPosition = -1;
                }
            }
        }
        return super.onTouchEvent(event);
    }

    private void slideToChangePosition(float deltaX) {
        if (null != this.mVideoPlayerControl) {
            deltaX = -deltaX;
            int width = this.getMeasuredWidth();
            int duration = (int)this.mVideoPlayerControl.getDuration();
            int currentPosition = (int)this.mVideoPlayerControl.getCurrentPosition();
            int position = (int)(deltaX / (float)width * 120000.0f + (float)currentPosition);
            if (position > duration) {
                position = duration;
            }
            if (position < 0) {
                position = 0;
            }
            for (IControllerView iControllerView : this.mIControllerViews) {
                if (!(iControllerView instanceof IGestureControl)) continue;
                ((IGestureControl)((Object)iControllerView)).onPositionChange(position, currentPosition, duration);
            }
            this.mSeekPosition = position;
        }
    }

    private void slideToChangeBrightness(float deltaY) {
        float brightness;
        Activity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        Window window = activity.getWindow();
        WindowManager.LayoutParams attributes = window.getAttributes();
        int height = this.getMeasuredHeight();
        if (this.mBrightness == -1.0f) {
            this.mBrightness = 0.5f;
        }
        if ((brightness = deltaY * 2.0f / (float)height * 1.0f + this.mBrightness) < 0.0f) {
            brightness = 0.0f;
        }
        if (brightness > 1.0f) {
            brightness = 1.0f;
        }
        int percent = (int)(brightness * 100.0f);
        attributes.screenBrightness = brightness;
        window.setAttributes(attributes);
        for (IControllerView iControllerView : this.mIControllerViews) {
            if (!(iControllerView instanceof IGestureControl)) continue;
            ((IGestureControl)((Object)iControllerView)).onBrightnessChange(percent);
        }
    }

    private void slideToChangeVolume(float deltaY) {
        int streamMaxVolume = this.mAudioManager.getStreamMaxVolume(3);
        int height = this.getMeasuredHeight();
        float deltaV = deltaY * 2.0f / (float)height * (float)streamMaxVolume;
        float index = (float)this.mStreamVolume + deltaV;
        if (index > (float)streamMaxVolume) {
            index = streamMaxVolume;
        }
        if (index < 0.0f) {
            index = 0.0f;
        }
        int percent = (int)(index / (float)streamMaxVolume * 100.0f);
        this.mAudioManager.setStreamVolume(3, (int)index, 0);
        for (IControllerView iControllerView : this.mIControllerViews) {
            if (!(iControllerView instanceof IGestureControl)) continue;
            ((IGestureControl)((Object)iControllerView)).onVolumeChange(percent);
        }
    }

    private void stopSlide() {
        for (IControllerView iControllerView : this.mIControllerViews) {
            if (!(iControllerView instanceof IGestureControl)) continue;
            ((IGestureControl)((Object)iControllerView)).onStopSlide();
        }
    }

    protected boolean isLocked() {
        return this.isLocker;
    }

    protected void setLocker(boolean locker) {
        this.isLocker = locker;
    }

    private class SimpleOnGesture
    extends GestureDetector.SimpleOnGestureListener {
        private SimpleOnGesture() {
        }

        public boolean onDown(MotionEvent e) {
            boolean edge = PlayerUtils.getInstance().isEdge(GestureController.this.getParentContext(), e);
            if (!GestureController.this.isPlayering() || !GestureController.this.mIsGestureEnabled || edge) {
                return true;
            }
            GestureController.this.mStreamVolume = GestureController.this.mAudioManager.getStreamVolume(3);
            Activity activity = GestureController.this.getActivity();
            if (activity == null) {
                GestureController.this.mBrightness = 0.0f;
            } else {
                GestureController.this.mBrightness = activity.getWindow().getAttributes().screenBrightness;
            }
            GestureController.this.mFirstTouch = true;
            GestureController.this.mChangePosition = false;
            GestureController.this.mChangeBrightness = false;
            GestureController.this.mChangeVolume = false;
            return true;
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            GestureController.this.onSingleTap();
            return true;
        }

        public boolean onDoubleTap(MotionEvent e) {
            if (GestureController.this.mIsDoubleTapTogglePlayEnabled) {
                GestureController.this.onDoubleTap();
            }
            return true;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (!GestureController.this.isPlayering() || !GestureController.this.mIsGestureEnabled || !GestureController.this.mCanSlide || GestureController.this.isLocked() || PlayerUtils.getInstance().isEdge(GestureController.this.getParentContext(), e1)) {
                return true;
            }
            float deltaX = e1.getX() - e2.getX();
            float deltaY = e1.getY() - e2.getY();
            if (GestureController.this.mFirstTouch) {
                GestureController.this.mChangePosition = Math.abs(distanceX) >= Math.abs(distanceY);
                if (!GestureController.this.mChangePosition) {
                    int halfScreen = PlayerUtils.getInstance().getScreenWidth(GestureController.this.getContext()) / 2;
                    if (e2.getX() > (float)halfScreen) {
                        GestureController.this.mChangeVolume = true;
                    } else {
                        GestureController.this.mChangeBrightness = true;
                    }
                }
                if (GestureController.this.mChangePosition) {
                    GestureController.this.mChangePosition = GestureController.this.mCanTouchPosition;
                }
                if (GestureController.this.mChangePosition || GestureController.this.mChangeBrightness || GestureController.this.mChangeVolume) {
                    for (IControllerView iControllerView : GestureController.this.mIControllerViews) {
                        if (!(iControllerView instanceof IGestureControl)) continue;
                        ((IGestureControl)((Object)iControllerView)).onStartSlide();
                    }
                }
                GestureController.this.mFirstTouch = false;
            }
            if (GestureController.this.mChangePosition) {
                GestureController.this.slideToChangePosition(deltaX);
            } else if (GestureController.this.mChangeBrightness) {
                GestureController.this.slideToChangeBrightness(deltaY);
            } else if (GestureController.this.mChangeVolume) {
                GestureController.this.slideToChangeVolume(deltaY);
            }
            return true;
        }
    }
}

