/*
 * Decompiled with CFR 0.152.
 */
package com.android.iplayer.widget.controls;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.android.iplayer.R;
import com.android.iplayer.base.BaseControlWidget;
import com.android.iplayer.manager.IVideoManager;
import com.android.iplayer.model.PlayerState;
import com.android.iplayer.utils.PlayerUtils;

public class ControlStatusView
extends BaseControlWidget {
    public static final int SCENE_MOBILE = 1;
    public static final int SCENE_COMPLETION = 2;
    public static final int SCENE_ERROR = 3;
    private int mScene;
    private OnStatusListener mOnStatusListener;

    public ControlStatusView(Context context) {
        super(context, null);
    }

    public ControlStatusView(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
    }

    public ControlStatusView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public int getLayoutId() {
        return R.layout.player_control_status;
    }

    @Override
    public void initViews() {
        this.hide();
        View btnContinue = this.findViewById(R.id.player_status_btn);
        PlayerUtils.getInstance().setOutlineProvider(this.findViewById(R.id.player_status_btn), PlayerUtils.getInstance().dpToPxInt(18.0f));
        btnContinue.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (null != ControlStatusView.this.mOnStatusListener) {
                    ControlStatusView.this.mOnStatusListener.onEvent(ControlStatusView.this.mScene);
                    return;
                }
                if (null != ControlStatusView.this.mControlWrapper) {
                    switch (ControlStatusView.this.mScene) {
                        case 1: {
                            IVideoManager.getInstance().setMobileNetwork(true);
                            ControlStatusView.this.mControlWrapper.togglePlay();
                            break;
                        }
                        case 2: {
                            ControlStatusView.this.mControlWrapper.onCompletion();
                            break;
                        }
                        case 3: {
                            ControlStatusView.this.mControlWrapper.togglePlay();
                        }
                    }
                }
            }
        });
    }

    public void setScene(int scene) {
        this.setScene(scene, null);
    }

    public void setScene(int scene, String tipsStr) {
        this.setScene(scene, tipsStr, null);
    }

    public void setScene(int scene, String tipsStr, String btnStr) {
        this.mScene = scene;
        TextView tips = (TextView)this.findViewById(R.id.player_status_tips);
        TextView btn = (TextView)this.findViewById(R.id.player_status_btn);
        tips.setText((CharSequence)PlayerUtils.getInstance().formatHtml(this.getTipsStr(scene, tipsStr)));
        btn.setText((CharSequence)PlayerUtils.getInstance().formatHtml(this.getBtnStr(scene, btnStr)));
    }

    private String getBtnStr(int scene, String btnStr) {
        if (!TextUtils.isEmpty((CharSequence)btnStr)) {
            return btnStr;
        }
        switch (scene) {
            case 1: {
                return this.getContext().getResources().getString(R.string.player_btn_continue_play);
            }
            case 2: {
                return this.getContext().getResources().getString(R.string.player_btn_yes);
            }
            case 3: {
                return this.getContext().getResources().getString(R.string.player_btn_try);
            }
        }
        return this.getContext().getResources().getString(R.string.player_btn_unknown);
    }

    private String getTipsStr(int scene, String tipsStr) {
        if (!TextUtils.isEmpty((CharSequence)tipsStr)) {
            return tipsStr;
        }
        switch (scene) {
            case 1: {
                return this.getContext().getResources().getString(R.string.player_tips_mobile);
            }
            case 2: {
                return this.getContext().getResources().getString(R.string.player_tips_preview_finish);
            }
            case 3: {
                return this.getContext().getResources().getString(R.string.player_tips_play_error);
            }
        }
        return this.getContext().getResources().getString(R.string.player_tips_unknown);
    }

    public void setSceneType(int sceneType) {
        int textSize14 = PlayerUtils.getInstance().dpToPxInt(14.0f);
        int textSize13 = PlayerUtils.getInstance().dpToPxInt(13.0f);
        int textSize16 = PlayerUtils.getInstance().dpToPxInt(16.0f);
        TextView tips = (TextView)this.findViewById(R.id.player_status_tips);
        tips.setTextSize(0, 1 == sceneType ? (float)textSize14 : (float)textSize16);
        int paddingLeft12 = PlayerUtils.getInstance().dpToPxInt(12.0f);
        int paddingLeft22 = PlayerUtils.getInstance().dpToPxInt(22.0f);
        TextView btn = (TextView)this.findViewById(R.id.player_status_btn);
        btn.setTextSize(0, 1 == sceneType ? (float)textSize13 : (float)textSize16);
        btn.setPadding(1 == sceneType ? paddingLeft12 : paddingLeft22, 0, 1 == sceneType ? paddingLeft12 : paddingLeft22, 0);
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)btn.getLayoutParams();
        layoutParams.height = PlayerUtils.getInstance().dpToPxInt(1 == sceneType ? 26.0f : 36.0f);
        layoutParams.setMargins(0, PlayerUtils.getInstance().dpToPxInt(1 == sceneType ? 15.0f : 20.0f), 0, 0);
        btn.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        PlayerUtils.getInstance().setOutlineProvider((View)btn, PlayerUtils.getInstance().dpToPxInt(1 == sceneType ? 13.0f : 18.0f));
    }

    @Override
    public void show() {
        if (this.getVisibility() != 0) {
            this.setVisibility(0);
        }
    }

    @Override
    public void hide() {
        if (this.getVisibility() != 8) {
            this.setVisibility(8);
        }
    }

    @Override
    public void onPlayerState(PlayerState state, String message) {
        switch (state) {
            case STATE_COMPLETION: {
                if (this.isPreViewScene()) {
                    this.show();
                    this.setScene(2);
                    break;
                }
                this.hide();
                break;
            }
            case STATE_MOBILE: {
                this.show();
                this.setScene(1);
                break;
            }
            case STATE_ERROR: {
                this.setScene(3, message);
                this.show();
                break;
            }
            default: {
                this.hide();
            }
        }
    }

    @Override
    public void onOrientation(int direction) {
    }

    @Override
    public void onPlayerScene(int playerScene) {
    }

    public void setOnStatusListener(OnStatusListener onStatusListener) {
        this.mOnStatusListener = onStatusListener;
    }

    public static interface OnStatusListener {
        public void onEvent(int var1);
    }
}

