/*
 * Decompiled with CFR 0.152.
 */
package com.android.iplayer.widget.controls;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.android.iplayer.R;
import com.android.iplayer.base.BaseControlWidget;
import com.android.iplayer.interfaces.IGestureControl;
import com.android.iplayer.model.PlayerState;
import com.android.iplayer.utils.ILogger;
import com.android.iplayer.utils.PlayerUtils;

public class ControlGestureView
extends BaseControlWidget
implements IGestureControl {
    private View mController;
    private ImageView mPresentIcon;
    private TextView mPresentText;
    private ProgressBar mPresentProgress;

    public ControlGestureView(Context context) {
        super(context);
    }

    @Override
    public int getLayoutId() {
        return R.layout.player_control_gesture;
    }

    @Override
    public void initViews() {
        this.hide();
        this.mController = this.findViewById(R.id.gesture_present);
        this.mPresentIcon = (ImageView)this.findViewById(R.id.gesture_present_icon);
        this.mPresentText = (TextView)this.findViewById(R.id.gesture_present_text);
        this.mPresentProgress = (ProgressBar)this.findViewById(R.id.gesture_present_progress);
    }

    @Override
    public void onStartSlide() {
        ILogger.d("BaseControlWidget", "onStartSlide");
        this.hideAllController(true);
        this.show();
        this.setAlpha(1.0f);
    }

    @Override
    public void onStopSlide() {
        this.animate().alpha(0.0f).setDuration(300L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                ControlGestureView.this.hide();
            }
        }).start();
    }

    @Override
    public void onPositionChange(int slidePosition, int currentPosition, int duration) {
        if (null != this.mPresentProgress) {
            this.mPresentProgress.setVisibility(8);
        }
        if (null != this.mPresentText) {
            this.mPresentText.setVisibility(0);
        }
        if (null != this.mPresentIcon) {
            this.mPresentIcon.setImageResource(slidePosition > currentPosition ? R.mipmap.ic_player_gesture_next : R.mipmap.ic_player_gesture_last);
        }
        if (null != this.mPresentText) {
            this.mPresentText.setText((CharSequence)String.format("%s/%s", PlayerUtils.getInstance().stringForAudioTime(slidePosition), PlayerUtils.getInstance().stringForAudioTime(duration)));
        }
    }

    @Override
    public void onBrightnessChange(int percent) {
        if (null != this.mPresentText) {
            this.mPresentText.setVisibility(8);
        }
        if (null != this.mPresentIcon) {
            this.mPresentIcon.setImageResource(R.mipmap.ic_player_brightness);
        }
        if (null != this.mPresentProgress) {
            this.mPresentProgress.setVisibility(0);
            this.mPresentProgress.setProgress(percent);
        }
    }

    @Override
    public void onVolumeChange(int percent) {
        if (null != this.mPresentText) {
            this.mPresentText.setVisibility(8);
        }
        if (null != this.mPresentIcon) {
            this.mPresentIcon.setImageResource(0 == percent ? R.mipmap.ic_player_sound_off : R.mipmap.ic_player_sound);
        }
        if (null != this.mPresentProgress) {
            this.mPresentProgress.setVisibility(0);
            this.mPresentProgress.setProgress(percent);
        }
    }

    @Override
    public void onPlayerState(PlayerState state, String message) {
    }

    @Override
    public void onPlayerScene(int playerScene) {
    }

    @Override
    public void onOrientation(int direction) {
        if (1 == direction) {
            this.enterLandscape();
        } else {
            this.enterPortrait();
        }
    }

    private void enterPortrait() {
        if (null != this.mController) {
            this.mController.getLayoutParams().width = PlayerUtils.getInstance().dpToPxInt(146.0f);
            this.mController.getLayoutParams().height = PlayerUtils.getInstance().dpToPxInt(79.0f);
            this.mController.setBackgroundResource(R.drawable.player_gesture_content_portrait_bg);
        }
        if (null != this.mPresentProgress) {
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.mPresentProgress.getLayoutParams();
            int toPxInt10 = PlayerUtils.getInstance().dpToPxInt(12.0f);
            int toPxInt16 = PlayerUtils.getInstance().dpToPxInt(16.0f);
            layoutParams.setMargins(toPxInt10, toPxInt16, toPxInt10, 0);
        }
        if (null != this.mPresentText) {
            this.mPresentText.setTextSize(0, (float)PlayerUtils.getInstance().dpToPxInt(14.0f));
        }
    }

    private void enterLandscape() {
        if (null != this.mController) {
            this.mController.getLayoutParams().width = PlayerUtils.getInstance().dpToPxInt(168.0f);
            this.mController.getLayoutParams().height = PlayerUtils.getInstance().dpToPxInt(99.0f);
            this.mController.setBackgroundResource(R.drawable.player_gesture_content_bg);
        }
        if (null != this.mPresentProgress) {
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.mPresentProgress.getLayoutParams();
            int toPxInt12 = PlayerUtils.getInstance().dpToPxInt(16.0f);
            int toPxInt20 = PlayerUtils.getInstance().dpToPxInt(20.0f);
            layoutParams.setMargins(toPxInt12, toPxInt20, toPxInt12, 0);
        }
        if (null != this.mPresentText) {
            this.mPresentText.setTextSize(0, (float)PlayerUtils.getInstance().dpToPxInt(15.0f));
        }
    }
}

