/*
 * Decompiled with CFR 0.152.
 */
package com.android.iplayer.controller;

import android.content.Context;
import android.os.Looper;
import android.os.Message;
import android.view.View;
import android.view.animation.Animation;
import android.widget.ImageView;
import android.widget.Toast;
import com.android.iplayer.R;
import com.android.iplayer.base.BaseController;
import com.android.iplayer.controller.GestureController;
import com.android.iplayer.model.PlayerState;
import com.android.iplayer.utils.AnimationUtils;
import com.android.iplayer.utils.PlayerUtils;

public class VideoController
extends GestureController {
    private static final int MESSAGE_CONTROL_HIDE = 10;
    private static final int MESSAGE_LOCKER_HIDE = 11;
    private static final int DELAYED_INVISIBLE = 5000;
    private static final int MATION_DRAUTION = 500;
    private View mController;
    protected boolean isCompletion;
    protected boolean isLocked;
    private BaseController.ExHandel mExHandel = new BaseController.ExHandel(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (11 == msg.what) {
                VideoController.this.hideLockerView();
            } else if (10 == msg.what) {
                if (VideoController.this.isOrientationLandscape()) {
                    VideoController.this.hideLockerView();
                }
                VideoController.this.hideWidget(true);
            }
        }
    };

    public VideoController(Context context) {
        super(context);
    }

    @Override
    public int getLayoutId() {
        return R.layout.player_video_controller;
    }

    @Override
    public void initViews() {
        super.initViews();
        this.setDoubleTapTogglePlayEnabled(true);
        this.mController = this.findViewById(R.id.controller_locker);
        this.mController.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                VideoController.this.stopDelayedRunnable();
                VideoController.this.isLocked = !VideoController.this.isLocked;
                VideoController.this.setLocker(VideoController.this.isLocked);
                ((ImageView)VideoController.this.findViewById(R.id.controller_locker_ic)).setImageResource(VideoController.this.isLocked ? R.mipmap.ic_player_locker_true : R.mipmap.ic_player_locker_false);
                Toast.makeText((Context)VideoController.this.getContext(), (CharSequence)(VideoController.this.isLocked() ? VideoController.this.getString(R.string.player_locker_true) : VideoController.this.getString(R.string.player_locker_flase)), (int)0).show();
                if (VideoController.this.isLocked) {
                    VideoController.this.hideWidget(true);
                    VideoController.this.startDelayedRunnable(11);
                } else {
                    VideoController.this.showWidget(true);
                    VideoController.this.startDelayedRunnable(10);
                }
            }
        });
    }

    @Override
    public void onSingleTap() {
        if (this.isOrientationPortrait() && this.isListPlayerScene()) {
            if (null != this.mVideoPlayerControl) {
                this.mVideoPlayerControl.togglePlay();
            }
        } else if (this.isLocked()) {
            this.toggleLocker();
        } else {
            this.toggleController();
        }
    }

    @Override
    public void onDoubleTap() {
        if (!this.isLocked() && null != this.mVideoPlayerControl) {
            this.mVideoPlayerControl.togglePlay();
        }
    }

    @Override
    public void onPlayerState(PlayerState state, String message) {
        super.onPlayerState(state, message);
        switch (state) {
            case STATE_RESET: 
            case STATE_STOP: {
                this.onReset();
                break;
            }
            case STATE_PREPARE: 
            case STATE_BUFFER: {
                break;
            }
            case STATE_START: {
                this.startDelayedRunnable(10);
                if (!this.isOrientationLandscape() || null == this.mController) break;
                this.mController.setVisibility(0);
                break;
            }
            case STATE_PLAY: 
            case STATE_ON_PLAY: {
                this.startDelayedRunnable(10);
                break;
            }
            case STATE_PAUSE: 
            case STATE_ON_PAUSE: {
                this.stopDelayedRunnable();
                break;
            }
            case STATE_COMPLETION: {
                this.stopDelayedRunnable();
                this.hideWidget(false);
                this.hideLockerView();
                break;
            }
            case STATE_MOBILE: {
                break;
            }
            case STATE_ERROR: {
                this.setLocker(false);
                this.hideLockerView();
                break;
            }
            case STATE_DESTROY: {
                this.onDestroy();
            }
        }
    }

    @Override
    public void onScreenOrientation(int orientation) {
        super.onScreenOrientation(orientation);
        if (null != this.mController) {
            if (this.isOrientationPortrait()) {
                this.setLocker(false);
                this.mController.setVisibility(8);
            } else {
                this.setLocker(false);
                if (this.isPlayering()) {
                    this.mController.setVisibility(0);
                }
            }
        }
    }

    private void toggleLocker() {
        if (null == this.mController) {
            return;
        }
        this.stopDelayedRunnable();
        if (this.mController.getVisibility() == 0) {
            this.hideLockerView();
        } else {
            AnimationUtils.getInstance().startTranslateRightToLocat(this.mController, 500L, null);
            this.startDelayedRunnable(11);
        }
    }

    private void toggleController() {
        this.stopDelayedRunnable();
        if (this.isControllerShowing()) {
            this.hideLockerView();
            this.hideWidget(true);
        } else {
            if (this.isOrientationLandscape() && null != this.mController && this.mController.getVisibility() != 0) {
                AnimationUtils.getInstance().startTranslateRightToLocat(this.mController, 500L, null);
            }
            this.showWidget(true);
            this.startDelayedRunnable();
        }
    }

    @Override
    public void startDelayedRunnable() {
        this.startDelayedRunnable(10);
    }

    private void startDelayedRunnable(int msg) {
        super.startDelayedRunnable();
        if (null != this.mExHandel) {
            this.stopDelayedRunnable();
            Message message = this.mExHandel.obtainMessage();
            message.what = msg;
            this.mExHandel.sendMessageDelayed(message, 5000L);
        }
    }

    @Override
    public void stopDelayedRunnable() {
        this.stopDelayedRunnable(0);
    }

    @Override
    public void reStartDelayedRunnable() {
        super.stopDelayedRunnable();
        this.stopDelayedRunnable();
        this.startDelayedRunnable();
    }

    private void stopDelayedRunnable(int msg) {
        if (null != this.mExHandel) {
            if (0 == msg) {
                this.mExHandel.removeCallbacksAndMessages(null);
            } else {
                this.mExHandel.removeMessages(msg);
            }
        }
    }

    private void hideLockerView() {
        if (null != this.mController && this.mController.getVisibility() == 0) {
            AnimationUtils.getInstance().startTranslateLocatToRight(this.mController, 500L, new AnimationUtils.OnAnimationListener(){

                @Override
                public void onAnimationEnd(Animation animation) {
                    VideoController.this.mController.setVisibility(8);
                }
            });
        }
    }

    public void setPreViewTotalDuration(String totalDuration) {
        int duration = PlayerUtils.getInstance().parseInt(totalDuration);
        if (duration > 0) {
            this.setPreViewTotalDuration(duration * 1000);
        }
    }

    public void showLocker(boolean showLocker) {
        this.findViewById(R.id.controller_root).setVisibility(showLocker ? 0 : 8);
    }

    private void reset() {
        this.stopDelayedRunnable();
        if (null != this.mExHandel) {
            this.mExHandel.removeCallbacksAndMessages(null);
        }
    }

    @Override
    public void onReset() {
        super.onReset();
        this.reset();
    }

    @Override
    public void onDestroy() {
        this.stopDelayedRunnable();
        super.onDestroy();
        this.reset();
    }
}

