/*
 * Decompiled with CFR 0.152.
 */
package com.android.iplayer.widget.controls;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.iplayer.R;
import com.android.iplayer.base.BaseControllerWidget;
import com.android.iplayer.model.PlayerState;
import com.android.iplayer.utils.PlayerUtils;

public class ControlListView
extends BaseControllerWidget
implements View.OnClickListener {
    private TextView mSurplusDuration;

    public ControlListView(Context context) {
        super(context);
    }

    @Override
    public int getLayoutId() {
        return R.layout.player_list_view;
    }

    @Override
    public void initViews() {
        this.hide();
        this.mSurplusDuration = (TextView)this.findViewById(R.id.controller_surplus_duration);
        this.findViewById(R.id.controller_list_mute).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.controller_list_fullscreen).setOnClickListener((View.OnClickListener)this);
        this.updateMute();
    }

    private void updateMute() {
        if (null != this.mControlWrapper) {
            boolean soundMute = this.mControlWrapper.isSoundMute();
            ImageView muteImge = (ImageView)this.findViewById(R.id.controller_list_mute);
            muteImge.setImageResource(soundMute ? R.mipmap.ic_player_mute_true : R.mipmap.ic_player_mute_false);
        }
    }

    @Override
    public void onPlayerState(PlayerState state, String message) {
        switch (state) {
            case STATE_RESET: 
            case STATE_STOP: 
            case STATE_ERROR: 
            case STATE_COMPLETION: {
                this.onReset();
                break;
            }
            case STATE_PREPARE: {
                this.hide();
                break;
            }
            case STATE_START: {
                if (!this.isListPlayerScene()) break;
                this.show();
            }
        }
    }

    @Override
    public void onOrientation(int direction) {
        if (1 == direction) {
            this.hide();
        } else if (this.isListPlayerScene()) {
            this.show();
        } else {
            this.hide();
        }
    }

    @Override
    public void onPlayerScene(int playerScene) {
        if (this.isOrientationPortrait()) {
            if (this.isListPlayerScene(playerScene)) {
                if (this.isPlaying()) {
                    this.show();
                }
            } else {
                this.hide();
            }
        } else {
            this.hide();
        }
    }

    @Override
    public void onProgress(long currentDurtion, long totalDurtion) {
        try {
            if (null != this.mSurplusDuration) {
                this.mSurplusDuration.setText((CharSequence)PlayerUtils.getInstance().stringForAudioTime(totalDurtion - currentDurtion));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onMute(boolean isMute) {
        ImageView muteImage = (ImageView)this.findViewById(R.id.controller_list_mute);
        muteImage.setImageResource(isMute ? R.mipmap.ic_player_mute_true : R.mipmap.ic_player_mute_false);
    }

    public void onClick(View view) {
        if (null != this.mControlWrapper) {
            if (view.getId() == R.id.controller_list_mute) {
                this.mControlWrapper.toggleMute();
            } else if (view.getId() == R.id.controller_list_fullscreen) {
                this.mControlWrapper.toggleFullScreen();
            }
        }
    }

    public void showSoundMute(boolean showSound, boolean soundMute) {
        ImageView muteImage = (ImageView)this.findViewById(R.id.controller_list_mute);
        muteImage.setVisibility(showSound ? 0 : 8);
        if (null != this.mControlWrapper) {
            this.mControlWrapper.setSoundMute(soundMute);
        }
    }

    @Override
    public void onReset() {
        if (null != this.mSurplusDuration) {
            this.mSurplusDuration.setText((CharSequence)PlayerUtils.getInstance().stringForAudioTime(0L));
        }
    }
}

