/*
 * Decompiled with CFR 0.152.
 */
package com.android.iplayer.media;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.text.TextUtils;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.android.iplayer.R;
import com.android.iplayer.base.AbstractMediaPlayer;
import com.android.iplayer.base.BasePlayer;
import com.android.iplayer.interfaces.IMediaPlayer;
import com.android.iplayer.interfaces.IMediaPlayerControl;
import com.android.iplayer.interfaces.IVideoRenderView;
import com.android.iplayer.manager.IVideoManager;
import com.android.iplayer.media.core.MediaPlayer;
import com.android.iplayer.model.PlayerState;
import com.android.iplayer.utils.AudioFocus;
import com.android.iplayer.utils.ILogger;
import com.android.iplayer.utils.PlayerUtils;
import com.android.iplayer.utils.ThreadPool;
import com.android.iplayer.widget.view.MediaTextureView;
import java.util.Timer;
import java.util.TimerTask;

public final class IVideoPlayer
implements IMediaPlayer.OnBufferingUpdateListener,
IMediaPlayer.OnCompletionListener,
IMediaPlayer.OnPreparedListener,
IMediaPlayer.OnInfoListener,
IMediaPlayer.OnVideoSizeChangedListener,
IMediaPlayer.OnErrorListener,
IMediaPlayer.OnSeekCompleteListener,
AudioFocus.OnAudioFocusListener {
    private static final String TAG = IVideoPlayer.class.getSimpleName();
    private IMediaPlayerControl mIMediaPlayerControl;
    private AbstractMediaPlayer mMediaPlayer;
    private IVideoRenderView mRenderView;
    private AudioFocus mAudioFocusManager;
    private PlayerState sPlayerState = PlayerState.STATE_RESET;
    private boolean mLoop = false;
    private boolean mSoundMute = false;
    private String mDataSource;
    private AssetFileDescriptor mAssetsSource;
    private PlayerTimerTask mPlayerTimerTask;
    private Timer mTimer;
    private long DEFAULT_CALLBACK_TIME;
    private long mCallBackSpaceMilliss = this.DEFAULT_CALLBACK_TIME = 1000L;
    private long mSeekDuration;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mPrepareTimeout = 10;
    private int mReadTimeout = 15;

    private void onPlayerState(PlayerState playerState, String message) {
        ILogger.d(TAG, "onPlayerState-->playerState:" + (Object)((Object)playerState) + ",message:" + message);
        if (null != this.mIMediaPlayerControl) {
            this.mIMediaPlayerControl.onPlayerState(playerState, message);
        }
    }

    private void onProgress(long currentPosition, long duration) {
        if (null != this.mIMediaPlayerControl) {
            this.mIMediaPlayerControl.onProgress(currentPosition, duration);
        }
    }

    private AbstractMediaPlayer newInstanceMediaPlayer() {
        AbstractMediaPlayer mediaPlayer = this.mIMediaPlayerControl.getMediaPlayer();
        if (null == mediaPlayer) {
            Context context = this.mIMediaPlayerControl.getVideoPlayer().getContext();
            mediaPlayer = new MediaPlayer(context);
        }
        return mediaPlayer;
    }

    private IVideoRenderView newInstanceRenderView(Context context) {
        IVideoRenderView renderView = this.mIMediaPlayerControl.getRenderView();
        if (null == renderView) {
            renderView = new MediaTextureView(context);
        }
        renderView.attachMediaPlayer(this.mMediaPlayer);
        return renderView;
    }

    private boolean initMediaPlayer() {
        if (null != this.mIMediaPlayerControl) {
            this.mMediaPlayer = this.newInstanceMediaPlayer();
            BasePlayer videoPlayer = this.mIMediaPlayerControl.getVideoPlayer();
            ILogger.d(TAG, this.getString(R.string.player_core_name, "\u89e3\u7801\u5668\u5185\u6838\uff1a") + this.mMediaPlayer.getClass().getSimpleName());
            this.mMediaPlayer.setOnBufferingUpdateListener(this);
            this.mMediaPlayer.setOnCompletionListener(this);
            this.mMediaPlayer.setOnPreparedListener(this);
            this.mMediaPlayer.setOnInfoListener(this);
            this.mMediaPlayer.setOnVideoSizeChangedListener(this);
            this.mMediaPlayer.setOnErrorListener(this);
            this.mMediaPlayer.setOnSeekCompleteListener(this);
            this.mMediaPlayer.setLooping(this.mLoop);
            if (this.mSoundMute) {
                this.mMediaPlayer.setVolume(0.0f, 0.0f);
            } else {
                this.mMediaPlayer.setVolume(1.0f, 1.0f);
            }
            this.mMediaPlayer.setBufferTimeMax(2.0f);
            this.mMediaPlayer.setTimeout(this.mPrepareTimeout, this.mReadTimeout);
            this.initTextureView(videoPlayer.getContext());
            this.attachedVideoView(videoPlayer);
            return true;
        }
        return false;
    }

    private void initTextureView(Context context) {
        if (null == context) {
            return;
        }
        this.mRenderView = this.newInstanceRenderView(context);
        ILogger.d(TAG, this.getString(R.string.player_render_name, "\u6e32\u67d3\u5668\u5185\u6838\uff1a") + this.mRenderView.getClass().getSimpleName());
        this.mRenderView.setZoomMode(IVideoManager.getInstance().getZoomModel());
    }

    private void releaseTextureView() {
        if (null != this.mMediaPlayer) {
            try {
                if (this.mMediaPlayer.isPlaying()) {
                    this.mMediaPlayer.stop();
                }
                this.mMediaPlayer.release();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                if (null != this.mRenderView) {
                    PlayerUtils.getInstance().removeViewFromParent(this.mRenderView.getView());
                }
                this.releaseSurfaceTexture();
                this.mRenderView = null;
                this.mMediaPlayer = null;
            }
        }
    }

    private void releaseSurfaceTexture() {
        if (null != this.mRenderView) {
            this.mRenderView.release();
        }
    }

    @Override
    public void onBufferingUpdate(IMediaPlayer mp, int percent) {
        if (null != this.mIMediaPlayerControl) {
            this.mIMediaPlayerControl.onBuffer(percent);
        }
    }

    @Override
    public void onCompletion(IMediaPlayer mp) {
        ILogger.d(TAG, "onCompletion\uff1a" + this.mLoop + ",mp:" + mp);
        this.mSeekDuration = 0L;
        this.stopTimer();
        this.sPlayerState = PlayerState.STATE_COMPLETION;
        this.onPlayerState(this.sPlayerState, this.getString(R.string.player_media_completion, "\u64ad\u653e\u5b8c\u6210"));
    }

    @Override
    public boolean onError(IMediaPlayer mp, int what, int extra) {
        ILogger.d(TAG, "onError,what:" + what + ",extra:" + extra);
        if (-38 == what) {
            return true;
        }
        this.stopTimer();
        this.sPlayerState = PlayerState.STATE_ERROR;
        this.onPlayerState(this.sPlayerState, this.getErrorMessage(what));
        return true;
    }

    @Override
    public boolean onInfo(IMediaPlayer mp, int what, int extra) {
        ILogger.d(TAG, "onInfo-->what:" + what + ",extra:" + extra);
        switch (what) {
            case 3: {
                this.sPlayerState = PlayerState.STATE_START;
                this.onPlayerState(this.sPlayerState, this.getString(R.string.player_media_start, "\u9996\u5e27\u6e32\u67d3"));
                this.startTimer();
                if (this.mSeekDuration > 0L) {
                    long seekDuration = this.mSeekDuration;
                    this.mSeekDuration = 0L;
                    this.seekTo(seekDuration);
                }
                this.listenerAudioFocus();
                break;
            }
            case 701: {
                this.sPlayerState = PlayerState.STATE_BUFFER;
                this.onPlayerState(this.sPlayerState, this.getString(R.string.player_media_buffer_start, "\u7f13\u51b2\u5f00\u59cb"));
                break;
            }
            case 702: 
            case 703: {
                this.sPlayerState = PlayerState.STATE_PLAY;
                this.onPlayerState(this.sPlayerState, this.getString(R.string.player_media_buffer_end, "\u7f13\u51b2\u7ed3\u675f"));
                break;
            }
            case 10001: {
                if (null == this.mRenderView) break;
                this.mRenderView.setDegree(extra);
            }
        }
        return true;
    }

    @Override
    public void onPrepared(IMediaPlayer mp) {
        ILogger.d(TAG, "onPrepared-->seek:" + this.mSeekDuration);
        if (null != this.mMediaPlayer) {
            mp.start();
        } else {
            this.mSeekDuration = 0L;
            this.onError(null, 0, 0);
        }
    }

    @Override
    public void onSeekComplete(IMediaPlayer mp) {
        ILogger.d(TAG, "onSeekComplete,buffer:");
        this.mSeekDuration = 0L;
        this.startTimer();
        this.sPlayerState = PlayerState.STATE_PLAY;
        this.onPlayerState(this.sPlayerState, this.getString(R.string.player_media_seek, "\u5feb\u8fdb\u5feb\u9000\u6062\u590d\u64ad\u653e"));
    }

    @Override
    public void onVideoSizeChanged(IMediaPlayer mp, int width, int height, int sar_num, int sar_den) {
        ILogger.d(TAG, "onVideoSizeChanged,width:" + width + ",height:" + height);
        this.mVideoWidth = width;
        this.mVideoHeight = height;
        if (null != this.mRenderView) {
            this.mRenderView.setVideoSize(width, height);
            this.mRenderView.setZoomMode(IVideoManager.getInstance().getZoomModel());
        }
        if (null != this.mIMediaPlayerControl) {
            this.mIMediaPlayerControl.onVideoSizeChanged(width, height);
        }
    }

    private String getErrorMessage(int what) {
        switch (what) {
            case -1010: 
            case -1007: 
            case -1004: 
            case -110: {
                return this.getString(R.string.player_media_error_timeout, "\u64ad\u653e\u5931\u8d25,\u64ad\u653e\u94fe\u63a5\u8d85\u65f6");
            }
            case -10012: 
            case -10001: {
                return this.getString(R.string.player_media_error_file_invalid, "\u64ad\u653e\u5931\u8d25,\u4e0d\u652f\u6301\u7684\u89c6\u9891\u6587\u4ef6\u683c\u5f0f");
            }
            case -10013: 
            case -10004: 
            case -10003: 
            case -10002: {
                return this.getString(R.string.player_media_error_dns, "\u64ad\u653e\u5931\u8d25,\u94fe\u63a5DNS\u5931\u8d25");
            }
            case -10019: 
            case -10011: 
            case -10010: 
            case -10009: 
            case -10008: 
            case -10007: 
            case -10006: 
            case -10005: 
            case -10000: {
                return this.getString(R.string.player_media_error_path_invalid, "\u64ad\u653e\u5931\u8d25,\u8bf7\u68c0\u67e5\u89c6\u9891\u6587\u4ef6\u5730\u5740\u6709\u6548\u6027");
            }
            case -10017: 
            case -10016: {
                return this.getString(R.string.player_media_error_core, "\u89c6\u9891\u89e3\u7801\u5931\u8d25");
            }
        }
        return what + "";
    }

    private void startPlayer(Object dataSource) {
        if (!this.checkedDataSource()) {
            this.sPlayerState = PlayerState.STATE_ERROR;
            this.onPlayerState(this.sPlayerState, this.getString(R.string.player_media_error_path_empty, "\u64ad\u653e\u5730\u5740\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!"));
            return;
        }
        boolean hasNet = PlayerUtils.getInstance().hasNet(this.mDataSource, this.mAssetsSource);
        if (hasNet && !PlayerUtils.getInstance().isCheckNetwork()) {
            this.sPlayerState = PlayerState.STATE_ERROR;
            this.onPlayerState(this.sPlayerState, this.getString(R.string.player_media_error_net, "\u7f51\u7edc\u672a\u8fde\u63a5"));
            return;
        }
        boolean mobileNetwork = PlayerUtils.getInstance().mobileNetwork(IVideoManager.getInstance().isMobileNetwork());
        if (hasNet && !mobileNetwork) {
            this.sPlayerState = PlayerState.STATE_MOBILE;
            this.onPlayerState(this.sPlayerState, this.getString(R.string.player_media_mobile, "\u79fb\u52a8\u7f51\u7edc\u64ad\u653e"));
            return;
        }
        boolean result = this.createPlayer();
        if (result) {
            this.sPlayerState = PlayerState.STATE_PREPARE;
            this.onPlayerState(this.sPlayerState, this.getString(R.string.player_media_reday, "\u64ad\u653e\u51c6\u5907\u4e2d"));
            try {
                if (dataSource instanceof String) {
                    this.mDataSource = (String)dataSource;
                    this.mMediaPlayer.setDataSource(this.mDataSource);
                } else if (dataSource instanceof AssetFileDescriptor) {
                    this.mAssetsSource = (AssetFileDescriptor)dataSource;
                    this.mMediaPlayer.setDataSource(this.mAssetsSource);
                }
                ILogger.d(TAG, "startPlayer-->source:" + (null != this.mAssetsSource ? this.mAssetsSource : this.mDataSource));
                this.mMediaPlayer.prepareAsync();
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.sPlayerState = PlayerState.STATE_ERROR;
                this.onPlayerState(this.sPlayerState, this.getString(R.string.player_media_play_error, "\u64ad\u653e\u5931\u8d25,error:") + e.getMessage());
            }
        } else {
            this.sPlayerState = PlayerState.STATE_ERROR;
            this.onPlayerState(this.sPlayerState, "ViewGroup is avail");
        }
    }

    private void listenerAudioFocus() {
        if (IVideoManager.getInstance().isInterceptTAudioFocus()) {
            if (null == this.mAudioFocusManager) {
                this.mAudioFocusManager = new AudioFocus();
            }
            this.mAudioFocusManager.requestAudioFocus(this);
        }
    }

    private boolean checkedDataSource() {
        if (!TextUtils.isEmpty((CharSequence)this.mDataSource)) {
            return true;
        }
        return null != this.mAssetsSource;
    }

    private boolean createPlayer() {
        this.releaseTextureView();
        boolean result = this.initMediaPlayer();
        return result;
    }

    private String getString(int id2, String defaultStr) {
        Context context = PlayerUtils.getInstance().getContext();
        if (null != context) {
            return context.getResources().getString(id2);
        }
        return defaultStr;
    }

    private void startTimer() {
        if (null == this.mPlayerTimerTask) {
            this.mTimer = new Timer();
            this.mPlayerTimerTask = new PlayerTimerTask();
            this.mTimer.schedule((TimerTask)this.mPlayerTimerTask, 0L, this.mCallBackSpaceMilliss);
        }
    }

    private void stopTimer() {
        if (null != this.mPlayerTimerTask) {
            this.mPlayerTimerTask.cancel();
            this.mPlayerTimerTask = null;
        }
        if (null != this.mTimer) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
    }

    private void attachedVideoView(BasePlayer basePlayer) {
        ViewGroup viewGroup;
        if (null != this.mRenderView && null != basePlayer && null != (viewGroup = (ViewGroup)basePlayer.findViewById(R.id.player_surface))) {
            PlayerUtils.getInstance().removeViewFromParent(this.mRenderView.getView());
            viewGroup.removeAllViews();
            viewGroup.addView(this.mRenderView.getView(), (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.mRenderView.requestDrawLayout();
        }
    }

    private Object getDataSource() {
        if (!TextUtils.isEmpty((CharSequence)this.mDataSource)) {
            return this.mDataSource;
        }
        if (null != this.mAssetsSource) {
            return this.mAssetsSource;
        }
        return null;
    }

    @Override
    public void onFocusStart() {
        ILogger.d(TAG, "onFocusStart-->");
    }

    @Override
    public void onFocusStop() {
        ILogger.d(TAG, "onFocusStop-->");
        if (this.isPlaying()) {
            this.onPause();
        }
    }

    public void setIMediaPlayerControl(IMediaPlayerControl listener) {
        this.mIMediaPlayerControl = listener;
    }

    public void setDateSource(String dataSource) {
        this.mAssetsSource = null;
        this.mDataSource = dataSource;
    }

    public void setDateSource(AssetFileDescriptor dataSource) {
        this.mAssetsSource = dataSource;
        this.mDataSource = null;
    }

    public void setLoop(boolean loop) {
        this.mLoop = loop;
        if (null != this.mMediaPlayer) {
            try {
                this.mMediaPlayer.setLooping(loop);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean setSoundMute(boolean soundMute) {
        this.mSoundMute = soundMute;
        if (null != this.mMediaPlayer) {
            try {
                this.mMediaPlayer.setVolume(this.mSoundMute ? 0.0f : 1.0f, this.mSoundMute ? 0.0f : 1.0f);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        return this.mSoundMute;
    }

    public boolean isSoundMute() {
        return this.mSoundMute;
    }

    public boolean toggleMute() {
        boolean isMute = !this.mSoundMute;
        this.setSoundMute(isMute);
        return isMute;
    }

    public void setZoomModel(int zoomModel) {
        IVideoManager.getInstance().setZoomModel(zoomModel);
        if (null != this.mRenderView) {
            this.mRenderView.setZoomMode(zoomModel);
        }
    }

    public void setDegree(int degree) {
        if (null != this.mRenderView) {
            this.mRenderView.setDegree(degree);
        }
    }

    public void setInterceptTAudioFocus(boolean interceptTAudioFocus) {
        IVideoManager.getInstance().setInterceptTAudioFocus(interceptTAudioFocus);
    }

    public boolean setMirror(boolean mirror) {
        if (null != this.mRenderView) {
            return this.mRenderView.setMirror(mirror);
        }
        return false;
    }

    public boolean toggleMirror() {
        if (null != this.mRenderView) {
            return this.mRenderView.toggleMirror();
        }
        return false;
    }

    public void setSpeed(float speed) {
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.setSpeed(speed);
        }
    }

    public void setRotation(int rotation) {
        if (null != this.mRenderView) {
            this.mRenderView.setViewRotation(rotation);
        }
    }

    public void setCallBackSpaceMilliss(long callBackSpaceMilliss) {
        this.mCallBackSpaceMilliss = callBackSpaceMilliss;
    }

    public void setMobileNetwork(boolean mobileNetwork) {
        IVideoManager.getInstance().setMobileNetwork(mobileNetwork);
    }

    public int getVideoWidth() {
        return this.mVideoWidth;
    }

    public int getVideoHeight() {
        return this.mVideoHeight;
    }

    public void playOrPause() {
        this.playOrPause(this.getDataSource());
    }

    public void playOrPause(Object dataSource) {
        if (null == dataSource) {
            this.sPlayerState = PlayerState.STATE_ERROR;
            this.onPlayerState(this.sPlayerState, this.getString(R.string.player_media_error_path_empty, "\u64ad\u653e\u5730\u5740\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!"));
            return;
        }
        switch (this.sPlayerState) {
            case STATE_RESET: 
            case STATE_STOP: 
            case STATE_MOBILE: 
            case STATE_COMPLETION: 
            case STATE_ERROR: 
            case STATE_DESTROY: {
                this.startPlayer(dataSource);
                break;
            }
            case STATE_PREPARE: 
            case STATE_BUFFER: 
            case STATE_START: 
            case STATE_PLAY: 
            case STATE_ON_PLAY: {
                this.onPause(true);
                break;
            }
            case STATE_ON_PAUSE: 
            case STATE_PAUSE: {
                this.sPlayerState = PlayerState.STATE_ON_PAUSE;
                this.onResume();
            }
        }
    }

    public boolean isPlaying() {
        try {
            return null != this.mMediaPlayer && (this.sPlayerState.equals((Object)PlayerState.STATE_PREPARE) || this.sPlayerState.equals((Object)PlayerState.STATE_START) || this.sPlayerState.equals((Object)PlayerState.STATE_PLAY) || this.sPlayerState.equals((Object)PlayerState.STATE_ON_PLAY) || this.sPlayerState.equals((Object)PlayerState.STATE_BUFFER));
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    public boolean isWork() {
        try {
            return null != this.mMediaPlayer && (this.sPlayerState.equals((Object)PlayerState.STATE_PREPARE) || this.sPlayerState.equals((Object)PlayerState.STATE_START) || this.sPlayerState.equals((Object)PlayerState.STATE_PLAY) || this.sPlayerState.equals((Object)PlayerState.STATE_ON_PLAY) || this.sPlayerState.equals((Object)PlayerState.STATE_PAUSE) || this.sPlayerState.equals((Object)PlayerState.STATE_ON_PAUSE) || this.sPlayerState.equals((Object)PlayerState.STATE_BUFFER));
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    public PlayerState getPlayerState() {
        return this.sPlayerState;
    }

    public void seekTo(long msec) {
        if (msec < 0L || !this.checkedDataSource()) {
            return;
        }
        if (0L == msec) {
            this.playOrPause();
            return;
        }
        if (this.isWork()) {
            try {
                if (null != this.mMediaPlayer) {
                    this.mMediaPlayer.seekTo(msec);
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        } else {
            this.mSeekDuration = msec;
            this.playOrPause();
        }
    }

    public void seekTo(long msec, boolean accurate) {
        if (msec < 0L || !this.checkedDataSource()) {
            return;
        }
        if (this.isPlaying()) {
            try {
                if (null != this.mMediaPlayer) {
                    this.mMediaPlayer.seekTo(msec, accurate);
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        } else {
            this.mSeekDuration = msec;
            this.playOrPause();
        }
    }

    public void setTimeout(int prepareTimeout, int readTimeout) {
        this.mPrepareTimeout = prepareTimeout;
        this.mReadTimeout = readTimeout;
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.setTimeout(prepareTimeout, readTimeout);
        }
    }

    public long getDurtion() {
        if (null != this.mMediaPlayer) {
            try {
                return this.mMediaPlayer.getDuration();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        return 0L;
    }

    public long getCurrentPosition() {
        if (null != this.mMediaPlayer) {
            try {
                return this.mMediaPlayer.getCurrentPosition();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        return 0L;
    }

    public int getBuffer() {
        if (null != this.mMediaPlayer) {
            try {
                return this.mMediaPlayer.getBuffer();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public void onResume() {
        if (this.checkedDataSource() && this.sPlayerState == PlayerState.STATE_ON_PAUSE) {
            this.startTimer();
            try {
                if (null != this.mMediaPlayer) {
                    this.mMediaPlayer.start();
                }
                this.listenerAudioFocus();
                this.sPlayerState = PlayerState.STATE_ON_PLAY;
                this.onPlayerState(this.sPlayerState, this.getString(R.string.player_media_resume, "\u6062\u590d\u64ad\u653e"));
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }

    public void onPause() {
        this.onPause(false);
    }

    private void onPause(boolean isClick) {
        if (this.checkedDataSource() && this.isPlaying()) {
            this.stopTimer();
            try {
                if (null != this.mMediaPlayer) {
                    this.mMediaPlayer.pause();
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            this.sPlayerState = isClick ? PlayerState.STATE_PAUSE : PlayerState.STATE_ON_PAUSE;
            this.onPlayerState(this.sPlayerState, this.getString(R.string.player_media_pause, "\u6682\u505c\u64ad\u653e"));
        }
    }

    public void onCompletion() {
        this.stopTimer();
        this.releaseTextureView();
        this.sPlayerState = PlayerState.STATE_COMPLETION;
        this.onPlayerState(this.sPlayerState, this.getString(R.string.player_media_completion, "\u64ad\u653e\u7ed3\u675f"));
    }

    public void onStop() {
        this.stopTimer();
        this.releaseTextureView();
        this.sPlayerState = PlayerState.STATE_STOP;
        this.onPlayerState(this.sPlayerState, this.getString(R.string.player_media_stop, "\u505c\u6b62\u64ad\u653e"));
    }

    public void onReset() {
        this.stopTimer();
        this.releaseTextureView();
        this.mDataSource = null;
        this.mAssetsSource = null;
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
        this.sPlayerState = PlayerState.STATE_RESET;
        this.onPlayerState(this.sPlayerState, this.getString(R.string.player_media_reset, "\u7ed3\u675f\u64ad\u653e\u5e76\u91cd\u7f6e"));
    }

    public void onDestroy() {
        this.stopTimer();
        ThreadPool.getInstance().reset();
        this.releaseTextureView();
        this.sPlayerState = PlayerState.STATE_DESTROY;
        this.onPlayerState(this.sPlayerState, this.getString(R.string.player_media_destroy, "\u64ad\u653e\u5668\u9500\u6bc1"));
        if (null != this.mAudioFocusManager) {
            this.mAudioFocusManager.onDestroy();
            this.mAudioFocusManager = null;
        }
        this.mLoop = false;
        this.mSoundMute = false;
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
        this.mPrepareTimeout = 0;
        this.mReadTimeout = 0;
        IVideoManager.getInstance().setZoomModel(1);
        this.mIMediaPlayerControl = null;
        this.mDataSource = null;
        this.mAssetsSource = null;
        this.mCallBackSpaceMilliss = this.DEFAULT_CALLBACK_TIME;
    }

    private class PlayerTimerTask
    extends TimerTask {
        private PlayerTimerTask() {
        }

        @Override
        public void run() {
            try {
                if (null != IVideoPlayer.this.mMediaPlayer && IVideoPlayer.this.isPlaying()) {
                    ThreadPool.getInstance().runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                IVideoPlayer.this.onProgress(IVideoPlayer.this.mMediaPlayer.getCurrentPosition(), IVideoPlayer.this.mMediaPlayer.getDuration());
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }
}

