/*
 * Decompiled with CFR 0.152.
 */
package com.android.iplayer.interfaces;

import android.content.res.AssetFileDescriptor;
import android.os.Bundle;
import android.view.Surface;
import java.io.IOException;
import java.util.Map;

public interface IMediaPlayer {
    public static final int ORIENTATION_PORTRAIT = 0;
    public static final int ORIENTATION_LANDSCAPE = 1;
    public static final int MODE_ZOOM_TO_FIT = 0;
    public static final int MODE_ZOOM_CROPPING = 1;
    public static final int MODE_NOZOOM_TO_FIT = 2;
    public static final int MEDIA_INFO_VIDEO_RENDERING_START = 3;
    public static final int MEDIA_INFO_BUFFERING_START = 701;
    public static final int MEDIA_INFO_BUFFERING_END = 702;
    public static final int MEDIA_INFO_NETWORK_BANDWIDTH = 703;
    public static final int MEDIA_INFO_VIDEO_ROTATION_CHANGED = 10001;
    public static final int MEDIA_ERROR_IO = -1004;
    public static final int MEDIA_ERROR_MALFORMED = -1007;
    public static final int MEDIA_ERROR_UNSUPPORTED = -1010;
    public static final int MEDIA_ERROR_TIMED_OUT = -110;
    public static final int MEDIA_ERROR_UNSUPPORT_PROTOCOL = -10001;
    public static final int MEDIA_ERROR_DNS_PARSE_FAILED = -10002;
    public static final int MEDIA_ERROR_CREATE_SOCKET_FAILED = -10003;
    public static final int MEDIA_ERROR_CONNECT_SERVER_FAILED = -10004;
    public static final int MEDIA_ERROR_BAD_REQUEST = -10005;
    public static final int MEDIA_ERROR_UNAUTHORIZED_CLIENT = -10006;
    public static final int MEDIA_ERROR_ACCESSS_FORBIDDEN = -10007;
    public static final int MEDIA_ERROR_TARGET_NOT_FOUND = -10008;
    public static final int MEDIA_ERROR_FILE_NOT_FOUND = -10000;
    public static final int MEDIA_ERROR_OTHER_ERROR_CODE = -10009;
    public static final int MEDIA_ERROR_SERVER_EXCEPTION = -10010;
    public static final int MEDIA_ERROR_INVALID_DATA = -10011;
    public static final int MEDIA_ERROR_UNSUPPORT_VIDEO_CODEC = -10012;
    public static final int MEDIA_ERROR_UNSUPPORT_AUDIO_CODEC = -10013;
    public static final int MEDIA_ERROR_VIDEO_DECODE_FAILED = -10016;
    public static final int MEDIA_ERROR_AUDIO_DECODE_FAILED = -10017;
    public static final int MEDIA_ERROR_3XX_OVERFLOW = -10018;
    public static final int MEDIA_ERROR_INVALID_URL = -10019;

    public void setLooping(boolean var1);

    public void setVolume(float var1, float var2);

    public void setBufferTimeMax(float var1);

    public void setSurface(Surface var1);

    public void setDataSource(String var1) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException;

    public void setDataSource(String var1, Map<String, String> var2) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException;

    public void setDataSource(AssetFileDescriptor var1) throws IOException, IllegalArgumentException, IllegalStateException;

    public void setTimeout(int var1, int var2);

    public void setSpeed(float var1);

    public void seekTo(long var1) throws IllegalStateException;

    public void seekTo(long var1, boolean var3) throws IllegalStateException;

    public boolean isPlaying();

    public long getCurrentPosition();

    public long getDuration();

    public int getBuffer();

    public void prepare() throws IOException, IllegalStateException;

    public void prepareAsync() throws IllegalStateException;

    public void start();

    public void pause();

    public void stop();

    public void reset();

    public void release();

    public void setOnPreparedListener(OnPreparedListener var1);

    public void setOnCompletionListener(OnCompletionListener var1);

    public void setOnBufferingUpdateListener(OnBufferingUpdateListener var1);

    public void setOnSeekCompleteListener(OnSeekCompleteListener var1);

    public void setOnVideoSizeChangedListener(OnVideoSizeChangedListener var1);

    public void setOnErrorListener(OnErrorListener var1);

    public void setOnInfoListener(OnInfoListener var1);

    public void setOnTimedTextListener(OnTimedTextListener var1);

    public void setOnMessageListener(OnMessageListener var1);

    public static interface OnMessageListener {
        public void onMessage(IMediaPlayer var1, Bundle var2);
    }

    public static interface OnLogEventListener {
        public void onLogEvent(IMediaPlayer var1, String var2);
    }

    public static interface OnTimedTextListener {
        public void onTimedText(IMediaPlayer var1, String var2);
    }

    public static interface OnInfoListener {
        public boolean onInfo(IMediaPlayer var1, int var2, int var3);
    }

    public static interface OnErrorListener {
        public boolean onError(IMediaPlayer var1, int var2, int var3);
    }

    public static interface OnVideoSizeChangedListener {
        public void onVideoSizeChanged(IMediaPlayer var1, int var2, int var3, int var4, int var5);
    }

    public static interface OnSeekCompleteListener {
        public void onSeekComplete(IMediaPlayer var1);
    }

    public static interface OnBufferingUpdateListener {
        public void onBufferingUpdate(IMediaPlayer var1, int var2);
    }

    public static interface OnCompletionListener {
        public void onCompletion(IMediaPlayer var1);
    }

    public static interface OnPreparedListener {
        public void onPrepared(IMediaPlayer var1);
    }
}

