/*
 * Decompiled with CFR 0.152.
 */
package com.hss01248.image.config;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.WindowManager;
import com.hss01248.image.interfaces.ILoader;

public class GlobalConfig {
    public static String baseUrl;
    public static Context context;
    private static Handler mainHandler;
    private static int winHeight;
    private static int winWidth;
    private static boolean userFresco;
    public static int cacheMaxSize;
    public static String cacheFolderName;
    public static boolean highQuality;
    public static boolean ignoreCertificateVerify;
    public static boolean isBigImageDark;
    private static ILoader loader;
    public static int placeHolderResId;
    public static int placeHolderScaleType;
    public static int errorResId;
    public static int errorScaleType;
    public static int loadingResId;
    public static int loadingScaleType;

    public static Handler getMainHandler() {
        if (mainHandler == null) {
            mainHandler = new Handler(Looper.getMainLooper());
        }
        return mainHandler;
    }

    public static int getWinHeight() {
        if (GlobalConfig.context.getResources().getConfiguration().orientation == 2) {
            return winHeight < winWidth ? winHeight : winWidth;
        }
        if (GlobalConfig.context.getResources().getConfiguration().orientation == 1) {
            return winHeight > winWidth ? winHeight : winWidth;
        }
        return winHeight;
    }

    public static int getWinWidth() {
        if (GlobalConfig.context.getResources().getConfiguration().orientation == 2) {
            return winHeight > winWidth ? winHeight : winWidth;
        }
        if (GlobalConfig.context.getResources().getConfiguration().orientation == 1) {
            return winHeight < winWidth ? winHeight : winWidth;
        }
        return winWidth;
    }

    public static void init(Context context, int cacheSizeInM, ILoader imageLoader) {
        GlobalConfig.context = context;
        cacheMaxSize = cacheSizeInM;
        WindowManager wm = (WindowManager)context.getSystemService("window");
        winWidth = wm.getDefaultDisplay().getWidth();
        winHeight = wm.getDefaultDisplay().getHeight();
        loader = imageLoader;
        imageLoader.init(context, cacheSizeInM);
    }

    public static void setBigImageDark(boolean isBigImageDark) {
        GlobalConfig.isBigImageDark = isBigImageDark;
    }

    public static void setLoader(ILoader loader) {
        GlobalConfig.loader = loader;
    }

    public static ILoader getLoader() {
        return loader;
    }

    public static void setDefaultPlaceHolder(int placeHolderResId) {
        GlobalConfig.placeHolderResId = placeHolderResId;
    }

    public static void setDefaultPlaceHolderScaleType(int placeHolderScaleType) {
        GlobalConfig.placeHolderScaleType = placeHolderScaleType;
    }

    public static void setDefaultErrorHolder(int errorResId) {
        GlobalConfig.errorResId = errorResId;
    }

    public static void setDefaultErrorHolderScaleType(int errorScaleType) {
        GlobalConfig.errorScaleType = errorScaleType;
    }

    public static void setDefaultLoadingHolder(int loadingResId) {
        GlobalConfig.loadingResId = loadingResId;
    }

    static {
        cacheMaxSize = 150;
        cacheFolderName = "imageCache";
        highQuality = false;
        ignoreCertificateVerify = false;
        isBigImageDark = true;
        placeHolderScaleType = 1;
        errorScaleType = 8;
        loadingScaleType = 8;
    }
}

