/*
 * Decompiled with CFR 0.152.
 */
package com.github.piasy.biv.view;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.LinearInterpolator;
import com.hss01248.image.R;

public class CircleLoadingView
extends View {
    private Paint paint;
    private int startColor;
    private int endColor;
    private RectF rect;
    private Shader shader;
    private Matrix matrix;
    private float circleThicknessRatio;
    private float rate = 0.0f;
    private ObjectAnimator animator;

    public CircleLoadingView(Context context) {
        super(context);
        this.init(context, null);
    }

    public CircleLoadingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public CircleLoadingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CircleLoadingView);
        this.startColor = typedArray.getColor(R.styleable.CircleLoadingView_startColor, -2006555034);
        this.endColor = typedArray.getColor(R.styleable.CircleLoadingView_endColor, 0);
        this.circleThicknessRatio = typedArray.getDimension(R.styleable.CircleLoadingView_circleThicknessRatio, 0.1f);
        typedArray.recycle();
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setStrokeCap(Paint.Cap.ROUND);
        this.paint.setStyle(Paint.Style.STROKE);
        this.rect = new RectF();
        this.animator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"rate", (float[])new float[]{0.0f, 1.0f});
        this.animator.setDuration(800L);
        this.animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.animator.setRepeatCount(-1);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.initRect(this.getMeasuredWidth(), this.getMeasuredHeight());
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.initRect(w, h);
    }

    private void initRect(float width, float height) {
        if (width > height) {
            this.rect.left = (width - height) / 2.0f;
            this.rect.right = width - this.rect.left;
            this.rect.top = 0.0f;
            this.rect.bottom = height;
        } else {
            this.rect.left = 0.0f;
            this.rect.right = width;
            this.rect.top = (height - width) / 2.0f;
            this.rect.bottom = height - this.rect.top;
        }
        int circleThickness = (int)(width * this.circleThicknessRatio);
        this.paint.setStrokeWidth((float)circleThickness);
        this.rect.left += (float)(circleThickness / 2);
        this.rect.right -= (float)(circleThickness / 2);
        this.rect.top += (float)(circleThickness / 2);
        this.rect.bottom -= (float)(circleThickness / 2);
        this.shader = new SweepGradient(width / 2.0f, height / 2.0f, this.endColor, this.startColor);
        this.matrix = new Matrix();
        this.matrix.setRotate(-70.0f, width / 2.0f, height / 2.0f);
        this.shader.setLocalMatrix(this.matrix);
        this.paint.setShader(this.shader);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        canvas.drawArc(this.rect, -60.0f + 360.0f * this.rate, 330.0f, false, this.paint);
    }

    private void refresh() {
        if (this.paint != null && this.matrix != null && this.shader != null) {
            this.matrix.setRotate(-70.0f + 360.0f * this.rate, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
            this.shader.setLocalMatrix(this.matrix);
            this.paint.setShader(this.shader);
            this.invalidate();
        }
    }

    public float getRate() {
        return this.rate;
    }

    public void setRate(float rate) {
        this.rate = rate;
        this.refresh();
    }

    public float getCircleThicknessRatio() {
        return this.circleThicknessRatio;
    }

    public void setCircleThicknessRatio(float circleThicknessRatio) {
        this.circleThicknessRatio = circleThicknessRatio;
    }

    public void setStartColor(int startColor) {
        this.startColor = startColor;
    }

    public void setEndColor(int endColor) {
        this.endColor = endColor;
    }

    private void animStart() {
        if (this.animator != null && !this.animator.isStarted()) {
            this.animator.start();
        }
    }

    private void animStop() {
        if (this.animator != null && this.animator.isStarted()) {
            this.animator.cancel();
        }
    }

    public int dip2px(float dpValue) {
        float scale = this.getContext().getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.animStart();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.animStop();
    }
}

