/*
 * Decompiled with CFR 0.152.
 */
package com.github.piasy.biv;

import android.net.Uri;
import com.github.piasy.biv.loader.BigLoader;

public final class BigImageViewer {
    private static volatile BigImageViewer sInstance;
    private final BigLoader mImageLoader;

    private BigImageViewer(BigLoader imageLoader) {
        this.mImageLoader = imageLoader;
    }

    public static void initialize(BigLoader imageLoader) {
        sInstance = new BigImageViewer(imageLoader);
    }

    public static BigLoader imageLoader() {
        if (sInstance == null) {
            throw new IllegalStateException("You must initialize BigImageViewer before use it!");
        }
        return BigImageViewer.sInstance.mImageLoader;
    }

    public static void prefetch(Uri ... uris) {
        if (uris == null) {
            return;
        }
        BigLoader imageLoader = BigImageViewer.imageLoader();
        for (Uri uri : uris) {
            imageLoader.prefetch(uri);
        }
    }
}

