/*
 * Decompiled with CFR 0.152.
 */
package com.hss01248.image.config;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import android.view.View;
import com.hss01248.image.MyUtil;
import com.hss01248.image.config.GlobalConfig;
import java.io.File;

public class SingleConfig {
    private Context context;
    private boolean ignoreCertificateVerify;
    private String url;
    private String thumbnailUrl;
    private String filePath;
    private int resId;
    private String contentProvider;
    private boolean isGif;
    private View target;
    private int width;
    private int height;
    private boolean needBlur;
    private int blurRadius;
    private int placeHolderResId;
    private boolean reuseable;
    private int loadingResId;
    private int errorResId;
    private int shapeMode;
    private int rectRoundRadius;
    private int roundOverlayColor;
    private int scaleMode;
    private int borderWidth;
    private int borderColor;
    private boolean asBitmap;
    private BitmapListener bitmapListener;

    public Context getContext() {
        if (this.context == null) {
            this.context = GlobalConfig.context;
        }
        return this.context;
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public String getContentProvider() {
        return this.contentProvider;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getHeight() {
        if (this.height <= 0) {
            if (this.target != null) {
                this.height = this.target.getMeasuredWidth();
            }
            if (this.height <= 0) {
                this.height = GlobalConfig.getWinWidth();
            }
        }
        return this.height;
    }

    public boolean isNeedBlur() {
        return this.needBlur;
    }

    public int getPlaceHolderResId() {
        return this.placeHolderResId;
    }

    public int getRectRoundRadius() {
        return this.rectRoundRadius;
    }

    public int getResId() {
        return this.resId;
    }

    public int getScaleMode() {
        return this.scaleMode;
    }

    public int getShapeMode() {
        return this.shapeMode;
    }

    public View getTarget() {
        return this.target;
    }

    public String getUrl() {
        return this.url;
    }

    public int getWidth() {
        if (this.width <= 0) {
            if (this.target != null) {
                this.width = this.target.getMeasuredWidth();
            }
            if (this.width <= 0) {
                this.width = GlobalConfig.getWinWidth();
            }
        }
        return this.width;
    }

    public int getRoundOverlayColor() {
        return this.roundOverlayColor;
    }

    public boolean isIgnoreCertificateVerify() {
        return this.ignoreCertificateVerify;
    }

    public BitmapListener getBitmapListener() {
        return this.bitmapListener;
    }

    public String getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    public int getLoadingResId() {
        return this.loadingResId;
    }

    public int getErrorResId() {
        return this.errorResId;
    }

    public boolean isReuseable() {
        return this.reuseable;
    }

    public boolean isAsBitmap() {
        return this.asBitmap;
    }

    public void setBitmapListener(BitmapListener bitmapListener) {
        this.bitmapListener = MyUtil.getBitmapListenerProxy(bitmapListener);
    }

    private void show() {
        GlobalConfig.getLoader().request(this);
    }

    public boolean isGif() {
        return this.isGif;
    }

    public int getBlurRadius() {
        return this.blurRadius;
    }

    public SingleConfig(ConfigBuilder builder) {
        this.url = builder.url;
        this.thumbnailUrl = builder.thumbnailUrl;
        this.filePath = builder.filePath;
        this.resId = builder.resId;
        this.contentProvider = builder.contentProvider;
        this.ignoreCertificateVerify = builder.ignoreCertificateVerify;
        this.target = builder.target;
        this.width = builder.width;
        this.height = builder.height;
        this.shapeMode = builder.shapeMode;
        if (this.shapeMode == 1) {
            this.rectRoundRadius = builder.rectRoundRadius;
        }
        this.scaleMode = builder.scaleMode;
        this.needBlur = builder.needBlur;
        this.placeHolderResId = builder.placeHolderResId;
        this.borderWidth = builder.borderWidth;
        if (this.borderWidth > 0) {
            this.borderColor = builder.borderColor;
        }
        this.asBitmap = builder.asBitmap;
        this.bitmapListener = builder.bitmapListener;
        this.roundOverlayColor = builder.roundOverlayColor;
        this.isGif = builder.isGif;
        this.blurRadius = builder.blurRadius;
        this.reuseable = builder.reuseable;
        this.loadingResId = builder.loadingResId;
        this.errorResId = builder.errorResId;
    }

    public static class ConfigBuilder {
        private Context context;
        private boolean ignoreCertificateVerify = GlobalConfig.ignoreCertificateVerify;
        private String url;
        private String thumbnailUrl;
        private String filePath;
        private int resId;
        private String contentProvider;
        private boolean isGif = false;
        private View target;
        private boolean asBitmap;
        private BitmapListener bitmapListener;
        private int width;
        private int height;
        private boolean needBlur = false;
        private int blurRadius;
        private int placeHolderResId;
        private boolean reuseable;
        private int loadingResId;
        private int errorResId;
        private int shapeMode;
        private int rectRoundRadius;
        private int roundOverlayColor;
        private int scaleMode;
        private int borderWidth;
        private int borderColor;

        public ConfigBuilder setRoundOverlayColor(int roundOverlayColor) {
            this.roundOverlayColor = roundOverlayColor;
            return this;
        }

        public ConfigBuilder(Context context) {
            this.context = context;
        }

        public ConfigBuilder ignoreCertificateVerify(boolean ignoreCertificateVerify) {
            this.ignoreCertificateVerify = ignoreCertificateVerify;
            return this;
        }

        public ConfigBuilder url(String url) {
            this.url = url;
            if (url.contains("gif")) {
                this.isGif = true;
            }
            return this;
        }

        public ConfigBuilder thumbnail(String thumbnailUrl) {
            this.thumbnailUrl = thumbnailUrl;
            return this;
        }

        public ConfigBuilder loading(int loadingResId) {
            this.loadingResId = loadingResId;
            return this;
        }

        public ConfigBuilder error(int errorResId) {
            this.errorResId = errorResId;
            return this;
        }

        public ConfigBuilder file(String filePath) {
            if (filePath.startsWith("content:")) {
                this.contentProvider = filePath;
                return this;
            }
            if (!new File(filePath).exists()) {
                Log.e((String)"imageloader", (String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
                return this;
            }
            this.filePath = filePath;
            if (filePath.contains("gif")) {
                this.isGif = true;
            }
            return this;
        }

        public ConfigBuilder res(int resId) {
            this.resId = resId;
            return this;
        }

        public ConfigBuilder content(String contentProvider) {
            this.contentProvider = contentProvider;
            return this;
        }

        public void into(View targetView) {
            this.target = targetView;
            new SingleConfig(this).show();
        }

        public void asBitmap(BitmapListener bitmapListener) {
            this.bitmapListener = MyUtil.getBitmapListenerProxy(bitmapListener);
            this.asBitmap = true;
            new SingleConfig(this).show();
        }

        public ConfigBuilder widthHeight(int width, int height) {
            this.width = MyUtil.dip2px(width);
            this.height = MyUtil.dip2px(height);
            return this;
        }

        public ConfigBuilder placeHolder(int placeHolderResId, boolean reuseable) {
            this.placeHolderResId = placeHolderResId;
            this.reuseable = reuseable;
            return this;
        }

        public ConfigBuilder blur(int blurRadius) {
            this.needBlur = true;
            this.blurRadius = blurRadius;
            return this;
        }

        public ConfigBuilder asCircle(int overlayColorWhenGif) {
            this.shapeMode = 2;
            this.roundOverlayColor = overlayColorWhenGif;
            return this;
        }

        public ConfigBuilder rectRoundCorner(int rectRoundRadius, int overlayColorWhenGif) {
            this.rectRoundRadius = MyUtil.dip2px(rectRoundRadius);
            this.shapeMode = 1;
            this.roundOverlayColor = overlayColorWhenGif;
            return this;
        }

        public ConfigBuilder scale(int scaleMode) {
            this.scaleMode = scaleMode;
            return this;
        }

        public ConfigBuilder border(int borderWidth, int borderColor) {
            this.borderWidth = MyUtil.dip2px(borderWidth);
            this.borderColor = borderColor;
            return this;
        }
    }

    public static interface BitmapListener {
        public void onSuccess(Bitmap var1);

        public void onFail();
    }
}

