/*
 * Decompiled with CFR 0.152.
 */
package com.hss01248.image;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.github.piasy.biv.indicator.ProgressPieIndicator;
import com.github.piasy.biv.view.BigImageView;
import com.hss01248.image.R;
import com.hss01248.image.config.GlobalConfig;
import com.hss01248.image.config.SingleConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;

public class MyUtil {
    public static SingleConfig.BitmapListener getBitmapListenerProxy(final SingleConfig.BitmapListener listener) {
        return (SingleConfig.BitmapListener)Proxy.newProxyInstance(SingleConfig.class.getClassLoader(), listener.getClass().getInterfaces(), new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
                MyUtil.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Object object = method.invoke((Object)listener, args);
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }
                });
                return null;
            }
        });
    }

    public static void runOnUIThread(Runnable runnable) {
        GlobalConfig.getMainHandler().post(runnable);
    }

    public static void viewBigImage(SingleConfig config) {
        BigImageView bigImageView = (BigImageView)config.getTarget();
        if (!TextUtils.isEmpty((CharSequence)config.getUrl()) && !GlobalConfig.getLoader().isCached(config.getUrl())) {
            bigImageView.setProgressIndicator(new ProgressPieIndicator());
        } else {
            bigImageView.setProgressIndicator(null);
            int count = bigImageView.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = bigImageView.getChildAt(i);
                if (child.findViewById(R.id.progressBar00) == null) continue;
                child.setVisibility(4);
            }
        }
        bigImageView.showImage(MyUtil.buildUriByType(config));
    }

    public static boolean shouldSetPlaceHolder(SingleConfig config) {
        if (config.isReuseable()) {
            return true;
        }
        if (config.getPlaceHolderResId() <= 0) {
            return false;
        }
        return config.getResId() <= 0 && TextUtils.isEmpty((CharSequence)config.getFilePath()) && !GlobalConfig.getLoader().isCached(config.getUrl());
    }

    public static int dip2px(float dipValue) {
        float scale = GlobalConfig.context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    public static Bitmap compressBitmap(Bitmap bitmap, boolean needRecycle, int targetWidth, int targeHeight) {
        float sourceWidth = bitmap.getWidth();
        float sourceHeight = bitmap.getHeight();
        float scaleWidth = (float)targetWidth / sourceWidth;
        float scaleHeight = (float)targeHeight / sourceHeight;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap bm = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        if (needRecycle) {
            bitmap.recycle();
        }
        bitmap = bm;
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRealType(File file) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            byte[] b = new byte[4];
            try {
                is.read(b, 0, b.length);
            }
            catch (IOException e) {
                e.printStackTrace();
                String string = "";
                try {
                    is.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return string;
            }
            String type = MyUtil.bytesToHexString(b).toUpperCase();
            if (type.contains("FFD8FF")) {
                String string = "jpg";
                return string;
            }
            if (type.contains("89504E47")) {
                String string = "png";
                return string;
            }
            if (type.contains("47494638")) {
                String string = "gif";
                return string;
            }
            if (type.contains("49492A00")) {
                String string = "tif";
                return string;
            }
            if (type.contains("424D")) {
                String string = "bmp";
                return string;
            }
            String string = type;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = "";
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static Uri buildUriByType(SingleConfig config) {
        File file;
        Log.e((String)"builduri:", (String)("url: " + config.getUrl() + " ---filepath:" + config.getFilePath() + "--content:" + config.getContentProvider()));
        if (!TextUtils.isEmpty((CharSequence)config.getUrl())) {
            String url = MyUtil.appendUrl(config.getUrl());
            return Uri.parse((String)url);
        }
        if (config.getResId() > 0) {
            return Uri.parse((String)("res://imageloader/" + config.getResId()));
        }
        if (!TextUtils.isEmpty((CharSequence)config.getFilePath()) && (file = new File(config.getFilePath())).exists()) {
            return Uri.fromFile((File)file);
        }
        if (!TextUtils.isEmpty((CharSequence)config.getContentProvider())) {
            String content = config.getContentProvider();
            if (!content.startsWith("content")) {
                content = "content://" + content;
            }
            return Uri.parse((String)content);
        }
        return null;
    }

    public static String appendUrl(String url) {
        boolean hasHost;
        String newUrl = url;
        if (TextUtils.isEmpty((CharSequence)newUrl)) {
            return newUrl;
        }
        boolean bl = hasHost = url.contains("http:") || url.contains("https:");
        if (!hasHost && !TextUtils.isEmpty((CharSequence)GlobalConfig.baseUrl)) {
            newUrl = GlobalConfig.baseUrl + url;
        }
        return newUrl;
    }

    public static OkHttpClient getClient(boolean ignoreCertificateVerify) {
        if (ignoreCertificateVerify) {
            return MyUtil.getAllPassClient();
        }
        return MyUtil.getNormalClient();
    }

    private static OkHttpClient getAllPassClient() {
        X509TrustManager xtm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                X509Certificate[] x509Certificates = new X509Certificate[]{};
                return x509Certificates;
            }
        };
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{xtm}, new SecureRandom());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        OkHttpClient client = new OkHttpClient.Builder().sslSocketFactory(sslContext.getSocketFactory()).hostnameVerifier(DO_NOT_VERIFY).readTimeout(0L, TimeUnit.SECONDS).connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(0L, TimeUnit.SECONDS).build();
        return client;
    }

    private static OkHttpClient getNormalClient() {
        OkHttpClient client = new OkHttpClient.Builder().readTimeout(0L, TimeUnit.SECONDS).connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(0L, TimeUnit.SECONDS).build();
        return client;
    }
}

