/*
 * Decompiled with CFR 0.152.
 */
package com.hss01248.dialog.fullscreen;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.hss01248.dialog.R;

public class FullScreenDialog
extends Dialog
implements DefaultLifecycleObserver {
    public FullScreenDialog(Context context) {
        this(context, R.style.Dialog_FullScreen);
        this.init2(context);
    }

    public FullScreenDialog(Context context, int theme) {
        super(context, theme);
        this.init2(context);
    }

    protected FullScreenDialog(Context context, boolean cancelable, DialogInterface.OnCancelListener cancelListener) {
        this(context, R.style.Dialog_FullScreen);
        this.setCancelable(cancelable);
        this.setOnCancelListener(cancelListener);
        this.init2(context);
    }

    private void init2(Context context) {
        this.getWindow().requestFeature(1);
        FullScreenDialog.setDialogToFullScreen(this);
    }

    public static void setDialogToFullScreen(Dialog dialog) {
        WindowManager.LayoutParams attributes;
        Window window = dialog.getWindow();
        window.setBackgroundDrawable((Drawable)new ColorDrawable(-1));
        dialog.getWindow().setDimAmount(0.0f);
        dialog.getWindow().setFlags(0x4000000, 0x4000000);
        window.getDecorView().setSystemUiVisibility(1280);
        if (Build.VERSION.SDK_INT >= 21) {
            window.setStatusBarColor(0);
            window.setNavigationBarColor(-1);
        }
        if (Build.VERSION.SDK_INT >= 29) {
            // empty if block
        }
        if ((attributes = window.getAttributes()) == null) {
            attributes = new WindowManager.LayoutParams(-1, -1);
        } else {
            attributes.width = -1;
            attributes.height = -1;
        }
        window.setAttributes(attributes);
    }

    public void show() {
        if (this.getWindow() != null && this.getWindow().getDecorView() != null) {
            this.getWindow().getDecorView().setSystemUiVisibility(1280);
        }
        super.show();
    }

    public void onDestroy(@NonNull LifecycleOwner owner) {
        super.onDestroy(owner);
    }
}

