/*
 * Decompiled with CFR 0.152.
 */
package com.hss01248.dialog.view;

import android.app.Dialog;
import android.content.DialogInterface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import com.hss01248.dialog.Tool;
import com.hss01248.dialog.config.ConfigBean;

public class DialogUtilDialogFragment
extends DialogFragment {
    protected View myRootView;
    protected ConfigBean bean;

    public void setConfigbean(ConfigBean bean) {
        this.bean = bean;
    }

    public void setRootView(View rootView) {
        this.myRootView = rootView;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        this.getDialog().requestWindowFeature(1);
        this.getDialog().getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.getDialog().setCanceledOnTouchOutside(true);
        this.getDialog().setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                if (keyCode == 4 && event.getAction() == 0 && DialogUtilDialogFragment.this.bean.cancelable) {
                    DialogUtilDialogFragment.this.dismiss();
                    return true;
                }
                return false;
            }
        });
        return this.myRootView;
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        if (this.bean.alertDialog != null) {
            return this.bean.alertDialog;
        }
        return super.onCreateDialog(savedInstanceState);
    }

    public void onStart() {
        super.onStart();
        Window window = this.getDialog().getWindow();
        WindowManager.LayoutParams lp = window.getAttributes();
        lp.gravity = this.bean.gravity;
        window.setAttributes(lp);
        Tool.adjustWH(this.getDialog(), this.bean);
    }
}

