/*
 * Decompiled with CFR 0.152.
 */
package com.hss01248.dialog.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Movie;
import android.os.Build;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.View;
import com.hss01248.dialog.R;
import java.io.InputStream;

public class GifMovieView
extends View {
    private static final int DEFAULT_MOVIEW_DURATION = 1000;
    private int mMovieResourceId;
    private Movie mMovie;
    private long mMovieStart;
    private int mCurrentAnimationTime = 0;
    private float mLeft;
    private float mTop;
    private float mScale;
    private int mMeasuredMovieWidth;
    private int mMeasuredMovieHeight;
    private volatile boolean mPaused = false;
    private boolean mVisible = true;

    public GifMovieView(Context context) {
        this(context, null);
    }

    public GifMovieView(Context context, AttributeSet attrs) {
        this(context, attrs, R.styleable.CustomTheme_gifMoviewViewStyle);
    }

    public GifMovieView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setViewAttributes(context, attrs, defStyle);
    }

    @SuppressLint(value={"NewApi"})
    private void setViewAttributes(Context context, AttributeSet attrs, int defStyle) {
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, null);
        }
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.GifMoviewView, defStyle, R.style.Widget_GifMoviewView);
        this.mMovieResourceId = array.getResourceId(R.styleable.GifMoviewView_gif, -1);
        this.mPaused = array.getBoolean(R.styleable.GifMoviewView_paused, false);
        array.recycle();
        if (this.mMovieResourceId != -1) {
            this.mMovie = Movie.decodeStream((InputStream)this.getResources().openRawResource(this.mMovieResourceId));
        }
    }

    public void setMovieResource(int movieResId) {
        this.mMovieResourceId = movieResId;
        this.mMovie = Movie.decodeStream((InputStream)this.getResources().openRawResource(this.mMovieResourceId));
        this.requestLayout();
    }

    public void setMovie(Movie movie) {
        this.mMovie = movie;
        this.requestLayout();
    }

    public Movie getMovie() {
        return this.mMovie;
    }

    public void setMovieTime(int time) {
        this.mCurrentAnimationTime = time;
        this.invalidate();
    }

    public void setPaused(boolean paused) {
        this.mPaused = paused;
        if (!paused) {
            this.mMovieStart = SystemClock.uptimeMillis() - (long)this.mCurrentAnimationTime;
        }
        this.invalidate();
    }

    public boolean isPaused() {
        return this.mPaused;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mMovie != null) {
            int maximumHeight;
            int maximumWidth;
            int movieWidth = this.mMovie.width();
            int movieHeight = this.mMovie.height();
            float scaleH = 1.0f;
            int measureModeWidth = View.MeasureSpec.getMode((int)widthMeasureSpec);
            if (measureModeWidth != 0 && movieWidth > (maximumWidth = View.MeasureSpec.getSize((int)widthMeasureSpec))) {
                scaleH = (float)movieWidth / (float)maximumWidth;
            }
            float scaleW = 1.0f;
            int measureModeHeight = View.MeasureSpec.getMode((int)heightMeasureSpec);
            if (measureModeHeight != 0 && movieHeight > (maximumHeight = View.MeasureSpec.getSize((int)heightMeasureSpec))) {
                scaleW = (float)movieHeight / (float)maximumHeight;
            }
            this.mScale = 1.0f / Math.max(scaleH, scaleW);
            this.mMeasuredMovieWidth = (int)((float)movieWidth * this.mScale);
            this.mMeasuredMovieHeight = (int)((float)movieHeight * this.mScale);
            this.setMeasuredDimension(this.mMeasuredMovieWidth, this.mMeasuredMovieHeight);
        } else {
            this.setMeasuredDimension(this.getSuggestedMinimumWidth(), this.getSuggestedMinimumHeight());
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.mLeft = (float)(this.getWidth() - this.mMeasuredMovieWidth) / 2.0f;
        this.mTop = (float)(this.getHeight() - this.mMeasuredMovieHeight) / 2.0f;
        this.mVisible = this.getVisibility() == 0;
    }

    protected void onDraw(Canvas canvas) {
        if (this.mMovie != null) {
            if (!this.mPaused) {
                this.updateAnimationTime();
                this.drawMovieFrame(canvas);
                this.invalidateView();
            } else {
                this.drawMovieFrame(canvas);
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    private void invalidateView() {
        if (this.mVisible) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.postInvalidateOnAnimation();
            } else {
                this.invalidate();
            }
        }
    }

    private void updateAnimationTime() {
        int dur;
        long now = SystemClock.uptimeMillis();
        if (this.mMovieStart == 0L) {
            this.mMovieStart = now;
        }
        if ((dur = this.mMovie.duration()) == 0) {
            dur = 1000;
        }
        this.mCurrentAnimationTime = (int)((now - this.mMovieStart) % (long)dur);
    }

    private void drawMovieFrame(Canvas canvas) {
        this.mMovie.setTime(this.mCurrentAnimationTime);
        canvas.save(1);
        canvas.scale(this.mScale, this.mScale);
        this.mMovie.draw(canvas, this.mLeft / this.mScale, this.mTop / this.mScale);
        canvas.restore();
    }

    @SuppressLint(value={"NewApi"})
    public void onScreenStateChanged(int screenState) {
        super.onScreenStateChanged(screenState);
        this.mVisible = screenState == 1;
        this.invalidateView();
    }

    @SuppressLint(value={"NewApi"})
    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        this.mVisible = visibility == 0;
        this.invalidateView();
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.mVisible = visibility == 0;
        this.invalidateView();
    }
}

