/*
 * Decompiled with CFR 0.152.
 */
package com.hss01248.dialog;

import android.app.Activity;
import android.os.Build;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.Stack;

public class ActivityStackManager {
    private static ActivityStackManager sInstance = new ActivityStackManager();
    private WeakReference<Activity> topAttachedActivityWeakRef;
    private static Stack<Activity> mActivityStack = new Stack();

    private ActivityStackManager() {
    }

    public static ActivityStackManager getInstance() {
        return sInstance;
    }

    public Activity getTopActivity() {
        Activity currentActivity = null;
        if (mActivityStack.size() > 0) {
            currentActivity = (Activity)mActivityStack.get(mActivityStack.size() - 1);
        }
        return currentActivity;
    }

    public Activity getTopActivity(Class activityExpected) {
        Activity activity = this.getTopActivity();
        if (activity != null && activity.getClass().equals(activityExpected)) {
            return activity;
        }
        return null;
    }

    public Activity getActivity(Class activityExpected) {
        if (mActivityStack == null) {
            return null;
        }
        for (Activity activity1 : mActivityStack) {
            if (!activity1.getClass().equals(activityExpected)) continue;
            return activity1;
        }
        return null;
    }

    public boolean finishActivityByIdx(int idxTop) {
        if (mActivityStack.isEmpty()) {
            return false;
        }
        int index = mActivityStack.size() - idxTop;
        Activity activity = (Activity)mActivityStack.remove(index);
        if (activity != null && !activity.isFinishing()) {
            activity.finish();
            return true;
        }
        return true;
    }

    public void setTopAttached(Activity activity) {
        this.topAttachedActivityWeakRef = new WeakReference<Activity>(activity);
    }

    public void removeTopAttached(Activity activity) {
        Activity activity1;
        if (activity == null) {
            return;
        }
        if (this.topAttachedActivityWeakRef != null && activity.equals(activity1 = (Activity)this.topAttachedActivityWeakRef.get())) {
            this.topAttachedActivityWeakRef = null;
        }
    }

    public Activity getTopAttached() {
        Activity activity;
        if (this.topAttachedActivityWeakRef != null && ActivityStackManager.isUsable(activity = (Activity)this.topAttachedActivityWeakRef.get())) {
            return activity;
        }
        return null;
    }

    public static boolean isUsable(Activity activity) {
        if (activity == null) {
            return false;
        }
        if (activity.isFinishing()) {
            return false;
        }
        return Build.VERSION.SDK_INT < 17 || !activity.isDestroyed();
    }

    public int size() {
        return mActivityStack.size();
    }

    public void addActivity(Activity activity) {
        if (mActivityStack == null) {
            mActivityStack = new Stack();
        }
        if (activity != null) {
            mActivityStack.add(activity);
            Log.e((String)"dialog", (String)("mActivityStack.size()--addActivity:" + activity.getClass().getSimpleName() + mActivityStack.size()));
        }
    }

    public void removeActivity(Activity activity) {
        mActivityStack.remove(activity);
        Log.e((String)"dialog", (String)("mActivityStack.size()--removeActivity:" + activity.getClass().getSimpleName() + mActivityStack.size()));
    }

    public boolean isActivityAlive(Class<?> cls) {
        if (mActivityStack == null) {
            return false;
        }
        for (Activity activity1 : mActivityStack) {
            if (!activity1.getClass().equals(cls)) continue;
            return true;
        }
        return false;
    }

    public void finishActivity(Activity activity) {
        if (mActivityStack == null) {
            return;
        }
        if (activity != null) {
            mActivityStack.remove(activity);
            activity.finish();
        }
    }

    public void finishActivity(Class<?> cls) {
        if (mActivityStack == null) {
            return;
        }
        for (Activity activity : mActivityStack) {
            if (!activity.getClass().equals(cls)) continue;
            this.finishActivity(activity);
        }
    }
}

