/*
 * Decompiled with CFR 0.152.
 */
package ozaydin.serkan.com.image_zoom_view;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Environment;
import android.util.Base64;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.UUID;
import ozaydin.serkan.com.image_zoom_view.SaveFileListener;

public class ImageProperties {
    public static String bitmapToBase64(Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)byteArrayOutputStream);
        byte[] byteArray = byteArrayOutputStream.toByteArray();
        return ImageProperties.resizeBase64Image(Base64.encodeToString((byte[])byteArray, (int)2));
    }

    public static String resizeBase64Image(String base64image) {
        byte[] encodeByte = Base64.decode((byte[])base64image.getBytes(), (int)2);
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPurgeable = true;
        Bitmap image = BitmapFactory.decodeByteArray((byte[])encodeByte, (int)0, (int)encodeByte.length, (BitmapFactory.Options)options);
        if (image.getHeight() <= 400 && image.getWidth() <= 400) {
            return base64image;
        }
        image = Bitmap.createScaledBitmap((Bitmap)image, (int)400, (int)400, (boolean)false);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        image.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
        byte[] b = baos.toByteArray();
        System.gc();
        return Base64.encodeToString((byte[])b, (int)2);
    }

    public static void saveImage(Bitmap bitmap, String folderName, String filename, Bitmap.CompressFormat compressFormat, SaveFileListener saveFileListener) {
        filename = filename + UUID.randomUUID();
        File file = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES).getAbsolutePath() + File.separator + folderName);
        if (!file.exists()) {
            file.mkdir();
        }
        file = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES).getAbsolutePath() + File.separator + folderName + File.separator + filename + ".jpg");
        try {
            FileOutputStream out = new FileOutputStream(file);
            bitmap.compress(compressFormat, 90, (OutputStream)out);
            out.flush();
            out.close();
            saveFileListener.onSuccess(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Log.e((String)"ImageViewZoom", (String)exception.getMessage());
            saveFileListener.onFail(exception);
        }
    }

    public static void saveImage(Bitmap bitmap, Bitmap.CompressFormat compressFormat, SaveFileListener saveFileListener) {
        String filename = UUID.randomUUID().toString();
        File file = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES).getAbsolutePath() + File.separator + "");
        if (!file.exists()) {
            file.mkdir();
        }
        file = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES).getAbsolutePath() + File.separator + "" + File.separator + filename + ".jpg");
        try {
            FileOutputStream out = new FileOutputStream(file);
            bitmap.compress(compressFormat, 90, (OutputStream)out);
            out.flush();
            out.close();
            saveFileListener.onSuccess(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Log.e((String)"ImageViewZoom", (String)exception.getMessage());
            saveFileListener.onFail(exception);
        }
    }
}

