/*
 * Decompiled with CFR 0.152.
 */
package com.hsicen.extension.widget;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatEditText;
import com.hsicen.extension.R;
import com.hsicen.extension.extensions.DpSpKt;
import com.hsicen.extension.widget.MaterialEditText;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 62\u00020\u0001:\u00016B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0014J\b\u00105\u001a\u000202H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000e\u0010\u000fR#\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u0017@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR$\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\u001d@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R$\u0010#\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010\u000fR\u001b\u0010'\u001a\u00020(8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010\u0016\u001a\u0004\b)\u0010*R$\u0010,\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100\u00a8\u00067"}, d2={"Lcom/hsicen/extension/widget/MaterialEditText;", "Landroidx/appcompat/widget/AppCompatEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "backPadding", "Landroid/graphics/Rect;", "isLabelShow", "", "value", "", "labelFraction", "setLabelFraction", "(F)V", "mAnimator", "Landroid/animation/ObjectAnimator;", "kotlin.jvm.PlatformType", "getMAnimator", "()Landroid/animation/ObjectAnimator;", "mAnimator$delegate", "Lkotlin/Lazy;", "", "mLabel", "getMLabel", "()Ljava/lang/String;", "setMLabel", "(Ljava/lang/String;)V", "", "mLabelColor", "getMLabelColor", "()I", "setMLabelColor", "(I)V", "mLabelSize", "getMLabelSize", "()F", "setMLabelSize", "mPaint", "Landroid/graphics/Paint;", "getMPaint", "()Landroid/graphics/Paint;", "mPaint$delegate", "useLabel", "getUseLabel", "()Z", "setUseLabel", "(Z)V", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "onLabelChanged", "Companion", "extensions_release"})
public final class MaterialEditText
extends AppCompatEditText {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy mPaint$delegate;
    private boolean useLabel;
    @NotNull
    private String mLabel;
    private float mLabelSize;
    private int mLabelColor;
    @NotNull
    private Rect backPadding;
    private boolean isLabelShow;
    private float labelFraction;
    @NotNull
    private final Lazy mAnimator$delegate;
    private static final int TEXT_MARGIN = DpSpKt.getDp2px(8);
    private static final float VERTICAL_OFFSET = DpSpKt.getDp2px(22.0f);
    private static final float HORIZONTAL_OFFSET = DpSpKt.getDp2px(5.0f);
    private static final float HORIZONTAL_OFFSET_EXTRA = DpSpKt.getDp2px(17.0f);

    @JvmOverloads
    public MaterialEditText(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.mPaint$delegate = LazyKt.lazy((Function0)mPaint.2.INSTANCE);
        this.mLabel = "";
        this.mLabelColor = -16777216;
        this.backPadding = new Rect();
        this.mAnimator$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ObjectAnimator>(this){
            final /* synthetic */ MaterialEditText this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final ObjectAnimator invoke() {
                float[] fArray = new float[]{0.0f, 1.0f};
                return ObjectAnimator.ofFloat((Object)((Object)this.this$0), (String)"labelFraction", (float[])fArray);
            }
        }));
        Object object = context.obtainStyledAttributes(attrs, R.styleable.MaterialEditText);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.obtainStyledAttributes(attrs, R.styleable.MaterialEditText)");
        TypedArray typedArray = object;
        this.setUseLabel(typedArray.getBoolean(R.styleable.MaterialEditText_useLabel, this.useLabel));
        object = typedArray.getString(R.styleable.MaterialEditText_label);
        this.setMLabel(object == null ? ((Object)this.getHint()).toString() : object);
        this.setMLabelSize(typedArray.getDimension(R.styleable.MaterialEditText_labelSize, DpSpKt.getSp2px(12.0f)));
        this.setMLabelColor(typedArray.getColor(R.styleable.MaterialEditText_labelColor, this.mLabelColor));
        typedArray.recycle();
        this.onLabelChanged();
        this.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(@Nullable CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(@Nullable Editable s) {
            }

            public void onTextChanged(@Nullable CharSequence s, int start, int before, int count) {
                if (this.getUseLabel()) {
                    if (isLabelShow && TextUtils.isEmpty((CharSequence)s)) {
                        isLabelShow = false;
                        this.getMAnimator().reverse();
                    } else if (!isLabelShow && !TextUtils.isEmpty((CharSequence)s)) {
                        isLabelShow = true;
                        this.getMAnimator().start();
                    }
                }
            }
        });
    }

    public /* synthetic */ MaterialEditText(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    private final Paint getMPaint() {
        Lazy lazy = this.mPaint$delegate;
        boolean bl = false;
        return (Paint)lazy.getValue();
    }

    public final boolean getUseLabel() {
        return this.useLabel;
    }

    public final void setUseLabel(boolean value) {
        if (this.useLabel != value) {
            this.useLabel = value;
            this.onLabelChanged();
        }
    }

    @NotNull
    public final String getMLabel() {
        return this.mLabel;
    }

    public final void setMLabel(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.mLabel = value;
        this.invalidate();
    }

    public final float getMLabelSize() {
        return this.mLabelSize;
    }

    public final void setMLabelSize(float value) {
        this.mLabelSize = value;
        this.invalidate();
    }

    public final int getMLabelColor() {
        return this.mLabelColor;
    }

    public final void setMLabelColor(int value) {
        this.mLabelColor = value;
        this.invalidate();
    }

    private final void setLabelFraction(float value) {
        this.labelFraction = value;
        this.invalidate();
    }

    private final ObjectAnimator getMAnimator() {
        Lazy lazy = this.mAnimator$delegate;
        boolean bl = false;
        return (ObjectAnimator)lazy.getValue();
    }

    private final void onLabelChanged() {
        this.getBackground().getPadding(this.backPadding);
        if (this.useLabel) {
            this.setPadding(this.backPadding.left, (int)((float)this.backPadding.top + this.mLabelSize + (float)TEXT_MARGIN), this.backPadding.right, this.backPadding.bottom);
        } else {
            this.setPadding(this.backPadding.left, this.backPadding.top, this.backPadding.right, this.backPadding.bottom);
        }
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        this.getMPaint().setColor(this.mLabelColor);
        this.getMPaint().setTextSize(this.mLabelSize);
        this.getMPaint().setAlpha((int)((float)255 * this.labelFraction));
        float extraOffset = HORIZONTAL_OFFSET_EXTRA * (1.0f - this.labelFraction);
        int showLength = (int)((float)this.mLabel.length() * this.labelFraction);
        String string = this.mLabel;
        int n = 0;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, showLength);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        canvas.drawText(string3, HORIZONTAL_OFFSET, VERTICAL_OFFSET + extraOffset, this.getMPaint());
    }

    @JvmOverloads
    public MaterialEditText(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 2, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/hsicen/extension/widget/MaterialEditText$Companion;", "", "()V", "HORIZONTAL_OFFSET", "", "HORIZONTAL_OFFSET_EXTRA", "TEXT_MARGIN", "", "VERTICAL_OFFSET", "extensions_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

