/*
 * Decompiled with CFR 0.152.
 */
package com.hsicen.extension.utils;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ \u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u001e\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/hsicen/extension/utils/ViewGroupUtils;", "", "()V", "sMatrix", "Ljava/lang/ThreadLocal;", "Landroid/graphics/Matrix;", "sRectF", "Landroid/graphics/RectF;", "getDescendantRect", "", "parent", "Landroid/view/ViewGroup;", "descendant", "Landroid/view/View;", "out", "Landroid/graphics/Rect;", "offsetDescendantMatrix", "target", "Landroid/view/ViewParent;", "view", "m", "offsetDescendantRect", "rect", "extensions_release"})
public final class ViewGroupUtils {
    @NotNull
    public static final ViewGroupUtils INSTANCE = new ViewGroupUtils();
    @NotNull
    private static final ThreadLocal<Matrix> sMatrix = new ThreadLocal();
    @NotNull
    private static final ThreadLocal<RectF> sRectF = new ThreadLocal();

    private ViewGroupUtils() {
    }

    public final void offsetDescendantRect(@NotNull ViewGroup parent, @NotNull View descendant, @NotNull Rect rect) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)descendant, (String)"descendant");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Matrix m = sMatrix.get();
        if (m == null) {
            m = new Matrix();
            sMatrix.set(m);
        } else {
            m.reset();
        }
        Matrix matrix = m;
        this.offsetDescendantMatrix((ViewParent)parent, descendant, matrix);
        RectF rectF = sRectF.get();
        if (rectF == null) {
            rectF = new RectF();
            sRectF.set(rectF);
        }
        rectF.set(rect);
        m.mapRect(rectF);
        rect.set((int)(rectF.left + 0.5f), (int)(rectF.top + 0.5f), (int)(rectF.right + 0.5f), (int)(rectF.bottom + 0.5f));
    }

    public final void getDescendantRect(@NotNull ViewGroup parent, @NotNull View descendant, @NotNull Rect out) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)descendant, (String)"descendant");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.set(0, 0, descendant.getWidth(), descendant.getHeight());
        this.offsetDescendantRect(parent, descendant, out);
    }

    private final void offsetDescendantMatrix(ViewParent target, View view, Matrix m) {
        ViewParent parent = view.getParent();
        if (parent instanceof View && parent != target) {
            View vp = (View)parent;
            this.offsetDescendantMatrix(target, vp, m);
            m.preTranslate(-((float)vp.getScrollX()), -((float)vp.getScrollY()));
        }
        m.preTranslate((float)view.getLeft(), (float)view.getTop());
        if (!view.getMatrix().isIdentity()) {
            m.preConcat(view.getMatrix());
        }
    }
}

