/*
 * Decompiled with CFR 0.152.
 */
package com.hsicen.extension.utils;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Process;
import android.text.TextUtils;
import androidx.core.content.ContextCompat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tR\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/hsicen/extension/utils/ProcessUtils;", "", "()V", "currentProcessNameByFile", "", "getCurrentProcessNameByFile", "()Ljava/lang/String;", "getCurrentProcessName", "context", "Landroid/content/Context;", "getCurrentProcessNameByAms", "getCurrentProcessNameByReflect", "isMainProcess", "", "extensions_release"})
public final class ProcessUtils {
    @NotNull
    public static final ProcessUtils INSTANCE = new ProcessUtils();

    private ProcessUtils() {
    }

    public final boolean isMainProcess(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Intrinsics.areEqual((Object)context.getPackageName(), (Object)this.getCurrentProcessName(context));
    }

    @NotNull
    public final String getCurrentProcessName(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Context appContext = context.getApplicationContext();
        String name = this.getCurrentProcessNameByFile();
        if (!TextUtils.isEmpty((CharSequence)name)) {
            return name;
        }
        Intrinsics.checkNotNullExpressionValue((Object)appContext, (String)"appContext");
        name = this.getCurrentProcessNameByAms(appContext);
        if (!TextUtils.isEmpty((CharSequence)name)) {
            return name;
        }
        name = this.getCurrentProcessNameByReflect(context);
        return name;
    }

    /*
     * WARNING - void declaration
     */
    private final String getCurrentProcessNameByFile() {
        String string;
        try {
            void var3_14;
            File file = new File("/proc/" + Process.myPid() + "/cmdline");
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = bufferedReader.readLine();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"bufferedReader.readLine()");
            String $this$trim$iv = string2;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String processName = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            bufferedReader.close();
            string = var3_14;
        }
        catch (Exception e) {
            e.printStackTrace();
            string = "";
        }
        return string;
    }

    private final String getCurrentProcessNameByAms(Context context) {
        try {
            ActivityManager activityManager = (ActivityManager)ContextCompat.getSystemService((Context)context, ActivityManager.class);
            if (activityManager == null) {
                return "";
            }
            ActivityManager activityManager2 = activityManager;
            ActivityManager am = activityManager2;
            List info = am.getRunningAppProcesses();
            if (info == null || info.size() == 0) {
                return "";
            }
            int pid = Process.myPid();
            for (ActivityManager.RunningAppProcessInfo aInfo : info) {
                if (aInfo.pid != pid || aInfo.processName == null) continue;
                String string = aInfo.processName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"aInfo.processName");
                return string;
            }
        }
        catch (Exception e) {
            return "";
        }
        return "";
    }

    private final String getCurrentProcessNameByReflect(Context context) {
        String processName = "";
        try {
            Context context2 = context.getApplicationContext();
            if (context2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.Application");
            }
            Application app = (Application)context2;
            Field loadedApkField = app.getClass().getField("mLoadedApk");
            loadedApkField.setAccessible(true);
            Object loadedApk = loadedApkField.get(app);
            Field activityThreadField = loadedApk.getClass().getDeclaredField("mActivityThread");
            activityThreadField.setAccessible(true);
            Object activityThread = activityThreadField.get(loadedApk);
            Method getProcessName = activityThread.getClass().getDeclaredMethod("getProcessName", new Class[0]);
            Object object = getProcessName.invoke(activityThread, new Object[0]);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            processName = (String)object;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return processName;
    }
}

