/*
 * Decompiled with CFR 0.152.
 */
package com.hsicen.extension.span;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.AlignmentSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.CharacterStyle;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineHeightSpan;
import android.text.style.MaskFilterSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.ReplacementSpan;
import android.text.style.ScaleXSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import android.text.style.UpdateAppearance;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.core.content.ContextCompat;
import com.orhanobut.logger.Logger;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b1\u0018\u0000 n2\u00020\u0001:\u000bnopqrstuvwxB\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010G\u001a\u00020H2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010I\u001a\u00020H2\u0006\u0010=\u001a\u00020>J\u0018\u0010J\u001a\u00020H2\u0006\u0010K\u001a\u00020\u001d2\b\b\u0002\u0010G\u001a\u00020\u0006J\u0018\u0010J\u001a\u00020H2\u0006\u0010L\u001a\u00020\u001f2\b\b\u0002\u0010G\u001a\u00020\u0006J\u0018\u0010J\u001a\u00020H2\u0006\u0010M\u001a\u00020\"2\b\b\u0002\u0010G\u001a\u00020\u0006J\u001a\u0010J\u001a\u00020H2\b\b\u0001\u0010N\u001a\u00020\u00062\b\b\u0002\u0010G\u001a\u00020\u0006J\u0006\u0010O\u001a\u00020HJ\u000e\u0010O\u001a\u00020H2\u0006\u0010=\u001a\u00020>J\u001a\u0010P\u001a\u00020H2\b\b\u0001\u0010Q\u001a\u00020\u00062\b\b\u0003\u0010R\u001a\u00020\u0006J\u0010\u0010S\u001a\u00020H2\u0006\u0010?\u001a\u00020\u0006H\u0002J\b\u0010T\u001a\u00020HH\u0002J\u0010\u0010\n\u001a\u00020H2\b\b\u0001\u0010R\u001a\u00020\u0006J\u0018\u0010U\u001a\u00020H2\b\b\u0001\u0010V\u001a\u00020\f2\u0006\u0010;\u001a\u00020<J\u0006\u0010W\u001a\u00020HJ\u0006\u0010X\u001a\u00020HJ$\u0010Y\u001a\u00020H2\b\b\u0003\u0010R\u001a\u00020\u00062\b\b\u0003\u0010V\u001a\u00020\u00062\b\b\u0001\u0010Z\u001a\u00020\u0006J\u000e\u0010\u0012\u001a\u00020H2\u0006\u0010\u0012\u001a\u00020\u0013J\r\u0010[\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\\J\u000e\u0010\u0015\u001a\u00020H2\u0006\u0010\u0015\u001a\u00020\u0006J\u000e\u0010\u0016\u001a\u00020H2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010]\u001a\u00020H2\u0006\u0010+\u001a\u00020\fJ\u001a\u0010\u0018\u001a\u00020H2\b\b\u0001\u0010Q\u001a\u00020\u00062\b\b\u0002\u0010^\u001a\u00020\u001aJ\u000e\u0010_\u001a\u00020H2\u0006\u0010+\u001a\u00020\fJ\u0010\u0010\u001b\u001a\u00020H2\b\b\u0001\u0010R\u001a\u00020\u0006J\u001a\u0010`\u001a\u00020H2\b\b\u0001\u0010\u0014\u001a\u00020\u00062\b\b\u0001\u0010.\u001a\u00020\u0006J\u001a\u0010*\u001a\u00020H2\b\b\u0001\u0010*\u001a\u00020\u00062\b\b\u0002\u0010G\u001a\u00020\u0006J$\u0010,\u001a\u00020H2\b\b\u0001\u0010R\u001a\u00020\u00062\b\b\u0003\u0010:\u001a\u00020\u00062\b\b\u0003\u0010Z\u001a\u00020\u0006J\b\u0010a\u001a\u00020HH\u0002J\u000e\u0010/\u001a\u00020H2\u0006\u0010/\u001a\u000200J(\u0010b\u001a\u00020H2\b\b\u0001\u0010V\u001a\u00020\f2\u0006\u0010c\u001a\u00020\f2\u0006\u0010d\u001a\u00020\f2\u0006\u00101\u001a\u00020\u0006J\u001f\u00107\u001a\u00020H2\u0012\u0010e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000108\"\u00020\u0001\u00a2\u0006\u0002\u0010fJ\u0006\u0010g\u001a\u00020HJ\u0006\u0010h\u001a\u00020HJ\u0006\u0010i\u001a\u00020HJ\u000e\u0010C\u001a\u00020H2\u0006\u0010C\u001a\u00020DJ\u0006\u0010j\u001a\u00020HJ\b\u0010k\u001a\u00020HH\u0002J\b\u0010l\u001a\u00020HH\u0002J\b\u0010m\u001a\u00020HH\u0002J\u000e\u0010E\u001a\u00020H2\u0006\u0010E\u001a\u00020\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00107\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u000108X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u00109R\u000e\u0010:\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010;\u001a\u0004\u0018\u00010<X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010C\u001a\u0004\u0018\u00010DX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010E\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006y"}, d2={"Lcom/hsicen/extension/span/Span;", "", "ctx", "Landroid/content/Context;", "(Landroid/content/Context;)V", "alignImage", "", "alignLine", "alignment", "Landroid/text/Layout$Alignment;", "backgroundColor", "blurRadius", "", "builder", "Landroid/text/SpannableStringBuilder;", "bulletColor", "bulletGapWidth", "bulletRadius", "clickSpan", "Landroid/text/style/ClickableSpan;", "first", "flag", "fontFamily", "", "fontSize", "fontSizeIsDp", "", "foregroundColor", "imageBitmap", "Landroid/graphics/Bitmap;", "imageDrawable", "Landroid/graphics/drawable/Drawable;", "imageResourceId", "imageUri", "Landroid/net/Uri;", "isBold", "isBoldItalic", "isItalic", "isStrikethrough", "isSubscript", "isSuperscript", "isUnderline", "lineHeight", "proportion", "quoteColor", "quoteGapWidth", "rest", "shader", "Landroid/graphics/Shader;", "shadowColor", "shadowDx", "shadowDy", "shadowRadius", "spaceColor", "spaceSize", "spans", "", "[Ljava/lang/Object;", "stripeWidth", "style", "Landroid/graphics/BlurMaskFilter$Blur;", "text", "", "type", "typeCharSequence", "typeImage", "typeSpace", "typeface", "Landroid/graphics/Typeface;", "url", "xProportion", "align", "", "append", "appendImage", "bitmap", "drawable", "uri", "resourceId", "appendLine", "appendSpace", "size", "color", "apply", "applyLast", "blur", "radius", "bold", "boldItalic", "bullet", "gapWidth", "create", "create$extensions_release", "fontProportion", "isSp", "fontXProportion", "leadingMargin", "reset", "shadow", "dx", "dy", "span", "([Ljava/lang/Object;)V", "strikethrough", "subscript", "superscript", "underline", "updateCharCharSequence", "updateImage", "updateSpace", "Companion", "Creator", "CustomBulletSpan", "CustomDynamicDrawableSpan", "CustomImageSpan", "CustomLineHeightSpan", "CustomQuoteSpan", "CustomTypefaceSpan", "ShaderSpan", "ShadowSpan", "SpaceSpan", "extensions_release"})
public final class Span {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context ctx;
    @NotNull
    private final SpannableStringBuilder builder;
    @NotNull
    private CharSequence text;
    private int flag;
    private int foregroundColor;
    private int backgroundColor;
    private int lineHeight;
    private int alignLine;
    private int quoteColor;
    private int stripeWidth;
    private int quoteGapWidth;
    private int first;
    private int rest;
    private int bulletColor;
    private int bulletRadius;
    private int bulletGapWidth;
    private int fontSize;
    private boolean fontSizeIsDp;
    private float proportion;
    private float xProportion;
    private boolean isStrikethrough;
    private boolean isUnderline;
    private boolean isSuperscript;
    private boolean isSubscript;
    private boolean isBold;
    private boolean isItalic;
    private boolean isBoldItalic;
    @Nullable
    private String fontFamily;
    @Nullable
    private Typeface typeface;
    @Nullable
    private Layout.Alignment alignment;
    @Nullable
    private ClickableSpan clickSpan;
    @Nullable
    private String url;
    private float blurRadius;
    @Nullable
    private BlurMaskFilter.Blur style;
    @Nullable
    private Shader shader;
    private float shadowRadius;
    private float shadowDx;
    private float shadowDy;
    private int shadowColor;
    @Nullable
    private Object[] spans;
    @Nullable
    private Bitmap imageBitmap;
    @Nullable
    private Drawable imageDrawable;
    @Nullable
    private Uri imageUri;
    private int imageResourceId;
    private int alignImage;
    private int spaceSize;
    private int spaceColor;
    private int type;
    private int typeCharSequence;
    private int typeImage;
    private int typeSpace;
    public static final int ALIGN_BOTTOM = 0;
    public static final int ALIGN_BASELINE = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_TOP = 3;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int COLOR_DEFAULT = -16777217;

    public Span(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.ctx = ctx;
        this.builder = new SpannableStringBuilder();
        this.text = "";
        this.flag = 33;
        this.foregroundColor = -16777217;
        this.backgroundColor = -16777217;
        this.lineHeight = -1;
        this.quoteColor = -16777217;
        this.first = -1;
        this.bulletColor = -16777217;
        this.fontSize = -1;
        this.proportion = -1.0f;
        this.xProportion = -1.0f;
        this.blurRadius = -1.0f;
        this.shadowRadius = -1.0f;
        this.shadowColor = -16777217;
        this.imageResourceId = -1;
        this.spaceSize = -1;
        this.spaceColor = -16777217;
        this.typeImage = 1;
        this.typeSpace = 2;
    }

    private final void reset() {
        this.flag = 33;
        this.foregroundColor = -16777217;
        this.backgroundColor = -16777217;
        this.lineHeight = -1;
        this.quoteColor = -16777217;
        this.first = -1;
        this.bulletColor = -16777217;
        this.fontSize = -1;
        this.proportion = -1.0f;
        this.xProportion = -1.0f;
        this.isStrikethrough = false;
        this.isUnderline = false;
        this.isSuperscript = false;
        this.isSubscript = false;
        this.isBold = false;
        this.isItalic = false;
        this.isBoldItalic = false;
        this.fontFamily = null;
        this.typeface = null;
        this.alignment = null;
        this.clickSpan = null;
        this.url = null;
        this.blurRadius = -1.0f;
        this.shader = null;
        this.shadowRadius = -1.0f;
        this.spans = null;
        this.imageBitmap = null;
        this.imageDrawable = null;
        this.imageUri = null;
        this.imageResourceId = -1;
        this.spaceSize = -1;
    }

    public final void flag(int flag) {
        this.flag = flag;
    }

    public final void foregroundColor(@ColorInt int color) {
        this.foregroundColor = color;
    }

    public final void backgroundColor(@ColorInt int color) {
        this.backgroundColor = color;
    }

    public final void lineHeight(@IntRange(from=0L) int lineHeight, int align) {
        this.lineHeight = lineHeight;
        this.alignLine = align;
    }

    public static /* synthetic */ void lineHeight$default(Span span, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 2;
        }
        span.lineHeight(n, n2);
    }

    public final void quoteColor(@ColorInt int color, @IntRange(from=1L) int stripeWidth, @IntRange(from=0L) int gapWidth) {
        this.quoteColor = color;
        this.stripeWidth = stripeWidth;
        this.quoteGapWidth = gapWidth;
    }

    public static /* synthetic */ void quoteColor$default(Span span, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n2 = 2;
        }
        if ((n4 & 4) != 0) {
            n3 = 2;
        }
        span.quoteColor(n, n2, n3);
    }

    public final void leadingMargin(@IntRange(from=0L) int first, @IntRange(from=0L) int rest) {
        this.first = first;
        this.rest = rest;
    }

    public final void bullet(@ColorInt int color, @IntRange(from=0L) int radius, @IntRange(from=0L) int gapWidth) {
        this.bulletColor = color;
        this.bulletRadius = radius;
        this.bulletGapWidth = gapWidth;
    }

    public static /* synthetic */ void bullet$default(Span span, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = 0;
        }
        if ((n4 & 2) != 0) {
            n2 = 3;
        }
        span.bullet(n, n2, n3);
    }

    public final void fontSize(@IntRange(from=0L) int size, boolean isSp) {
        this.fontSize = size;
        this.fontSizeIsDp = isSp;
    }

    public static /* synthetic */ void fontSize$default(Span span, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        span.fontSize(n, bl);
    }

    public final void fontProportion(float proportion) {
        this.proportion = proportion;
    }

    public final void fontXProportion(float proportion) {
        this.xProportion = proportion;
    }

    public final void strikethrough() {
        this.isStrikethrough = true;
    }

    public final void underline() {
        this.isUnderline = true;
    }

    public final void superscript() {
        this.isSuperscript = true;
    }

    public final void subscript() {
        this.isSubscript = true;
    }

    public final void bold() {
        this.isBold = true;
    }

    public final void boldItalic() {
        this.isBoldItalic = true;
    }

    public final void fontFamily(@NotNull String fontFamily) {
        Intrinsics.checkNotNullParameter((Object)fontFamily, (String)"fontFamily");
        this.fontFamily = fontFamily;
    }

    public final void typeface(@NotNull Typeface typeface) {
        Intrinsics.checkNotNullParameter((Object)typeface, (String)"typeface");
        this.typeface = typeface;
    }

    public final void align(@NotNull Layout.Alignment alignment) {
        Intrinsics.checkNotNullParameter((Object)alignment, (String)"alignment");
        this.alignment = alignment;
    }

    public final void clickSpan(@NotNull ClickableSpan clickSpan) {
        Intrinsics.checkNotNullParameter((Object)clickSpan, (String)"clickSpan");
        this.clickSpan = clickSpan;
    }

    public final void url(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url = url;
    }

    public final void blur(@FloatRange(from=0.0, fromInclusive=false) float radius, @NotNull BlurMaskFilter.Blur style) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        this.blurRadius = radius;
        this.style = style;
    }

    public final void shader(@NotNull Shader shader) {
        Intrinsics.checkNotNullParameter((Object)shader, (String)"shader");
        this.shader = shader;
    }

    public final void shadow(@FloatRange(from=0.0, fromInclusive=false) float radius, float dx, float dy, int shadowColor) {
        this.shadowRadius = radius;
        this.shadowDx = dx;
        this.shadowDy = dy;
        this.shadowColor = shadowColor;
    }

    public final void spans(Object ... span) {
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        Object[] objectArray = span;
        boolean bl = false;
        Object[] objectArray2 = objectArray;
        boolean bl2 = false;
        if (!(objectArray2.length == 0)) {
            this.spans = span;
        }
    }

    public final void append(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.apply(this.typeCharSequence);
        this.text = text;
    }

    public final void appendLine() {
        this.apply(this.typeCharSequence);
        String string = LINE_SEPARATOR;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"LINE_SEPARATOR");
        this.text = string;
    }

    public final void appendLine(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.apply(this.typeCharSequence);
        this.text = text + LINE_SEPARATOR;
    }

    public final void appendImage(@NotNull Bitmap bitmap, int align) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        this.apply(this.typeImage);
        this.imageBitmap = bitmap;
        this.alignImage = align;
    }

    public static /* synthetic */ void appendImage$default(Span span, Bitmap bitmap, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 2;
        }
        span.appendImage(bitmap, n);
    }

    public final void appendImage(@NotNull Drawable drawable, int align) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        this.apply(this.typeImage);
        this.imageDrawable = drawable;
        this.alignImage = align;
    }

    public static /* synthetic */ void appendImage$default(Span span, Drawable drawable, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 2;
        }
        span.appendImage(drawable, n);
    }

    public final void appendImage(@NotNull Uri uri, int align) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.apply(this.typeImage);
        this.imageUri = uri;
        this.alignImage = align;
    }

    public static /* synthetic */ void appendImage$default(Span span, Uri uri, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 2;
        }
        span.appendImage(uri, n);
    }

    public final void appendImage(@DrawableRes int resourceId, int align) {
        String string = Character.toString('\u0000');
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(0.toChar())");
        this.append(string);
        this.apply(this.typeImage);
        this.imageResourceId = resourceId;
        this.alignImage = align;
    }

    public static /* synthetic */ void appendImage$default(Span span, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 2;
        }
        span.appendImage(n, n2);
    }

    public final void appendSpace(@IntRange(from=0L) int size, @ColorInt int color) {
        this.apply(this.typeSpace);
        this.spaceSize = size;
        this.spaceColor = color;
    }

    public static /* synthetic */ void appendSpace$default(Span span, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        span.appendSpace(n, n2);
    }

    private final void apply(int type) {
        this.applyLast();
        this.type = type;
    }

    private final void applyLast() {
        int n = this.type;
        if (n == this.typeCharSequence) {
            this.updateCharCharSequence();
        } else if (n == this.typeImage) {
            this.updateImage();
        } else if (n == this.typeSpace) {
            this.updateSpace();
        }
        this.reset();
    }

    private final void updateCharCharSequence() {
        Object[] it;
        boolean bl;
        boolean bl2;
        Object[] objectArray;
        Object[] objectArray2;
        CharSequence charSequence = this.text;
        boolean bl3 = false;
        if (charSequence.length() == 0) {
            return;
        }
        int start = this.builder.length();
        this.builder.append(this.text);
        int end = this.builder.length();
        if (this.foregroundColor != -16777217) {
            this.builder.setSpan((Object)new ForegroundColorSpan(this.foregroundColor), start, end, this.flag);
        }
        if (this.backgroundColor != -16777217) {
            this.builder.setSpan((Object)new BackgroundColorSpan(this.backgroundColor), start, end, this.flag);
        }
        if (this.first != -1) {
            this.builder.setSpan((Object)new LeadingMarginSpan.Standard(this.first, this.rest), start, end, this.flag);
        }
        if (this.quoteColor != -16777217) {
            this.builder.setSpan((Object)new CustomQuoteSpan(this.quoteColor, this.stripeWidth, this.quoteGapWidth), start, end, this.flag);
        }
        if (this.bulletColor != -16777217) {
            this.builder.setSpan((Object)new CustomBulletSpan(this.bulletColor, this.bulletRadius, this.bulletGapWidth), start, end, this.flag);
        }
        if (this.fontSize != -1) {
            this.builder.setSpan((Object)new AbsoluteSizeSpan(this.fontSize, this.fontSizeIsDp), start, end, this.flag);
        }
        if (!(this.proportion == -1.0f)) {
            this.builder.setSpan((Object)new RelativeSizeSpan(this.proportion), start, end, this.flag);
        }
        if (!(this.xProportion == -1.0f)) {
            this.builder.setSpan((Object)new ScaleXSpan(this.xProportion), start, end, this.flag);
        }
        if (this.lineHeight != -1) {
            this.builder.setSpan((Object)new CustomLineHeightSpan(this.lineHeight, this.alignLine), start, end, this.flag);
        }
        if (this.isStrikethrough) {
            this.builder.setSpan((Object)new StrikethroughSpan(), start, end, this.flag);
        }
        if (this.isUnderline) {
            this.builder.setSpan((Object)new UnderlineSpan(), start, end, this.flag);
        }
        if (this.isSuperscript) {
            this.builder.setSpan((Object)new SuperscriptSpan(), start, end, this.flag);
        }
        if (this.isSubscript) {
            this.builder.setSpan((Object)new SubscriptSpan(), start, end, this.flag);
        }
        if (this.isBold) {
            this.builder.setSpan((Object)new StyleSpan(1), start, end, this.flag);
        }
        if (this.isItalic) {
            this.builder.setSpan((Object)new StyleSpan(2), start, end, this.flag);
        }
        if (this.isBoldItalic) {
            this.builder.setSpan((Object)new StyleSpan(3), start, end, this.flag);
        }
        if ((objectArray2 = this.fontFamily) != null) {
            objectArray = objectArray2;
            bl2 = false;
            bl = false;
            it = objectArray;
            boolean bl4 = false;
            this.builder.setSpan((Object)new TypefaceSpan((String)it), start, end, this.flag);
        }
        objectArray2 = this.typeface;
        if (objectArray2 != null) {
            objectArray = objectArray2;
            bl2 = false;
            bl = false;
            it = objectArray;
            boolean bl5 = false;
            this.builder.setSpan((Object)new CustomTypefaceSpan((Typeface)it), start, end, this.flag);
        }
        objectArray2 = this.alignment;
        if (objectArray2 != null) {
            objectArray = objectArray2;
            bl2 = false;
            bl = false;
            it = objectArray;
            boolean bl6 = false;
            this.builder.setSpan((Object)new AlignmentSpan.Standard((Layout.Alignment)it), start, end, this.flag);
        }
        objectArray2 = this.clickSpan;
        if (objectArray2 != null) {
            objectArray = objectArray2;
            bl2 = false;
            bl = false;
            it = objectArray;
            boolean bl7 = false;
            this.builder.setSpan((Object)it, start, end, this.flag);
        }
        objectArray2 = this.url;
        if (objectArray2 != null) {
            objectArray = objectArray2;
            bl2 = false;
            bl = false;
            it = objectArray;
            boolean bl8 = false;
            this.builder.setSpan((Object)new URLSpan((String)it), start, end, this.flag);
        }
        if (!(this.blurRadius == -1.0f)) {
            this.builder.setSpan((Object)new MaskFilterSpan((MaskFilter)new BlurMaskFilter(this.blurRadius, this.style)), start, end, this.flag);
        }
        if ((objectArray2 = this.shader) != null) {
            objectArray = objectArray2;
            bl2 = false;
            bl = false;
            it = objectArray;
            boolean bl9 = false;
            this.builder.setSpan((Object)new ShaderSpan((Shader)it), start, end, this.flag);
        }
        if (!(this.shadowRadius == -1.0f)) {
            this.builder.setSpan((Object)new ShadowSpan(this.shadowRadius, this.shadowDx, this.shadowDy, this.shadowColor), start, end, this.flag);
        }
        if ((objectArray2 = this.spans) != null) {
            objectArray = objectArray2;
            bl2 = false;
            bl = false;
            it = objectArray;
            boolean bl10 = false;
            Object[] $this$forEach$iv = it;
            boolean $i$f$forEach = false;
            Object[] objectArray3 = $this$forEach$iv;
            int n = objectArray3.length;
            for (int j = 0; j < n; ++j) {
                Object element$iv;
                Object sp = element$iv = objectArray3[j];
                boolean bl11 = false;
                this.builder.setSpan(sp, start, end, this.flag);
            }
        }
    }

    private final void updateImage() {
        int start = this.builder.length();
        this.builder.append((CharSequence)"<img>");
        int end = start + 5;
        if (this.imageBitmap != null) {
            Bitmap bitmap = this.imageBitmap;
            Intrinsics.checkNotNull((Object)bitmap);
            this.builder.setSpan((Object)new CustomImageSpan(bitmap, this.alignImage), start, end, this.flag);
        } else if (this.imageDrawable != null) {
            Drawable drawable = this.imageDrawable;
            Intrinsics.checkNotNull((Object)drawable);
            this.builder.setSpan((Object)new CustomImageSpan(drawable, this.alignImage), start, end, this.flag);
        } else if (this.imageUri != null) {
            Uri uri = this.imageUri;
            Intrinsics.checkNotNull((Object)uri);
            this.builder.setSpan((Object)new CustomImageSpan(uri, this.alignImage), start, end, this.flag);
        } else if (this.imageResourceId != -1) {
            this.builder.setSpan((Object)new CustomImageSpan(this.imageResourceId, this.alignImage), start, end, this.flag);
        }
    }

    private final void updateSpace() {
        int start = this.builder.length();
        this.builder.append((CharSequence)"< >");
        int end = start + 3;
        this.builder.setSpan((Object)new SpaceSpan(this.spaceSize, this.spaceColor), start, end, this.flag);
    }

    @NotNull
    public final SpannableStringBuilder create$extensions_release() {
        this.applyLast();
        return this.builder;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J<\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/hsicen/extension/span/Span$CustomLineHeightSpan;", "Landroid/text/style/CharacterStyle;", "Landroid/text/style/LineHeightSpan;", "height", "", "verticalAlignment", "(II)V", "chooseHeight", "", "text", "", "start", "end", "spanstartv", "lineHeight", "fm", "Landroid/graphics/Paint$FontMetricsInt;", "updateDrawState", "tp", "Landroid/text/TextPaint;", "extensions_release"})
    public static final class CustomLineHeightSpan
    extends CharacterStyle
    implements LineHeightSpan {
        private final int height;
        private final int verticalAlignment;

        public CustomLineHeightSpan(int height, int verticalAlignment) {
            this.height = height;
            this.verticalAlignment = verticalAlignment;
        }

        public void chooseHeight(@Nullable CharSequence text, int start, int end, int spanstartv, int lineHeight, @Nullable Paint.FontMetricsInt fm) {
            Paint.FontMetricsInt fontMetricsInt = fm;
            if (fontMetricsInt != null) {
                Paint.FontMetricsInt fontMetricsInt2;
                Paint.FontMetricsInt fontMetricsInt3 = fontMetricsInt;
                boolean bl = false;
                boolean bl2 = false;
                Paint.FontMetricsInt it = fontMetricsInt3;
                boolean bl3 = false;
                int need = this.height - (lineHeight + fm.descent - fm.ascent - spanstartv);
                int n = this.verticalAlignment;
                switch (n) {
                    case 3: {
                        fontMetricsInt2 = fm;
                        fontMetricsInt2.descent += need;
                        break;
                    }
                    case 2: {
                        fontMetricsInt2 = fm;
                        fontMetricsInt2.descent += need / 2;
                        fontMetricsInt2 = fm;
                        fontMetricsInt2.ascent -= need / 2;
                        break;
                    }
                    default: {
                        fontMetricsInt2 = fm;
                        fontMetricsInt2.ascent -= need;
                    }
                }
                need = this.height - (lineHeight + fm.bottom - fm.top - spanstartv);
                n = this.verticalAlignment;
                switch (n) {
                    case 3: {
                        fontMetricsInt2 = fm;
                        fontMetricsInt2.top += need;
                        break;
                    }
                    case 2: {
                        fontMetricsInt2 = fm;
                        fontMetricsInt2.bottom += need / 2;
                        fontMetricsInt2 = fm;
                        fontMetricsInt2.top -= need / 2;
                        break;
                    }
                    default: {
                        fontMetricsInt2 = fm;
                        fontMetricsInt2.top -= need;
                    }
                }
            }
        }

        public void updateDrawState(@Nullable TextPaint tp) {
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005JR\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J4\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/hsicen/extension/span/Span$SpaceSpan;", "Landroid/text/style/ReplacementSpan;", "width", "", "color", "(II)V", "draw", "", "canvas", "Landroid/graphics/Canvas;", "text", "", "start", "end", "x", "", "top", "y", "bottom", "paint", "Landroid/graphics/Paint;", "getSize", "fm", "Landroid/graphics/Paint$FontMetricsInt;", "extensions_release"})
    public static final class SpaceSpan
    extends ReplacementSpan {
        private final int width;
        private final int color;

        public SpaceSpan(int width, int color) {
            this.width = width;
            this.color = color;
        }

        public /* synthetic */ SpaceSpan(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            this(n, n2);
        }

        public int getSize(@NotNull Paint paint, @Nullable CharSequence text, int start, int end, @Nullable Paint.FontMetricsInt fm) {
            Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
            return this.width;
        }

        public void draw(@NotNull Canvas canvas, @Nullable CharSequence text, int start, int end, float x, int top, int y, int bottom, @NotNull Paint paint) {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
            Paint.Style style = paint.getStyle();
            int color = paint.getColor();
            paint.setStyle(Paint.Style.FILL);
            paint.setColor(this.color);
            canvas.drawRect(x, (float)top, x + (float)this.width, (float)bottom, paint);
            paint.setStyle(style);
            paint.setColor(color);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006Jh\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/hsicen/extension/span/Span$CustomQuoteSpan;", "Landroid/text/style/LeadingMarginSpan;", "color", "", "stripeWidth", "gapWidth", "(III)V", "drawLeadingMargin", "", "c", "Landroid/graphics/Canvas;", "p", "Landroid/graphics/Paint;", "x", "dir", "top", "baseline", "bottom", "text", "", "start", "end", "first", "", "layout", "Landroid/text/Layout;", "getLeadingMargin", "extensions_release"})
    public static final class CustomQuoteSpan
    implements LeadingMarginSpan {
        private final int color;
        private final int stripeWidth;
        private final int gapWidth;

        public CustomQuoteSpan(int color, int stripeWidth, int gapWidth) {
            this.color = color;
            this.stripeWidth = stripeWidth;
            this.gapWidth = gapWidth;
        }

        public int getLeadingMargin(boolean first) {
            return this.stripeWidth + this.gapWidth;
        }

        public void drawLeadingMargin(@NotNull Canvas c, @NotNull Paint p, int x, int dir, int top, int baseline, int bottom, @NotNull CharSequence text, int start, int end, boolean first, @NotNull Layout layout2) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
            Paint.Style style = p.getStyle();
            int color = p.getColor();
            p.setStyle(Paint.Style.FILL);
            p.setColor(this.color);
            c.drawRect((float)x, (float)top, (float)(x + dir * this.stripeWidth), (float)bottom, p);
            p.setStyle(style);
            p.setColor(color);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006Jh\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/hsicen/extension/span/Span$CustomBulletSpan;", "Landroid/text/style/LeadingMarginSpan;", "color", "", "radius", "gapWidth", "(III)V", "sBulletPath", "Landroid/graphics/Path;", "drawLeadingMargin", "", "c", "Landroid/graphics/Canvas;", "p", "Landroid/graphics/Paint;", "x", "dir", "top", "baseline", "bottom", "text", "", "start", "end", "first", "", "l", "Landroid/text/Layout;", "getLeadingMargin", "extensions_release"})
    public static final class CustomBulletSpan
    implements LeadingMarginSpan {
        private final int color;
        private final int radius;
        private final int gapWidth;
        @NotNull
        private Path sBulletPath;

        public CustomBulletSpan(int color, int radius, int gapWidth) {
            this.color = color;
            this.radius = radius;
            this.gapWidth = gapWidth;
            this.sBulletPath = new Path();
        }

        public int getLeadingMargin(boolean first) {
            return 2 * this.radius + this.gapWidth;
        }

        public void drawLeadingMargin(@NotNull Canvas c, @NotNull Paint p, int x, int dir, int top, int baseline, int bottom, @NotNull CharSequence text, int start, int end, boolean first, @NotNull Layout l) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)l, (String)"l");
            if (((Spanned)text).getSpanStart((Object)this) == start) {
                Paint.Style style = p.getStyle();
                int oldColor = p.getColor();
                p.setColor(this.color);
                p.setStyle(Paint.Style.FILL);
                if (c.isHardwareAccelerated()) {
                    if (this.sBulletPath.isEmpty()) {
                        this.sBulletPath.addCircle(0.0f, 0.0f, (float)this.radius, Path.Direction.CW);
                    }
                    c.save();
                    c.translate((float)(x + dir * this.radius), (float)(top + bottom) / 2.0f);
                    c.drawPath(this.sBulletPath, p);
                    c.restore();
                } else {
                    c.drawCircle((float)(x + dir * this.radius), (float)(top + bottom) / 2.0f, (float)this.radius, p);
                }
                p.setColor(oldColor);
                p.setStyle(style);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/hsicen/extension/span/Span$CustomTypefaceSpan;", "Landroid/text/style/TypefaceSpan;", "newType", "Landroid/graphics/Typeface;", "(Landroid/graphics/Typeface;)V", "apply", "", "paint", "Landroid/graphics/Paint;", "tf", "updateDrawState", "textPaint", "Landroid/text/TextPaint;", "updateMeasureState", "extensions_release"})
    public static final class CustomTypefaceSpan
    extends TypefaceSpan {
        @NotNull
        private final Typeface newType;

        public CustomTypefaceSpan(@NotNull Typeface newType) {
            Intrinsics.checkNotNullParameter((Object)newType, (String)"newType");
            super("");
            this.newType = newType;
        }

        public void updateDrawState(@NotNull TextPaint textPaint) {
            Intrinsics.checkNotNullParameter((Object)textPaint, (String)"textPaint");
            this.apply((Paint)textPaint, this.newType);
        }

        public void updateMeasureState(@NotNull TextPaint paint) {
            Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
            this.apply((Paint)paint, this.newType);
        }

        private final void apply(Paint paint, Typeface tf) {
            int n;
            Typeface old = paint.getTypeface();
            Typeface typeface = old;
            int oldStyle = typeface == null ? 0 : (n = typeface.getStyle());
            int fake = oldStyle & ~tf.getStyle();
            if ((fake & 1) != 0) {
                paint.setFakeBoldText(true);
            }
            if ((fake & 2) != 0) {
                paint.setTextSkewX(-0.25f);
            }
            paint.getShader();
            paint.setTypeface(tf);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fB\u0019\b\u0016\u0012\b\b\u0001\u0010\r\u001a\u00020\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0004\u0018\u00010\b8VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/hsicen/extension/span/Span$CustomImageSpan;", "Lcom/hsicen/extension/span/Span$CustomDynamicDrawableSpan;", "b", "Landroid/graphics/Bitmap;", "verticalAlignment", "", "(Lcom/hsicen/extension/span/Span;Landroid/graphics/Bitmap;I)V", "d", "Landroid/graphics/drawable/Drawable;", "(Lcom/hsicen/extension/span/Span;Landroid/graphics/drawable/Drawable;I)V", "uri", "Landroid/net/Uri;", "(Lcom/hsicen/extension/span/Span;Landroid/net/Uri;I)V", "resourceId", "(Lcom/hsicen/extension/span/Span;II)V", "contentUri", "drawable", "getDrawable", "()Landroid/graphics/drawable/Drawable;", "setDrawable", "(Landroid/graphics/drawable/Drawable;)V", "extensions_release"})
    public final class CustomImageSpan
    extends CustomDynamicDrawableSpan {
        @Nullable
        private Uri contentUri;
        private int resourceId;
        @Nullable
        private Drawable drawable;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public Drawable getDrawable() {
            Drawable drawable;
            Drawable drawable2 = this.drawable;
            if (drawable2 == null) {
                if (this.contentUri != null) {
                    try {
                        ContentResolver contentResolver = Span.this.ctx.getContentResolver();
                        Object object = this.contentUri;
                        Intrinsics.checkNotNull((Object)object);
                        object = contentResolver.openInputStream(object);
                        Span span = Span.this;
                        boolean bl = false;
                        boolean bl2 = false;
                        Throwable throwable = null;
                        try {
                            Unit unit;
                            InputStream it = (InputStream)object;
                            boolean bl3 = false;
                            Drawable drawable3 = this.drawable = (Drawable)new BitmapDrawable(span.ctx.getResources(), BitmapFactory.decodeStream((InputStream)it));
                            if (drawable3 == null) {
                                unit = null;
                            } else {
                                Drawable drawable4 = drawable3;
                                boolean bl4 = false;
                                boolean bl5 = false;
                                Drawable $this$_get_drawable__u24lambda_u2d1_u24lambda_u2d0 = drawable4;
                                boolean bl6 = false;
                                $this$_get_drawable__u24lambda_u2d1_u24lambda_u2d0.setBounds(0, 0, $this$_get_drawable__u24lambda_u2d1_u24lambda_u2d0.getIntrinsicWidth(), $this$_get_drawable__u24lambda_u2d1_u24lambda_u2d0.getIntrinsicHeight());
                                unit = Unit.INSTANCE;
                            }
                            it = unit;
                        }
                        catch (Throwable it) {
                            throwable = it;
                            throw it;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                        }
                    }
                    catch (Exception e) {
                        Object[] objectArray = new Object[]{e};
                        Logger.e((String)Intrinsics.stringPlus((String)"Failed to loaded content ", (Object)this.contentUri), (Object[])objectArray);
                    }
                    drawable = this.drawable;
                } else {
                    try {
                        Drawable e = this.drawable = ContextCompat.getDrawable((Context)Span.this.ctx, (int)this.resourceId);
                        if (e != null) {
                            Drawable drawable5 = e;
                            boolean bl = false;
                            boolean bl7 = false;
                            Drawable $this$_get_drawable__u24lambda_u2d2 = drawable5;
                            boolean bl8 = false;
                            $this$_get_drawable__u24lambda_u2d2.setBounds(0, 0, $this$_get_drawable__u24lambda_u2d2.getIntrinsicWidth(), $this$_get_drawable__u24lambda_u2d2.getIntrinsicHeight());
                        }
                    }
                    catch (Exception e) {
                        Object[] objectArray = new Object[]{e};
                        Logger.e((String)Intrinsics.stringPlus((String)"Unable to find resource: ", (Object)this.resourceId), (Object[])objectArray);
                    }
                    drawable = this.drawable;
                }
            } else {
                drawable = drawable2;
            }
            return drawable;
        }

        @Override
        public void setDrawable(@Nullable Drawable drawable) {
            this.drawable = drawable;
        }

        public CustomImageSpan(Bitmap b, int verticalAlignment) {
            Intrinsics.checkNotNullParameter((Object)Span.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            super(verticalAlignment);
            this.setDrawable((Drawable)new BitmapDrawable(Span.this.ctx.getResources(), b));
            Drawable drawable = this.getDrawable();
            if (drawable != null) {
                Drawable drawable2 = drawable;
                boolean bl = false;
                boolean bl2 = false;
                Drawable $this$_init__u24lambda_u2d3 = drawable2;
                boolean bl3 = false;
                $this$_init__u24lambda_u2d3.setBounds(0, 0, $this$_init__u24lambda_u2d3.getIntrinsicWidth(), $this$_init__u24lambda_u2d3.getIntrinsicHeight());
            }
        }

        public CustomImageSpan(Drawable d, int verticalAlignment) {
            Intrinsics.checkNotNullParameter((Object)Span.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
            super(verticalAlignment);
            this.setDrawable(d);
            Drawable drawable = this.getDrawable();
            if (drawable != null) {
                Drawable drawable2 = drawable;
                boolean bl = false;
                boolean bl2 = false;
                Drawable $this$_init__u24lambda_u2d4 = drawable2;
                boolean bl3 = false;
                $this$_init__u24lambda_u2d4.setBounds(0, 0, $this$_init__u24lambda_u2d4.getIntrinsicWidth(), $this$_init__u24lambda_u2d4.getIntrinsicHeight());
            }
        }

        public CustomImageSpan(Uri uri, int verticalAlignment) {
            Intrinsics.checkNotNullParameter((Object)Span.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            super(verticalAlignment);
            this.contentUri = uri;
        }

        public CustomImageSpan(int resourceId, int verticalAlignment) {
            Intrinsics.checkNotNullParameter((Object)Span.this, (String)"this$0");
            super(verticalAlignment);
            this.resourceId = resourceId;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JR\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 H\u0016J4\u0010!\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u0004\u0018\u00010\u0006X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\b\"\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0004\u00a8\u0006$"}, d2={"Lcom/hsicen/extension/span/Span$CustomDynamicDrawableSpan;", "Landroid/text/style/ReplacementSpan;", "verticalAlignment", "", "(I)V", "cachedDrawable", "Landroid/graphics/drawable/Drawable;", "getCachedDrawable", "()Landroid/graphics/drawable/Drawable;", "drawable", "getDrawable", "setDrawable", "(Landroid/graphics/drawable/Drawable;)V", "drawableRef", "Ljava/lang/ref/WeakReference;", "getVerticalAlignment", "()I", "setVerticalAlignment", "draw", "", "canvas", "Landroid/graphics/Canvas;", "text", "", "start", "end", "x", "", "top", "y", "bottom", "paint", "Landroid/graphics/Paint;", "getSize", "fm", "Landroid/graphics/Paint$FontMetricsInt;", "extensions_release"})
    public static abstract class CustomDynamicDrawableSpan
    extends ReplacementSpan {
        private int verticalAlignment;
        @Nullable
        private WeakReference<Drawable> drawableRef;

        public CustomDynamicDrawableSpan(int verticalAlignment) {
            this.verticalAlignment = verticalAlignment;
        }

        public /* synthetic */ CustomDynamicDrawableSpan(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            this(n);
        }

        public final int getVerticalAlignment() {
            return this.verticalAlignment;
        }

        public final void setVerticalAlignment(int n) {
            this.verticalAlignment = n;
        }

        @Nullable
        public abstract Drawable getDrawable();

        public abstract void setDrawable(@Nullable Drawable var1);

        private final Drawable getCachedDrawable() {
            Drawable d;
            WeakReference<Drawable> wr = this.drawableRef;
            WeakReference<Drawable> weakReference = wr;
            Drawable drawable = d = weakReference == null ? null : (Drawable)weakReference.get();
            if (d == null) {
                d = this.getDrawable();
                this.drawableRef = new WeakReference<Drawable>(d);
            }
            return d;
        }

        public int getSize(@NotNull Paint paint, @Nullable CharSequence text, int start, int end, @Nullable Paint.FontMetricsInt fm) {
            Rect rect;
            Rect rect2;
            Drawable d;
            Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
            Drawable drawable = d = this.getCachedDrawable();
            Rect rect3 = rect2 = drawable == null ? null : drawable.getBounds();
            if (rect2 == null) {
                return 0;
            }
            Rect rect4 = rect = rect2;
            rect = fm;
            if (rect != null) {
                rect2 = rect;
                boolean bl = false;
                boolean bl2 = false;
                Rect it = rect2;
                boolean bl3 = false;
                int lineHeight = it.bottom - it.top;
                if (lineHeight < rect4.height()) {
                    int n = this.getVerticalAlignment();
                    switch (n) {
                        case 3: {
                            it.top = it.top;
                            it.bottom = rect4.height() + it.top;
                            break;
                        }
                        case 2: {
                            it.top = -rect4.height() / 2 - lineHeight / 4;
                            it.bottom = rect4.height() / 2 - lineHeight / 4;
                            break;
                        }
                        default: {
                            it.top = -rect4.height() + it.bottom;
                            it.bottom = it.bottom;
                        }
                    }
                    it.ascent = it.top;
                    it.descent = it.bottom;
                }
            }
            return rect4.right;
        }

        public void draw(@NotNull Canvas canvas, @Nullable CharSequence text, int start, int end, float x, int top, int y, int bottom, @NotNull Paint paint) {
            Rect rect;
            Rect rect2;
            Drawable d;
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
            Drawable drawable = d = this.getCachedDrawable();
            Rect rect3 = rect2 = drawable == null ? null : drawable.getBounds();
            if (rect2 == null) {
                return;
            }
            Rect rect4 = rect = rect2;
            canvas.save();
            int lineHeight = bottom - top;
            if (rect4.height() < lineHeight) {
                float f;
                int n = this.verticalAlignment;
                switch (n) {
                    case 3: {
                        f = top;
                        break;
                    }
                    case 2: {
                        f = (float)(bottom + top - rect4.height()) / 2.0f;
                        break;
                    }
                    case 1: {
                        f = (float)y - (float)rect4.height();
                        break;
                    }
                    default: {
                        f = (float)bottom - (float)rect4.height();
                    }
                }
                float transY = f;
                canvas.translate(x, transY);
            } else {
                canvas.translate(x, (float)top);
            }
            d.draw(canvas);
            canvas.restore();
        }

        public CustomDynamicDrawableSpan() {
            this(0, 1, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/hsicen/extension/span/Span$ShaderSpan;", "Landroid/text/style/CharacterStyle;", "Landroid/text/style/UpdateAppearance;", "shader", "Landroid/graphics/Shader;", "(Landroid/graphics/Shader;)V", "updateDrawState", "", "tp", "Landroid/text/TextPaint;", "extensions_release"})
    public static final class ShaderSpan
    extends CharacterStyle
    implements UpdateAppearance {
        @NotNull
        private final Shader shader;

        public ShaderSpan(@NotNull Shader shader) {
            Intrinsics.checkNotNullParameter((Object)shader, (String)"shader");
            this.shader = shader;
        }

        public void updateDrawState(@NotNull TextPaint tp) {
            Intrinsics.checkNotNullParameter((Object)tp, (String)"tp");
            tp.setShader(this.shader);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/hsicen/extension/span/Span$ShadowSpan;", "Landroid/text/style/CharacterStyle;", "Landroid/text/style/UpdateAppearance;", "radius", "", "dx", "dy", "shadowColor", "", "(FFFI)V", "updateDrawState", "", "tp", "Landroid/text/TextPaint;", "extensions_release"})
    public static final class ShadowSpan
    extends CharacterStyle
    implements UpdateAppearance {
        private final float radius;
        private final float dx;
        private final float dy;
        private final int shadowColor;

        public ShadowSpan(float radius, float dx, float dy, int shadowColor) {
            this.radius = radius;
            this.dx = dx;
            this.dy = dy;
            this.shadowColor = shadowColor;
        }

        public void updateDrawState(@NotNull TextPaint tp) {
            Intrinsics.checkNotNullParameter((Object)tp, (String)"tp");
            tp.setShadowLayer(this.radius, this.dx, this.dy, this.shadowColor);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/hsicen/extension/span/Span$Creator;", "", "span", "Lcom/hsicen/extension/span/Span;", "(Lcom/hsicen/extension/span/Span;)V", "getSpan", "()Lcom/hsicen/extension/span/Span;", "create", "Landroid/text/SpannableStringBuilder;", "extensions_release"})
    public static final class Creator {
        @NotNull
        private final Span span;

        public Creator(@NotNull Span span) {
            Intrinsics.checkNotNullParameter((Object)span, (String)"span");
            this.span = span;
        }

        @NotNull
        public final Span getSpan() {
            return this.span;
        }

        @NotNull
        public final SpannableStringBuilder create() {
            return this.span.create$extensions_release();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/hsicen/extension/span/Span$Companion;", "", "()V", "ALIGN_BASELINE", "", "ALIGN_BOTTOM", "ALIGN_CENTER", "ALIGN_TOP", "COLOR_DEFAULT", "LINE_SEPARATOR", "", "kotlin.jvm.PlatformType", "Align", "extensions_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Retention(value=AnnotationRetention.SOURCE)
        @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/hsicen/extension/span/Span$Companion$Align;", "", "extensions_release"})
        public static @interface Align {
        }
    }
}

