/*
 * Decompiled with CFR 0.152.
 */
package com.hsicen.extension.span;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.text.style.ReplacementSpan;
import com.hsicen.extension.extensions.DpSpKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005JP\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J4\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/hsicen/extension/span/RoundSpan;", "Landroid/text/style/ReplacementSpan;", "bgColor", "", "textColor", "(II)V", "mRadius", "", "mSize", "draw", "", "canvas", "Landroid/graphics/Canvas;", "text", "", "start", "end", "x", "top", "y", "bottom", "paint", "Landroid/graphics/Paint;", "getSize", "fm", "Landroid/graphics/Paint$FontMetricsInt;", "extensions_release"})
public final class RoundSpan
extends ReplacementSpan {
    private final int bgColor;
    private final int textColor;
    private final float mRadius;
    private int mSize;

    public RoundSpan(int bgColor, int textColor) {
        this.bgColor = bgColor;
        this.textColor = textColor;
        this.mRadius = DpSpKt.getDp2px(2.0f);
    }

    public int getSize(@NotNull Paint paint, @Nullable CharSequence text, int start, int end, @Nullable Paint.FontMetricsInt fm) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        this.mSize = (int)(paint.measureText(text, start, end) + this.mRadius * (float)2);
        return this.mSize;
    }

    public void draw(@NotNull Canvas canvas, @NotNull CharSequence text, int start, int end, float x, int top, int y, int bottom, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        int defColor = paint.getColor();
        float def = paint.getStrokeWidth();
        paint.setColor(this.bgColor);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(DpSpKt.getDp2px(1.0f));
        paint.setAntiAlias(true);
        RectF mRectF = new RectF(x + 2.5f, (float)y + 2.5f + paint.ascent() - DpSpKt.getDp2px(1.0f), x + (float)this.mSize - DpSpKt.getDp2px(3.0f), (float)y + paint.descent() + DpSpKt.getDp2px(1.0f));
        canvas.drawRoundRect(mRectF, this.mRadius, this.mRadius, paint);
        paint.setColor(this.textColor);
        paint.setStyle(Paint.Style.FILL);
        paint.setStrokeWidth(def);
        paint.setTextSize(DpSpKt.getSp2px(12.0f));
        canvas.drawText(text, start, end, x + this.mRadius + DpSpKt.getDp2px(3.0f), (float)y, paint);
        paint.setColor(defColor);
    }
}

