/*
 * Decompiled with CFR 0.152.
 */
package com.hsicen.extension.extensions;

import android.content.Context;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.TouchDelegate;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import com.hsicen.extension.utils.ViewGroupUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\t\u0012\u0006\u0010\r\u001a\u00020\t\u0012\u0006\u0010\u000e\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/hsicen/extension/extensions/ExpandMultiTouchDelegate;", "Landroid/view/TouchDelegate;", "bounds", "Landroid/graphics/Rect;", "delegateView", "Landroid/view/View;", "parentView", "Landroid/view/ViewGroup;", "expand", "", "(Landroid/graphics/Rect;Landroid/view/View;Landroid/view/ViewGroup;I)V", "leftExpand", "rightExpand", "topExpand", "bottomExpand", "(Landroid/graphics/Rect;Landroid/view/View;Landroid/view/ViewGroup;IIII)V", "mBottomExpand", "mBounds", "mChildInParentBounds", "mDelegateTargeted", "", "mDelegateView", "mLeftExpand", "mParentView", "mRightExpand", "mSlop", "mSlopBounds", "mTopExpand", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "extensions_release"})
public final class ExpandMultiTouchDelegate
extends TouchDelegate {
    private boolean mDelegateTargeted;
    @NotNull
    private final Rect mBounds;
    private final int mSlop;
    @NotNull
    private final Rect mSlopBounds;
    @NotNull
    private final View mDelegateView;
    @NotNull
    private final ViewGroup mParentView;
    private final int mLeftExpand;
    private final int mRightExpand;
    private final int mTopExpand;
    private final int mBottomExpand;
    @NotNull
    private final Rect mChildInParentBounds;

    public ExpandMultiTouchDelegate(@NotNull Rect bounds, @NotNull View delegateView, @NotNull ViewGroup parentView, int leftExpand, int rightExpand, int topExpand, int bottomExpand) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)delegateView, (String)"delegateView");
        Intrinsics.checkNotNullParameter((Object)parentView, (String)"parentView");
        super(bounds, delegateView);
        this.mBounds = bounds;
        this.mSlop = ViewConfiguration.get((Context)delegateView.getContext()).getScaledTouchSlop();
        this.mSlopBounds = new Rect(bounds);
        this.mDelegateView = delegateView;
        this.mParentView = parentView;
        this.mLeftExpand = leftExpand;
        this.mRightExpand = rightExpand;
        this.mTopExpand = topExpand;
        this.mBottomExpand = bottomExpand;
        this.mChildInParentBounds = new Rect();
        this.mSlopBounds.inset(-this.mSlop, -this.mSlop);
    }

    public ExpandMultiTouchDelegate(@NotNull Rect bounds, @NotNull View delegateView, @NotNull ViewGroup parentView, int expand) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)delegateView, (String)"delegateView");
        Intrinsics.checkNotNullParameter((Object)parentView, (String)"parentView");
        this(bounds, delegateView, parentView, expand, expand, expand, expand);
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        int x = (int)event.getX();
        int y = (int)event.getY();
        boolean sendToDelegate = false;
        boolean hit = true;
        boolean handled = false;
        int n = event.getActionMasked();
        switch (n) {
            case 0: {
                sendToDelegate = this.mDelegateTargeted = this.mBounds.contains(x, y);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                Rect slopBounds;
                sendToDelegate = this.mDelegateTargeted;
                if (!sendToDelegate || (slopBounds = this.mSlopBounds).contains(x, y)) break;
                hit = false;
                break;
            }
            case 3: {
                sendToDelegate = this.mDelegateTargeted;
                this.mDelegateTargeted = false;
            }
        }
        if (sendToDelegate) {
            View delegateView = this.mDelegateView;
            if (hit) {
                if (delegateView instanceof ViewGroup) {
                    int n2 = 0;
                    int count = ((ViewGroup)delegateView).getChildCount();
                    if (n2 < count) {
                        do {
                            int i2;
                            if ((i2 = n2++) != 0 && i2 != count - 1) continue;
                            View child = ((ViewGroup)delegateView).getChildAt(i2);
                            Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                            ViewGroupUtils.INSTANCE.getDescendantRect(this.mParentView, child, this.mChildInParentBounds);
                            Rect rect = this.mChildInParentBounds;
                            rect.top -= this.mTopExpand;
                            rect = this.mChildInParentBounds;
                            rect.bottom += this.mBottomExpand;
                            rect = this.mChildInParentBounds;
                            rect.left -= this.mLeftExpand;
                            rect = this.mChildInParentBounds;
                            rect.right += this.mRightExpand;
                            if (!this.mChildInParentBounds.contains(x, y)) continue;
                            event.setLocation((float)child.getWidth() / 2.0f, (float)child.getHeight() / 2.0f);
                            return child.dispatchTouchEvent(event);
                        } while (n2 < count);
                    }
                    return false;
                }
                event.setLocation((float)delegateView.getWidth() / 2.0f, (float)delegateView.getHeight() / 2.0f);
            } else {
                int slop = this.mSlop;
                event.setLocation(-((float)(slop * 2)), -((float)(slop * 2)));
            }
            handled = delegateView.dispatchTouchEvent(event);
        }
        return handled;
    }
}

