/*
 * Decompiled with CFR 0.152.
 */
package com.hsicen.extension.extensions;

import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Environment;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0016\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00010\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\u0007\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n\u001a\u0016\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001\u001a\"\u0010\u000f\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012\u001a\"\u0010\u0014\u001a\n \b*\u0004\u0018\u00010\u00010\u0001*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n\u001a\u0012\u0010\u0016\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0006\u001a\n\u0010\u0018\u001a\u00020\u0019*\u00020\u0001\u00a8\u0006\u001a"}, d2={"drawable2Bitmap", "Landroid/graphics/Bitmap;", "drawable", "Landroid/graphics/drawable/Drawable;", "getBitmapFromAssets", "fileName", "", "res2Bitmap", "kotlin.jvm.PlatformType", "resId", "", "width", "scaleBitmap", "source", "sample", "composite", "upLayer", "padLeft", "", "padTop", "resize", "height", "save", "childPath", "toDrawable", "Landroid/graphics/drawable/BitmapDrawable;", "extensions_release"})
public final class BitmapsKt {
    public static final Bitmap resize(@NotNull Bitmap $this$resize, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)$this$resize, (String)"<this>");
        return Bitmap.createScaledBitmap((Bitmap)$this$resize, (int)width, (int)height, (boolean)true);
    }

    @NotNull
    public static final BitmapDrawable toDrawable(@NotNull Bitmap $this$toDrawable) {
        Intrinsics.checkNotNullParameter((Object)$this$toDrawable, (String)"<this>");
        return new BitmapDrawable(Resources.getSystem(), $this$toDrawable);
    }

    @NotNull
    public static final Bitmap drawable2Bitmap(@NotNull Drawable drawable) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        if (drawable instanceof BitmapDrawable && ((BitmapDrawable)drawable).getBitmap() != null) {
            Bitmap bitmap = ((BitmapDrawable)drawable).getBitmap();
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"drawable.bitmap");
            return bitmap;
        }
        Bitmap mBitmap = drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(mBitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        Intrinsics.checkNotNullExpressionValue((Object)mBitmap, (String)"mBitmap");
        return mBitmap;
    }

    public static final Bitmap res2Bitmap(int resId) {
        return BitmapFactory.decodeResource((Resources)Resources.getSystem(), (int)resId);
    }

    @NotNull
    public static final Bitmap res2Bitmap(int resId, int width) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)Resources.getSystem(), (int)resId, (BitmapFactory.Options)options);
        options.inJustDecodeBounds = false;
        options.inDensity = options.outWidth;
        options.inTargetDensity = width;
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)Resources.getSystem(), (int)resId, (BitmapFactory.Options)options);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"decodeResource(Resources.getSystem(), resId, options)");
        return bitmap;
    }

    @NotNull
    public static final Bitmap getBitmapFromAssets(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        AssetManager assetManager = Resources.getSystem().getAssets();
        InputStream inputStream = assetManager.open(fileName);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"assetManager.open(fileName)");
        InputStream stream = inputStream;
        Bitmap decodeBitmap = BitmapFactory.decodeStream((InputStream)stream);
        stream.close();
        Intrinsics.checkNotNullExpressionValue((Object)decodeBitmap, (String)"decodeBitmap");
        return decodeBitmap;
    }

    @NotNull
    public static final Bitmap scaleBitmap(@NotNull Bitmap source, @NotNull Bitmap sample) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)sample, (String)"sample");
        float scale = (float)sample.getWidth() / 1080.0f;
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)matrix, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(source, 0, 0, source.width, source.height, matrix, true)");
        return bitmap;
    }

    @NotNull
    public static final Bitmap composite(@NotNull Bitmap $this$composite, @NotNull Bitmap upLayer, float padLeft, float padTop) {
        Intrinsics.checkNotNullParameter((Object)$this$composite, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)upLayer, (String)"upLayer");
        Bitmap newBitmap = Bitmap.createBitmap((int)$this$composite.getWidth(), (int)$this$composite.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(newBitmap);
        canvas.drawBitmap($this$composite, 0.0f, 0.0f, null);
        canvas.drawBitmap(upLayer, padLeft, padTop, null);
        canvas.save();
        canvas.restore();
        Intrinsics.checkNotNullExpressionValue((Object)newBitmap, (String)"newBitmap");
        return newBitmap;
    }

    @NotNull
    public static final String save(@NotNull Bitmap $this$save, @NotNull String childPath) {
        Intrinsics.checkNotNullParameter((Object)$this$save, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)childPath, (String)"childPath");
        File bitmapDir = new File(Environment.getExternalStorageDirectory(), childPath);
        if (!bitmapDir.exists()) {
            bitmapDir.mkdir();
        }
        String fileName = System.currentTimeMillis() + ".jpg";
        File file = new File(bitmapDir, fileName);
        FileOutputStream fos = new FileOutputStream(file);
        $this$save.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fos);
        fos.flush();
        fos.close();
        String path = file.getAbsolutePath();
        $this$save.recycle();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
        return path;
    }
}

