package com.hsicen.extension.utils

/**
 * <p>作者：Hsicen  2019/10/2 17:39
 * <p>邮箱：codinghuang@163.com
 * <p>功能：
 * <p>描述：正则相关常量
 */
object Regex {

  /*** 正则：手机号（简单）*/
  val MOBILE_SIMPLE = "^[1]\\d{10}$"

  /**
   * 正则：手机号（精确）
   * 移动：134(0-8)、135、136、137、138、139、147、150、151、152、157、158、159、178、182、183、184、187、188
   * 联通：130、131、132、145、155、156、175、176、185、186
   * 电信：133、153、173、177、180、181、189
   * 全球星：1349
   * 虚拟运营商：170
   */
  val MOBILE_EXACT =
    "^((13[0-9])|(14[5,7])|(15[0-3,5-9])|(17[0,3,5-8])|(18[0-9])|(147))\\d{8}$"

  /*** 正则：电话号码*/
  val TEL = "^0\\d{2,3}[- ]?\\d{7,8}"

  /*** 正则：身份证号码15位*/
  val ID_CARD15 = "^[1-9]\\d{7}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}$"

  /*** 正则：身份证号码18位*/
  val ID_CARD18 =
    "^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([0-9Xx])$"

  /*** 正则：邮箱*/
  val EMAIL = "^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$"

  /*** 正则：URL*/
  val URL = "[a-zA-z]+://[^\\s]*"

  /*** 正则：汉字*/
  val ZH = "^[\\u4e00-\\u9fa5]+$"

  /*** 正则：用户名，取值范围为a-z,A-Z,0-9,"_",汉字，不能以"_"结尾,用户名必须是6-20位*/
  val USERNAME = "^[\\w\\u4e00-\\u9fa5]{6,20}(?<!_)$"

  /*** 正则：yyyy-MM-dd格式的日期校验，已考虑平闰年*/
  val DATE =
    "^(?:(?!0000)[0-9]{4}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)$"

  /*** 正则：IP地址*/
  val IP = "((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)"

  /*** 正则：双字节字符(包括汉字在内)*/
  val DOUBLE_BYTE_CHAR = "[^\\x00-\\xff]"

  /*** 正则：空白行*/
  val BLANK_LINE = "\\n\\s*\\r"

  /*** 正则：QQ号*/
  val TENCENT_NUM = "[1-9][0-9]{4,}"


  /*** 正则：💰前有3个后有4个数字,零宽断言*/
  val SEVEN_NUM = "(?<=\\d{3})\\d(?=\\d{4})"

  /*** 邮箱*/
  val MAIl_REPLACE = "(?<=\\b\\w{2})\\w+(?=@)"


  /*** 正则：中国邮政编码*/
  val ZIP_CODE = "[1-9]\\d{5}(?!\\d)"

  /*** 正则：正整数*/
  val POSITIVE_INTEGER = "^[1-9]\\d*$"

  /*** 正则：负整数*/
  val NEGATIVE_INTEGER = "^-[1-9]\\d*$"

  /*** 正则：整数*/
  val INTEGER = "^-?[1-9]\\d*$"

  /*** 正则：非负整数(正整数 + 0)*/
  val NOT_NEGATIVE_INTEGER = "^[1-9]\\d*|0$"

  /*** 正则：非正整数（负整数 + 0）*/
  val NOT_POSITIVE_INTEGER = "^-[1-9]\\d*|0$"

  /*** 正则：正浮点数*/
  val POSITIVE_FLOAT = "^[1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*$"

  /*** 正则：负浮点数*/
  val NEGATIVE_FLOAT = "^-[1-9]\\d*\\.\\d*|-0\\.\\d*[1-9]\\d*$"


  /**
   * 匹配图象
   * 格式: /相对路径/文件名.后缀 (后缀为gif,dmp,png)
   * 匹配 : /forum/head_icon/admini2005111_ff.gif 或 admini2005111.dmp
   * 不匹配: c:/admins4512.gif
   */
  val ICON_REGEXP = "^(/{0,1}//w){1,}//.(gif|dmp|png|jpg)$|^//w{1,}//.(gif|dmp|png|jpg)$"

  /**
   * 匹配email地址
   * 格式: XXX@XXX.XXX.XX
   * 匹配 : foo@bar.com 或 foobar@foobar.com.au
   * 不匹配: foo@bar 或 $$$@bar.com
   */
  val EMAIL_REGEXP = "(?://w[-._//w]*//w@//w[-._//w]*//w//.//w{2,3}$)"

  /**
   * 匹配并提取url
   * 格式: XXXX://XXX.XXX.XXX.XX/XXX.XXX?XXX=XXX
   * 匹配 : http://www.suncer.com 或news://www
   * 不匹配: c:/window
   */
  val URL_REGEXP = "(//w+)://([^/:]+)(://d*)?([^#//s]*)"

  /**
   * 匹配并提取http
   * 格式: http://XXX.XXX.XXX.XX/XXX.XXX?XXX=XXX 或 ftp://XXX.XXX.XXX 或
   * https://XXX
   * 匹配 : http://www.suncer.com:8080/index.html?login=true
   * 不匹配: news://www
   */
  val HTTP_REGEXP = "(http|https|ftp)://([^/:]+)(://d*)?([^#//s]*)"

  /**
   * 匹配日期
   * 格式(首位不为0): XXXX-XX-XX或 XXXX-X-X
   * 范围:1900--2099
   * 匹配 : 2005-04-04
   * 不匹配: 01-01-01
   */
  val DATE_BARS_REGEXP = "^((((19){1}|(20){1})\\d{2})|\\d{2})-[0,1]?\\d{1}-[0-3]?\\d{1}$"

  /**
   * 匹配日期
   * 格式: XXXX/XX/XX
   * 范围:
   * 匹配 : 2005/04/04
   * 不匹配: 01/01/01
   */
  val DATE_SLASH_REGEXP =
    "^[0-9]{4}/(((0[13578]|(10|12))/(0[1-9]|[1-2][0-9]|3[0-1]))|(02-(0[1-9]|[1-2][0-9]))|((0[469]|11)/(0[1-9]|[1-2][0-9]|30)))$"

  /**
   * 匹配电话
   * 格式为: 0XXX-XXXXXX(10-13位首位必须为0) 或0XXX XXXXXXX(10-13位首位必须为0) 或
   * (0XXX)XXXXXXXX(11-14位首位必须为0) 或 XXXXXXXX(6-8位首位不为0) 或
   * XXXXXXXXXXX(11位首位不为0)
   * 匹配 : 0371-123456 或 (0371)1234567 或 (0371)12345678 或 010-123456 或
   * 010-12345678 或 12345678912
   * 不匹配: 1111-134355 或 0123456789
   */
  val PHONE_REGEXP =
    "^(?:0[0-9]{2,3}[-//s]{1}|//(0[0-9]{2,4}//))[0-9]{6,8}$|^[1-9]{1}[0-9]{5,7}$|^[1-9]{1}[0-9]{10}$"

  /**
   * 匹配身份证
   * 格式为: XXXXXXXXXX(10位) 或 XXXXXXXXXXXXX(13位) 或 XXXXXXXXXXXXXXX(15位) 或
   * XXXXXXXXXXXXXXXXXX(18位)
   * 匹配 : 0123456789123
   * 不匹配: 0123456
   */
  val ID_CARD_REGEXP = "^//d{10}|//d{13}|//d{15}|//d{18}$"

  /**
   * 匹配邮编代码
   * 格式为: XXXXXX(6位)
   * 匹配 : 012345
   * 不匹配: 0123456
   */
  val ZIP_REGEXP = "^[0-9]{6}$"// 匹配邮编代码

  /**
   * 不包括特殊字符的匹配 (字符串中不包括符号 数学次方号^ 单引号' 双引号" 分号; 逗号, 帽号: 数学减号- 右尖括号> 左尖括号< 反斜杠/
   * 即空格,制表符,回车符等 )
   * 格式为: x 或 一个一上的字符
   * 匹配 : 012345
   * 不匹配: 0123456 // ;,:-<>//s].+$";//
   */
  val NON_SPECIAL_CHAR_REGEXP = "^[^'/"

  /*** 匹配非负整数（正整数 + 0)*/
  val NON_NEGATIVE_INTEGERS_REGEXP = "^//d+$"

  /*** 匹配不包括零的非负整数（正整数 > 0)*/
  val NON_ZERO_NEGATIVE_INTEGERS_REGEXP = "^[1-9]+//d*$"

  /*** 匹配正整数*/
  val POSITIVE_INTEGER_REGEXP = "^[0-9]*[1-9][0-9]*$"

  /*** 匹配非正整数（负整数 + 0）*/
  val NON_POSITIVE_INTEGERS_REGEXP = "^((-//d+)|(0+))$"

  /*** 匹配负整数*/
  val NEGATIVE_INTEGERS_REGEXP = "^-[0-9]*[1-9][0-9]*$"

  /*** 匹配整数*/
  val INTEGER_REGEXP = "^-?//d+$"

  /*** 匹配非负浮点数（正浮点数 + 0）*/
  val NON_NEGATIVE_RATIONAL_NUMBERS_REGEXP = "^//d+(//.//d+)?$"

  /*** 匹配正浮点数*/
  val POSITIVE_RATIONAL_NUMBERS_REGEXP =
    "^(([0-9]+//.[0-9]*[1-9][0-9]*)|([0-9]*[1-9][0-9]*//.[0-9]+)|([0-9]*[1-9][0-9]*))$"

  /*** 匹配非正浮点数（负浮点数 + 0）*/
  val NON_POSITIVE_RATIONAL_NUMBERS_REGEXP = "^((-//d+(//.//d+)?)|(0+(//.0+)?))$"

  /*** 匹配负浮点数*/
  val NEGATIVE_RATIONAL_NUMBERS_REGEXP =
    "^(-(([0-9]+//.[0-9]*[1-9][0-9]*)|([0-9]*[1-9][0-9]*//.[0-9]+)|([0-9]*[1-9][0-9]*)))$"

  /*** 匹配浮点数*/
  val RATIONAL_NUMBERS_REGEXP = "^(-?//d+)(//.//d+)?$"

  /*** 匹配由26个英文字母组成的字符串*/
  val LETTER_REGEXP = "^[A-Za-z]+$"

  /*** 匹配由26个英文字母的大写组成的字符串*/
  val UPWARD_LETTER_REGEXP = "^[A-Z]+$"

  /*** 匹配由26个英文字母的小写组成的字符串*/
  val LOWER_LETTER_REGEXP = "^[a-z]+$"

  /*** 匹配由数字和26个英文字母组成的字符串*/
  val LETTER_NUMBER_REGEXP = "^[A-Za-z0-9]+$"

  /*** 匹配由数字、26个英文字母或者下划线组成的字符串*/
  val LETTER_NUMBER_UNDERLINE_REGEXP = "^//w+$"
}
