/*
 * Decompiled with CFR 0.152.
 */
package com.hrskrs.instadotlib;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.hrskrs.instadotlib.AnimationListener;
import com.hrskrs.instadotlib.AnimatorListener;
import com.hrskrs.instadotlib.Dot;
import com.hrskrs.instadotlib.R;
import java.util.ArrayList;
import java.util.List;

public class InstaDotView
extends View {
    private static final int MIN_VISIBLE_DOT_COUNT = 6;
    private static final int DEFAULT_VISIBLE_DOTS_COUNT = 6;
    private int activeDotSize;
    private int inactiveDotSize;
    private int mediumDotSize;
    private int smallDotSize;
    private int dotMargin;
    private Paint activePaint = new Paint(1);
    private Paint inactivePaint = new Paint(1);
    private int startPosX;
    private int posY = 0;
    private int previousPage = 0;
    private int currentPage = 0;
    private ValueAnimator translationAnim;
    private List<Dot> dotsList = new ArrayList<Dot>();
    private int noOfPages = 0;
    private int visibleDotCounts = 6;

    public InstaDotView(Context context) {
        super(context);
        this.setup(context, null);
    }

    public InstaDotView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.setup(context, attrs);
    }

    public InstaDotView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setup(context, attrs);
    }

    public InstaDotView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setup(context, attrs);
    }

    private void setup(Context context, AttributeSet attributeSet) {
        Resources resources = this.getResources();
        if (attributeSet != null) {
            TypedArray ta = context.obtainStyledAttributes(attributeSet, R.styleable.InstaDotView);
            this.activePaint.setStyle(Paint.Style.FILL);
            this.activePaint.setColor(ta.getColor(R.styleable.InstaDotView_dot_activeColor, resources.getColor(R.color.active)));
            this.inactivePaint.setStyle(Paint.Style.FILL);
            this.inactivePaint.setColor(ta.getColor(R.styleable.InstaDotView_dot_inactiveColor, resources.getColor(R.color.inactive)));
            this.activeDotSize = ta.getDimensionPixelSize(R.styleable.InstaDotView_dot_activeSize, resources.getDimensionPixelSize(R.dimen.dot_active_size));
            this.inactiveDotSize = ta.getDimensionPixelSize(R.styleable.InstaDotView_dot_inactiveSize, resources.getDimensionPixelSize(R.dimen.dot_inactive_size));
            this.mediumDotSize = ta.getDimensionPixelSize(R.styleable.InstaDotView_dot_mediumSize, resources.getDimensionPixelSize(R.dimen.dot_medium_size));
            this.smallDotSize = ta.getDimensionPixelSize(R.styleable.InstaDotView_dot_smallSize, resources.getDimensionPixelSize(R.dimen.dot_small_size));
            this.dotMargin = ta.getDimensionPixelSize(R.styleable.InstaDotView_dot_margin, resources.getDimensionPixelSize(R.dimen.dot_margin));
            this.setVisibleDotCounts(ta.getInteger(R.styleable.InstaDotView_dots_visible, 6));
            ta.recycle();
        }
        this.posY = this.activeDotSize / 2;
        this.initCircles();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int desiredWidth = (this.activeDotSize + this.dotMargin) * (this.dotsList.size() + 1);
        int desiredHeight = this.activeDotSize;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = widthMode == 0x40000000 ? widthSize : (widthMode == Integer.MIN_VALUE ? Math.min(desiredWidth, widthSize) : desiredWidth);
        int height = heightMode == 0x40000000 ? heightSize : (heightMode == Integer.MIN_VALUE ? Math.min(desiredHeight, heightSize) : desiredHeight);
        this.setMeasuredDimension(width, height);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawCircles(canvas);
    }

    private void initCircles() {
        int viewCount = Math.min(this.getNoOfPages(), this.getVisibleDotCounts());
        if (viewCount < 1) {
            return;
        }
        this.setStartPosX(this.noOfPages > this.visibleDotCounts ? this.getSmallDotStartX() : 0);
        this.dotsList = new ArrayList<Dot>(viewCount);
        for (int i = 0; i < viewCount; ++i) {
            Dot dot = new Dot();
            Dot.State state = this.noOfPages > this.visibleDotCounts ? (i == this.getVisibleDotCounts() - 1 ? Dot.State.SMALL : (i == this.getVisibleDotCounts() - 2 ? Dot.State.MEDIUM : (i == 0 ? Dot.State.ACTIVE : Dot.State.INACTIVE))) : (i == 0 ? Dot.State.ACTIVE : Dot.State.INACTIVE);
            dot.setState(state);
            this.dotsList.add(dot);
        }
        this.invalidate();
    }

    private void drawCircles(Canvas canvas) {
        int posX = this.getStartPosX();
        for (int i = 0; i < this.dotsList.size(); ++i) {
            int radius;
            Dot d = this.dotsList.get(i);
            Paint paint = this.inactivePaint;
            switch (d.getState()) {
                case ACTIVE: {
                    paint = this.activePaint;
                    radius = this.getActiveDotRadius();
                    posX += this.getActiveDotStartX();
                    break;
                }
                case INACTIVE: {
                    radius = this.getInactiveDotRadius();
                    posX += this.getInactiveDotStartX();
                    break;
                }
                case MEDIUM: {
                    radius = this.getMediumDotRadius();
                    posX += this.getMediumDotStartX();
                    break;
                }
                case SMALL: {
                    radius = this.getSmallDotRadius();
                    posX += this.getSmallDotStartX();
                    break;
                }
                default: {
                    radius = 0;
                    posX = 0;
                }
            }
            canvas.drawCircle((float)posX, (float)this.posY, (float)radius, paint);
        }
    }

    private ValueAnimator getTranslationAnimation(int from, int to, final AnimationListener listener) {
        if (this.translationAnim != null) {
            this.translationAnim.cancel();
        }
        this.translationAnim = ValueAnimator.ofInt((int[])new int[]{from, to});
        this.translationAnim.setDuration(120L);
        this.translationAnim.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.translationAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int val = (Integer)valueAnimator.getAnimatedValue();
                if (InstaDotView.this.getStartPosX() != val) {
                    InstaDotView.this.setStartPosX(val);
                    InstaDotView.this.invalidate();
                }
            }
        });
        this.translationAnim.addListener((Animator.AnimatorListener)new AnimatorListener(){

            public void onAnimationEnd(Animator animator) {
                if (listener != null) {
                    listener.onAnimationEnd();
                }
            }
        });
        return this.translationAnim;
    }

    public void setNoOfPages(int noOfPages) {
        this.setVisibility(noOfPages <= 1 ? 8 : 0);
        this.noOfPages = noOfPages;
        this.recreate();
    }

    public int getNoOfPages() {
        return this.noOfPages;
    }

    public void setVisibleDotCounts(int visibleDotCounts) {
        if (visibleDotCounts < 6) {
            throw new RuntimeException("Visible Dot count cannot be smaller than 6");
        }
        this.visibleDotCounts = visibleDotCounts;
        this.recreate();
    }

    private void recreate() {
        this.initCircles();
        this.requestLayout();
        this.invalidate();
    }

    public int getVisibleDotCounts() {
        return this.visibleDotCounts;
    }

    public void setStartPosX(int startPosX) {
        this.startPosX = startPosX;
    }

    public int getStartPosX() {
        return this.startPosX;
    }

    public int getActiveDotStartX() {
        return this.activeDotSize + this.dotMargin;
    }

    private int getInactiveDotStartX() {
        return this.inactiveDotSize + this.dotMargin;
    }

    private int getMediumDotStartX() {
        return this.mediumDotSize + this.dotMargin;
    }

    private int getSmallDotStartX() {
        return this.smallDotSize + this.dotMargin;
    }

    private int getActiveDotRadius() {
        return this.activeDotSize / 2;
    }

    private int getInactiveDotRadius() {
        return this.inactiveDotSize / 2;
    }

    private int getMediumDotRadius() {
        return this.mediumDotSize / 2;
    }

    private int getSmallDotRadius() {
        return this.smallDotSize / 2;
    }

    public void onPageChange(int page) {
        this.currentPage = page;
        if (page != this.previousPage && page >= 0 && page <= this.getNoOfPages() - 1) {
            this.updateDots();
            this.previousPage = this.currentPage;
        }
    }

    private void updateDots() {
        if (this.noOfPages <= this.visibleDotCounts) {
            this.setupNormalDots();
            return;
        }
        for (int i = 0; i < this.dotsList.size(); ++i) {
            Dot currentDot = this.dotsList.get(i);
            if (!currentDot.getState().equals((Object)Dot.State.ACTIVE)) continue;
            currentDot.setState(Dot.State.INACTIVE);
            if (this.currentPage > this.previousPage) {
                this.setupFlexibleCirclesRight(i);
            } else {
                this.setupFlexibleCirclesLeft(i);
            }
            return;
        }
    }

    private void setupNormalDots() {
        this.dotsList.get(this.currentPage).setState(Dot.State.ACTIVE);
        this.dotsList.get(this.previousPage).setState(Dot.State.INACTIVE);
        this.invalidate();
    }

    private void setupFlexibleCirclesRight(int position) {
        if (position >= this.getVisibleDotCounts() - 3) {
            if (this.currentPage == this.getNoOfPages() - 1) {
                this.dotsList.get(this.dotsList.size() - 1).setState(Dot.State.ACTIVE);
                this.invalidate();
            } else if (this.currentPage == this.getNoOfPages() - 2) {
                this.dotsList.get(this.dotsList.size() - 1).setState(Dot.State.MEDIUM);
                this.dotsList.get(this.dotsList.size() - 2).setState(Dot.State.ACTIVE);
                this.invalidate();
            } else {
                this.removeAddRight(position);
            }
        } else {
            this.dotsList.get(position + 1).setState(Dot.State.ACTIVE);
            this.invalidate();
        }
    }

    private void removeAddRight(final int position) {
        this.dotsList.remove(0);
        this.setStartPosX(this.getStartPosX() + this.getSmallDotStartX());
        this.getTranslationAnimation(this.getStartPosX(), this.getSmallDotStartX(), new AnimationListener(){

            @Override
            public void onAnimationEnd() {
                ((Dot)InstaDotView.this.dotsList.get(0)).setState(Dot.State.SMALL);
                ((Dot)InstaDotView.this.dotsList.get(1)).setState(Dot.State.MEDIUM);
                Dot newDot = new Dot();
                newDot.setState(Dot.State.ACTIVE);
                InstaDotView.this.dotsList.add(position, newDot);
                InstaDotView.this.invalidate();
            }
        }).start();
    }

    private void setupFlexibleCirclesLeft(int position) {
        if (position <= 2) {
            if (this.currentPage == 0) {
                this.dotsList.get(0).setState(Dot.State.ACTIVE);
                this.invalidate();
            } else if (this.currentPage == 1) {
                this.dotsList.get(0).setState(Dot.State.MEDIUM);
                this.dotsList.get(1).setState(Dot.State.ACTIVE);
                this.invalidate();
            } else {
                this.removeAddLeft(position);
            }
        } else {
            this.dotsList.get(position - 1).setState(Dot.State.ACTIVE);
            this.invalidate();
        }
    }

    private void removeAddLeft(final int position) {
        this.dotsList.remove(this.dotsList.size() - 1);
        this.setStartPosX(0);
        this.getTranslationAnimation(this.getStartPosX(), this.getSmallDotStartX(), new AnimationListener(){

            @Override
            public void onAnimationEnd() {
                ((Dot)InstaDotView.this.dotsList.get(InstaDotView.this.dotsList.size() - 1)).setState(Dot.State.SMALL);
                ((Dot)InstaDotView.this.dotsList.get(InstaDotView.this.dotsList.size() - 2)).setState(Dot.State.MEDIUM);
                Dot newDot = new Dot();
                newDot.setState(Dot.State.ACTIVE);
                InstaDotView.this.dotsList.add(position, newDot);
                InstaDotView.this.invalidate();
            }
        }).start();
    }
}

