/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.stream;

import com.github.housepower.data.Block;
import com.github.housepower.misc.CheckedIterator;
import com.github.housepower.misc.CheckedSupplier;
import com.github.housepower.protocol.DataResponse;
import com.github.housepower.protocol.EOFStreamResponse;
import com.github.housepower.protocol.ProgressResponse;
import com.github.housepower.protocol.Response;
import com.github.housepower.protocol.listener.ProgressListener;
import com.github.housepower.stream.QueryResult;
import java.sql.SQLException;

public class ClickHouseQueryResult
implements QueryResult {
    private final CheckedSupplier<Response, SQLException> responseSupplier;
    private ProgressListener progressListener;
    private Block header;
    private boolean atEnd;

    public ClickHouseQueryResult(CheckedSupplier<Response, SQLException> responseSupplier) {
        this.responseSupplier = responseSupplier;
    }

    public ClickHouseQueryResult(CheckedSupplier<Response, SQLException> responseSupplier, ProgressListener progressListener) {
        this.progressListener = progressListener;
        this.responseSupplier = responseSupplier;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    @Override
    public Block header() throws SQLException {
        this.ensureHeaderConsumed();
        return this.header;
    }

    @Override
    public CheckedIterator<DataResponse, SQLException> data() {
        return new CheckedIterator<DataResponse, SQLException>(){
            private DataResponse current;

            @Override
            public boolean hasNext() throws SQLException {
                return this.current != null || this.fill() != null;
            }

            @Override
            public DataResponse next() throws SQLException {
                return this.drain();
            }

            private DataResponse fill() throws SQLException {
                ClickHouseQueryResult.this.ensureHeaderConsumed();
                this.current = ClickHouseQueryResult.this.consumeDataResponse();
                return this.current;
            }

            private DataResponse drain() throws SQLException {
                if (this.current == null) {
                    this.fill();
                }
                DataResponse top = this.current;
                this.current = null;
                return top;
            }
        };
    }

    private void ensureHeaderConsumed() throws SQLException {
        if (this.header == null) {
            DataResponse firstDataResponse = this.consumeDataResponse();
            this.header = firstDataResponse != null ? firstDataResponse.block() : new Block();
        }
    }

    private DataResponse consumeDataResponse() throws SQLException {
        long readRows = 0L;
        long readBytes = 0L;
        while (!this.atEnd) {
            Response response = this.responseSupplier.get();
            if (response instanceof DataResponse) {
                DataResponse dataResponse = (DataResponse)response;
                dataResponse.block().setProgress(readRows, readBytes);
                return dataResponse;
            }
            if (response instanceof EOFStreamResponse || response == null) {
                this.atEnd = true;
                continue;
            }
            if (!(response instanceof ProgressResponse)) continue;
            if (this.progressListener != null) {
                this.progressListener.onProgress((ProgressResponse)response);
            }
            readRows += ((ProgressResponse)response).newRows();
            readBytes += ((ProgressResponse)response).newBytes();
        }
        return null;
    }
}

