/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.data;

import com.github.housepower.data.AbstractColumn;
import com.github.housepower.data.ColumnFactory;
import com.github.housepower.data.ColumnWriterBuffer;
import com.github.housepower.data.IColumn;
import com.github.housepower.data.type.complex.DataTypeNullable;
import com.github.housepower.serde.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class ColumnNullable
extends AbstractColumn {
    private final List<Byte> nullableSign = new ArrayList<Byte>();
    private final IColumn data;

    public ColumnNullable(String name, DataTypeNullable type, Object[] values) {
        super(name, type, values);
        this.data = ColumnFactory.createColumn(null, type.getNestedDataType(), null);
    }

    @Override
    public void write(@Nullable Object object) throws IOException, SQLException {
        if (object == null) {
            this.nullableSign.add((byte)1);
            this.data.write(this.type.defaultValue());
        } else {
            this.nullableSign.add((byte)0);
            this.data.write(object);
        }
    }

    @Override
    public void flushToSerializer(BinarySerializer serializer, boolean immediate) throws IOException {
        if (this.isExported()) {
            serializer.writeUTF8StringBinary(this.name);
            serializer.writeUTF8StringBinary(this.type.name());
        }
        for (byte sign : this.nullableSign) {
            serializer.writeByte(sign);
        }
        if (immediate) {
            this.buffer.writeTo(serializer);
        }
    }

    @Override
    public void setColumnWriterBuffer(ColumnWriterBuffer buffer) {
        super.setColumnWriterBuffer(buffer);
        this.data.setColumnWriterBuffer(buffer);
    }
}

