/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.stream;

import com.github.housepower.jdbc.data.Block;
import com.github.housepower.jdbc.data.Column;
import com.github.housepower.jdbc.misc.SQLLexer;
import com.github.housepower.jdbc.misc.Validate;
import com.github.housepower.jdbc.stream.InputFormat;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ValuesWithParametersInputFormat
implements InputFormat {
    private final Iterator<Object[]> iterator;
    private int pPos;
    private SQLLexer lexer;
    private Object[] parameters;
    private final int pos;
    private final String query;

    public ValuesWithParametersInputFormat(String query, int pos, List<Object[]> parameters) throws SQLException {
        this.pos = pos;
        this.query = query;
        this.iterator = parameters.iterator();
        this.lexer = new SQLLexer(pos, query);
        this.parameters = this.iterator.hasNext() ? this.iterator.next() : new Object[]{};
    }

    @Override
    public Block next(Block header, int maxRows) throws SQLException {
        Object[][] columnData = new Object[header.columns()][maxRows];
        for (int row = 0; row < maxRows; ++row) {
            char nextChar = this.lexer.character();
            if (this.lexer.eof() || nextChar == ';') {
                if (!this.iterator.hasNext()) {
                    return this.newPreparedBlock(header, row, columnData);
                }
                this.pPos = 0;
                this.parameters = this.iterator.next();
                this.lexer = new SQLLexer(this.pos, this.query);
                nextChar = this.lexer.character();
            }
            Validate.isTrue(nextChar == '(');
            for (int column = 0; column < header.columns(); ++column) {
                if (column > 0) {
                    Validate.isTrue(this.lexer.character() == ',');
                }
                columnData[column][row] = this.lexer.isCharacter('?') ? this.quotedParameter() : header.getByPosition(column).type().deserializeTextQuoted(this.lexer);
            }
            Validate.isTrue(this.lexer.character() == ')');
        }
        return this.newPreparedBlock(header, maxRows, columnData);
    }

    private Object quotedParameter() throws SQLException {
        Validate.isTrue(this.lexer.character() == '?');
        return this.parameters[this.pPos++];
    }

    private Block newPreparedBlock(Block header, int rows, Object[][] columnData) throws SQLException {
        Validate.isTrue(header.columns() == columnData.length, "");
        Column[] columns = new Column[columnData.length];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = new Column(header.getByPosition(i).name(), header.getByPosition(i).type(), Arrays.copyOf(columnData[i], rows));
        }
        return new Block(rows, columns);
    }
}

