/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.stream;

import com.github.housepower.jdbc.data.Block;
import com.github.housepower.jdbc.data.Column;
import com.github.housepower.jdbc.misc.SQLLexer;
import com.github.housepower.jdbc.misc.Validate;
import com.github.housepower.jdbc.stream.InputFormat;
import java.sql.SQLException;
import java.util.Arrays;

public class ValuesInputFormat
implements InputFormat {
    private final SQLLexer lexer;

    public ValuesInputFormat(int pos, String data) throws SQLException {
        this.lexer = new SQLLexer(pos, data);
    }

    @Override
    public Block next(Block header, int maxRows) throws SQLException {
        Object[][] columnData = new Object[header.columns()][maxRows];
        for (int row = 0; row < maxRows; ++row) {
            char nextChar = this.lexer.character();
            if (this.lexer.eof() || nextChar == ';') {
                return this.newValuesBlock(header, row, columnData);
            }
            if (row > 0 && nextChar == ',') {
                nextChar = this.lexer.character();
            }
            Validate.isTrue(nextChar == '(');
            for (int column = 0; column < header.columns(); ++column) {
                if (column > 0) {
                    Validate.isTrue(this.lexer.character() == ',');
                }
                columnData[column][row] = header.getByPosition(column).type().deserializeTextQuoted(this.lexer);
            }
            Validate.isTrue(this.lexer.character() == ')');
        }
        return this.newValuesBlock(header, maxRows, columnData);
    }

    private Block newValuesBlock(Block header, int rows, Object[][] columnData) throws SQLException {
        Validate.isTrue(header.columns() == columnData.length, "");
        Column[] columns = new Column[columnData.length];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = new Column(header.getByPosition(i).name(), header.getByPosition(i).type(), Arrays.copyOf(columnData[i], rows));
        }
        return new Block(rows, columns);
    }
}

