/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.statement;

import com.github.housepower.jdbc.ClickHouseConnection;
import com.github.housepower.jdbc.statement.AbstractPreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;

public class ClickHousePreparedQueryStatement
extends AbstractPreparedStatement {
    public ClickHousePreparedQueryStatement(ClickHouseConnection conn, String query) {
        this(conn, ClickHousePreparedQueryStatement.splitQueryByQuestionMark(query));
    }

    private ClickHousePreparedQueryStatement(ClickHouseConnection conn, String[] parts) {
        super(conn, parts, parts.length - 1);
    }

    @Override
    public boolean execute() throws SQLException {
        return this.execute(this.assembleQueryPartsAndParameters());
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.executeUpdate(this.assembleQueryPartsAndParameters());
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException("");
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(this.assembleQueryPartsAndParameters());
    }

    private static String[] splitQueryByQuestionMark(String query) {
        int lastPos = 0;
        ArrayList<String> queryParts = new ArrayList<String>();
        boolean inQuotes = false;
        boolean inBackQuotes = false;
        for (int i = 0; i < query.length(); ++i) {
            char ch = query.charAt(i);
            if (ch == '`') {
                inBackQuotes = !inBackQuotes;
                continue;
            }
            if (ch == '\'') {
                inQuotes = !inQuotes;
                continue;
            }
            if (inBackQuotes || inQuotes || ch != '?') continue;
            queryParts.add(query.substring(lastPos, i));
            lastPos = i + 1;
        }
        queryParts.add(query.substring(lastPos, query.length()));
        return queryParts.toArray(new String[queryParts.size()]);
    }
}

