/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.statement;

import com.github.housepower.jdbc.ClickHouseConnection;
import com.github.housepower.jdbc.misc.Validate;
import com.github.housepower.jdbc.statement.AbstractPreparedStatement;
import com.github.housepower.jdbc.stream.ValuesWithParametersInputFormat;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ClickHousePreparedInsertStatement
extends AbstractPreparedStatement {
    private final int posOfData;
    private final String fullQuery;
    private final String insertQuery;
    private final List<Object[]> parameters;

    public ClickHousePreparedInsertStatement(int posOfData, String fullQuery, ClickHouseConnection conn) throws SQLException {
        super(conn, null, ClickHousePreparedInsertStatement.computeQuestionMarkSize(fullQuery, posOfData));
        this.posOfData = posOfData;
        this.fullQuery = fullQuery;
        this.parameters = new ArrayList<Object[]>();
        this.insertQuery = fullQuery.substring(0, posOfData);
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeQuery() != null;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.parameters.add(((AbstractPreparedStatement)this).parameters);
        return this.connection.sendInsertRequest(this.insertQuery, new ValuesWithParametersInputFormat(this.fullQuery, this.posOfData, this.parameters));
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.executeUpdate();
        return null;
    }

    @Override
    public void addBatch() throws SQLException {
        this.parameters.add(((AbstractPreparedStatement)this).parameters);
        ((AbstractPreparedStatement)this).parameters = new Object[((AbstractPreparedStatement)this).parameters.length];
    }

    @Override
    public void clearBatch() throws SQLException {
        this.parameters.clear();
        ((AbstractPreparedStatement)this).parameters = new Object[((AbstractPreparedStatement)this).parameters.length];
    }

    @Override
    public int[] executeBatch() throws SQLException {
        Integer rows = this.connection.sendInsertRequest(this.insertQuery, new ValuesWithParametersInputFormat(this.fullQuery, this.posOfData, this.parameters));
        int[] result = new int[rows.intValue()];
        Arrays.fill(result, -1);
        return result;
    }

    private static int computeQuestionMarkSize(String query, int start) throws SQLException {
        int param = 0;
        boolean inQuotes = false;
        boolean inBackQuotes = false;
        for (int i = 0; i < query.length(); ++i) {
            char ch = query.charAt(i);
            if (ch == '`') {
                inBackQuotes = !inBackQuotes;
                continue;
            }
            if (ch == '\'') {
                inQuotes = !inQuotes;
                continue;
            }
            if (inBackQuotes || inQuotes || ch != '?') continue;
            Validate.isTrue(i > start, "");
            ++param;
        }
        return param;
    }
}

