/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.serializer;

import com.github.housepower.jdbc.buffer.BuffedWriter;
import com.github.housepower.jdbc.buffer.CompressedBuffedWriter;
import com.github.housepower.jdbc.buffer.SocketBuffedWriter;
import com.github.housepower.jdbc.misc.Container;
import com.github.housepower.jdbc.misc.StringView;
import com.github.housepower.jdbc.misc.StringViewCoding;
import com.github.housepower.jdbc.settings.ClickHouseDefines;
import java.io.IOException;
import java.net.Socket;
import java.sql.SQLException;

public class BinarySerializer {
    private final Container<BuffedWriter> container;

    public BinarySerializer(Socket socket) throws IOException {
        SocketBuffedWriter socketWriter = new SocketBuffedWriter(socket);
        this.container = new Container<CompressedBuffedWriter>((CompressedBuffedWriter)((Object)socketWriter), new CompressedBuffedWriter(ClickHouseDefines.DEFAULT_BUFFER_SIZE, socketWriter));
    }

    public void writeVarInt(long x) throws IOException {
        for (int i = 0; i < 9; ++i) {
            byte byt = (byte)(x & 0x7FL);
            if (x > 127L) {
                byt = (byte)(byt | 0x80);
            }
            this.container.get().writeBinary(byt);
            if ((x >>= 7) != 0L) continue;
            return;
        }
    }

    public void writeByte(byte x) throws IOException {
        this.container.get().writeBinary(x);
    }

    public void writeBoolean(boolean x) throws IOException {
        this.writeVarInt((byte)(x ? 1 : 0));
    }

    public void writeShort(short i) throws IOException {
        this.container.get().writeBinary((byte)(i & 0xFF));
        this.container.get().writeBinary((byte)(i >> 8 & 0xFF));
    }

    public void writeInt(int i) throws IOException {
        this.container.get().writeBinary((byte)(i & 0xFF));
        this.container.get().writeBinary((byte)(i >> 8 & 0xFF));
        this.container.get().writeBinary((byte)(i >> 16 & 0xFF));
        this.container.get().writeBinary((byte)(i >> 24 & 0xFF));
    }

    public void writeLong(long i) throws IOException {
        this.container.get().writeBinary((byte)(i & 0xFFL));
        this.container.get().writeBinary((byte)(i >> 8 & 0xFFL));
        this.container.get().writeBinary((byte)(i >> 16 & 0xFFL));
        this.container.get().writeBinary((byte)(i >> 24 & 0xFFL));
        this.container.get().writeBinary((byte)(i >> 32 & 0xFFL));
        this.container.get().writeBinary((byte)(i >> 40 & 0xFFL));
        this.container.get().writeBinary((byte)(i >> 48 & 0xFFL));
        this.container.get().writeBinary((byte)(i >> 56 & 0xFFL));
    }

    public void writeStringBinary(String binary) throws IOException {
        byte[] bs = binary.getBytes();
        this.writeVarInt(bs.length);
        this.container.get().writeBinary(bs);
    }

    public void flushToTarget(boolean force) throws IOException {
        this.container.get().flushToTarget(force);
    }

    public void maybeEnableCompressed() {
        this.container.select(true);
    }

    public void maybeDisableCompressed() throws IOException {
        this.container.get().flushToTarget(true);
        this.container.select(false);
    }

    public void writeFloat(float datum) throws IOException {
        int x = Float.floatToIntBits(datum);
        this.container.get().writeBinary((byte)(x & 0xFF));
        this.container.get().writeBinary((byte)(x >>> 8 & 0xFF));
        this.container.get().writeBinary((byte)(x >>> 16 & 0xFF));
        this.container.get().writeBinary((byte)(x >>> 24 & 0xFF));
    }

    public void writeDouble(double datum) throws IOException {
        long x = Double.doubleToLongBits(datum);
        this.container.get().writeBinary((byte)(x & 0xFFL));
        this.container.get().writeBinary((byte)(x >>> 8 & 0xFFL));
        this.container.get().writeBinary((byte)(x >>> 16 & 0xFFL));
        this.container.get().writeBinary((byte)(x >>> 24 & 0xFFL));
        this.container.get().writeBinary((byte)(x >>> 32 & 0xFFL));
        this.container.get().writeBinary((byte)(x >>> 40 & 0xFFL));
        this.container.get().writeBinary((byte)(x >>> 48 & 0xFFL));
        this.container.get().writeBinary((byte)(x >>> 56 & 0xFFL));
    }

    public void writeBytes(byte[] bytes) throws IOException {
        this.container.get().writeBinary(bytes);
    }

    public void writeStringViewBinary(StringView data) throws IOException, SQLException {
        this.writeVarInt(data.end() - data.start());
        this.container.get().writeBinary(StringViewCoding.bytes(data));
    }
}

